/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.refactoring;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.ale.ide.Activator;
import org.eclipse.emf.ecoretools.ale.ide.project.AleProjectPreferences;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.osgi.service.prefs.BackingStoreException;

public class RenamePathsInProjectPreferencesChange
extends Change {
    private final IProject project;
    private final IFile oldDslFile;
    private final IFile newDslFile;
    private final Collection<String> behaviors;
    private final Collection<String> metamodels;

    public RenamePathsInProjectPreferencesChange(IProject project, IFile oldDslFile, IFile newDslFile, Collection<String> behaviors, Collection<String> metamodels) {
        this.project = Objects.requireNonNull(project, "project");
        this.oldDslFile = oldDslFile;
        this.newDslFile = newDslFile;
        this.behaviors = Objects.requireNonNull(behaviors, "behaviors");
        this.metamodels = Objects.requireNonNull(metamodels, "metamodels");
    }

    public String getName() {
        return "Update preferences of '" + this.project.getName() + "'";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Object getModifiedElement() {
        return this.project;
    }

    public Object[] getAffectedObjects() {
        return new Object[]{this.project};
    }

    public Change perform(IProgressMonitor monitor) throws CoreException {
        boolean pathsAreStoredInPreferences;
        ProjectScope context = new ProjectScope(this.project);
        IEclipsePreferences preferences = context.getNode("org.eclipse.emf.ecoretools.ale.core");
        if (this.newDslFile != null) {
            URI dslFileURI = URI.createPlatformResourceURI((String)this.newDslFile.getFullPath().toPortableString(), (boolean)true);
            preferences.put(AleProjectPreferences.DSL_FILE_PATH.property(), dslFileURI.toString());
        }
        List<String> currentBehaviors = Arrays.asList(preferences.get(AleProjectPreferences.ALE_SOURCE_FILES.property(), "").split(","));
        List<String> currentMetamodels = Arrays.asList(preferences.get(AleProjectPreferences.ECORE_MODEL_FILES.property(), "").split(","));
        boolean bl = pathsAreStoredInPreferences = !preferences.getBoolean(AleProjectPreferences.CONFIGURED_FROM_DSL_FILE.property(), false);
        if (pathsAreStoredInPreferences) {
            preferences.put(AleProjectPreferences.ALE_SOURCE_FILES.property(), RenamePathsInProjectPreferencesChange.commaSeparated(this.behaviors));
            preferences.put(AleProjectPreferences.ECORE_MODEL_FILES.property(), RenamePathsInProjectPreferencesChange.commaSeparated(this.metamodels));
        }
        try {
            preferences.flush();
            RenamePathsInProjectPreferencesChange undo = new RenamePathsInProjectPreferencesChange(this.project, this.newDslFile, this.oldDslFile, currentBehaviors, currentMetamodels);
            return undo;
        }
        catch (BackingStoreException e) {
            Activator.error("Unable to update " + this.project.getName() + "'s preferences impacted by refactoring", e);
            return null;
        }
    }

    private static String commaSeparated(Collection<String> elements) {
        return String.join((CharSequence)",", elements);
    }
}

