/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.BehaviorsParser;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.ide.env.WithAbsoluteBehaviorPathsAleEnvironment;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class AleResource
extends ResourceImpl {
    protected BehaviorsParser parser;
    protected List<ParsedFile<ModelUnit>> parseResult;
    private boolean isNotifyEnabled = true;

    public AleResource(URI uri, BehaviorsParser parser) {
        super(uri);
        this.parser = parser;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (WithAbsoluteBehaviorPathsAleEnvironment dslFile = new WithAbsoluteBehaviorPathsAleEnvironment((IAleEnvironment)new FileBasedAleEnvironment(inputStream));){
            List newParseResult = this.parser.parse(dslFile.getMetamodels(), (Set)dslFile.getBehaviorsSources());
            if (newParseResult != null) {
                this.unload();
                this.parseResult = newParseResult;
                List newContent = this.parseResult.stream().map(pr -> (ModelUnit)pr.getRoot()).collect(Collectors.toList());
                this.isNotifyEnabled = false;
                this.getContents().addAll(newContent);
                this.isNotifyEnabled = true;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void doUnload() {
        super.doUnload();
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
    }

    public List<ParsedFile<ModelUnit>> getParseResult() {
        return this.parseResult;
    }

    public boolean eNotificationRequired() {
        if (this.isNotifyEnabled) {
            return super.eNotificationRequired();
        }
        return false;
    }

    public void save(Map<?, ?> options) throws IOException {
    }
}

