/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import fr.inria.diverse.melange.metamodel.melange.LanguageOperator;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * A specialized {@link OperatorBuilder} dedicated to {@link LanguageOperator}s,
 * ie. {@link Inheritance}, {@link Merge}, and {@link Slice}.
 */
@SuppressWarnings("all")
public abstract class LanguageOperatorBuilder<T extends LanguageOperator> extends OperatorBuilder<T> {
  /**
   * The set of {@link EPackage} built from the {@link Language}
   * pointed by the current {@link LanguageOperator}.
   */
  protected Set<EPackage> targetModel;

  /**
   * The {@link ModelTypingSpaceBuilder} used to build the {@link ModelTypingSpace}
   * to which the current {@link LanguageOperator} belongs.
   */
  protected ModelTypingSpaceBuilder root;

  public LanguageOperatorBuilder(final T op, final ModelTypingSpaceBuilder root) {
    super(op);
    this.root = root;
    this.targetModel = CollectionLiterals.<EPackage>newHashSet();
  }

  @Override
  public void preBuild() {
    super.preBuild();
    final LanguageBuilder langBuilder = this.root.getBuilder(this.source.getTargetLanguage());
    boolean _isBuilding = langBuilder.isBuilding();
    if (_isBuilding) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Cyclic dependency between ");
      String _name = this.source.getTargetLanguage().getName();
      _builder.append(_name);
      _builder.append(" ");
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("and ");
      String _name_1 = this.source.getOwningLanguage().getName();
      _builder_1.append(_name_1);
      String _plus = (_builder.toString() + _builder_1);
      BuilderError _builderError = new BuilderError(_plus, this.source);
      this.errors.add(_builderError);
    }
    this.targetModel = langBuilder.model;
    if ((this.targetModel.isEmpty() && langBuilder.errors.isEmpty())) {
      langBuilder.build();
      boolean _isEmpty = langBuilder.errors.isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Language ");
        String _name_2 = this.source.getTargetLanguage().getName();
        _builder_2.append(_name_2);
        _builder_2.append(" has errors ");
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("in its definition");
        String _plus_1 = (_builder_2.toString() + _builder_3);
        BuilderError _builderError_1 = new BuilderError(_plus_1, this.source);
        this.errors.add(_builderError_1);
      }
      this.targetModel = langBuilder.model;
    }
  }
}
