/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.utils;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@SuppressWarnings("all")
public class TypeReferencesHelper {
  @Inject
  private CommonTypeComputationServices services;

  public LightweightTypeReference toLightweightTypeReference(final JvmTypeReference typeRef, final Resource context) {
    LightweightTypeReference _xifexpression = null;
    if (((typeRef != null) && (context != null))) {
      _xifexpression = new StandardTypeReferenceOwner(this.services, context).toLightweightTypeReference(typeRef);
    } else {
      _xifexpression = null;
    }
    return _xifexpression;
  }

  public boolean isSubtypeOf(final JvmTypeReference ref, final Class<?> cls) {
    LightweightTypeReference _lightweightTypeReference = null;
    if (ref!=null) {
      Resource _eResource = null;
      if (ref!=null) {
        _eResource=ref.eResource();
      }
      _lightweightTypeReference=this.toLightweightTypeReference(ref, _eResource);
    }
    final LightweightTypeReference lightweightRef = _lightweightTypeReference;
    boolean _xifexpression = false;
    if ((lightweightRef != null)) {
      _xifexpression = lightweightRef.isSubtypeOf(cls);
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }

  public boolean isSubtypeOf(final JvmTypeReference r1, final JvmTypeReference r2) {
    boolean _xifexpression = false;
    if (((r1 != null) && (r2 != null))) {
      _xifexpression = this.toLightweightTypeReference(r1, r1.eResource()).isSubtypeOf(r2.getType());
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }

  public boolean isCollection(final JvmTypeReference ref) {
    boolean _xifexpression = false;
    if ((ref != null)) {
      _xifexpression = (this.isSubtypeOf(ref, Collection.class) && (ref.getType() instanceof JvmTypeParameterDeclarator));
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }

  public boolean isList(final JvmTypeReference ref) {
    boolean _xifexpression = false;
    if ((ref != null)) {
      _xifexpression = (this.isSubtypeOf(ref, List.class) && Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("java.util.List", "java.util.ArrayList", "org.eclipse.emf.common.util.EList")).contains(ref.getType().getQualifiedName()));
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }

  public JvmType getContainedElementsType(final JvmTypeReference ref) {
    boolean _isList = this.isList(ref);
    if (_isList) {
      return IterableExtensions.<JvmTypeReference>head(((JvmParameterizedTypeReference) ref).getArguments()).getType();
    }
    return null;
  }
}
