/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LookalikeStrings {
    private final String original;
    private final Set<String> lookalikes;
    private SortedSet<Lookalike> bestLookalikesFirst;

    public static LookalikeStringsBuilder compare(String original) {
        return new LookalikeStringsBuilder(original);
    }

    public LookalikeStrings(String original, Collection<String> lookalikes) {
        this.original = original;
        this.lookalikes = new HashSet<String>(lookalikes);
    }

    public LinkedHashSet<String> getNBests(int n) {
        LinkedHashSet<String> bests = new LinkedHashSet<String>();
        Iterator iterator = this.getSortedLookalikes().iterator();
        int i = 0;
        while (i < n) {
            if (!iterator.hasNext()) break;
            bests.add(((Lookalike)iterator.next()).text);
            ++i;
        }
        return bests;
    }

    private SortedSet<Lookalike> getSortedLookalikes() {
        if (this.bestLookalikesFirst == null) {
            this.bestLookalikesFirst = new TreeSet<Lookalike>();
            for (String lookalike : this.lookalikes) {
                this.bestLookalikesFirst.add(new Lookalike(lookalike, this.relevancyOf(lookalike)));
            }
        }
        return this.bestLookalikesFirst;
    }

    private Relevancy relevancyOf(String lookalike) {
        int count = 0;
        int firstDifferenceIndex = -1;
        int originalOffset = 0;
        int lookalikeOffset = 0;
        if (this.original.startsWith("self.")) {
            originalOffset = "self.".length();
        }
        if (lookalike.startsWith("self.")) {
            lookalikeOffset = "self.".length();
        }
        int i = 0;
        while (i + originalOffset < this.original.length() && i + lookalikeOffset < lookalike.length()) {
            if (this.original.charAt(i + originalOffset) != lookalike.charAt(i + lookalikeOffset)) {
                ++count;
                if (firstDifferenceIndex == -1) {
                    firstDifferenceIndex = i;
                }
            }
            ++i;
        }
        return new Relevancy(firstDifferenceIndex, count += Math.abs(this.original.length() - lookalike.length()));
    }

    public String getOriginal() {
        return this.original;
    }

    private static class Lookalike
    implements Comparable<Lookalike> {
        String text;
        Relevancy relevancy;

        public Lookalike(String text, Relevancy relevancy) {
            this.text = text;
            this.relevancy = relevancy;
        }

        @Override
        public int compareTo(Lookalike other) {
            int comp = this.relevancy.compareTo(other.relevancy);
            if (comp == 0) {
                return this.text.compareTo(other.text);
            }
            return comp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.relevancy == null ? 0 : this.relevancy.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Lookalike other = (Lookalike)obj;
            if (this.relevancy == null ? other.relevancy != null : !this.relevancy.equals(other.relevancy)) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }

    public static class LookalikeStringsBuilder {
        private String original;
        private Set<String> lookalikes = new HashSet<String>();

        public LookalikeStringsBuilder(String original) {
            this.original = original;
        }

        public LookalikeStringsBuilder with(String lookalike) {
            this.lookalikes.add(lookalike);
            return this;
        }

        public LookalikeStringsBuilder with(Collection<String> newLookalikes) {
            this.lookalikes.addAll(newLookalikes);
            return this;
        }

        public LookalikeStrings now() {
            return new LookalikeStrings(this.original, this.lookalikes);
        }
    }

    private static class Relevancy
    implements Comparable<Relevancy> {
        int differences;
        int firstDifferenceIndex;

        public Relevancy(int firstDifferenceIndex, int differences) {
            this.differences = differences;
            this.firstDifferenceIndex = firstDifferenceIndex;
        }

        @Override
        public int compareTo(Relevancy other) {
            if (this.differences != other.differences) {
                return this.differences - other.differences;
            }
            return this.firstDifferenceIndex - other.firstDifferenceIndex;
        }

        public String toString() {
            return String.valueOf(this.differences) + " ; " + this.firstDifferenceIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.differences;
            result = 31 * result + this.firstDifferenceIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Relevancy other = (Relevancy)obj;
            if (this.differences != other.differences) {
                return false;
            }
            return this.firstDifferenceIndex == other.firstDifferenceIndex;
        }
    }
}

