/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.services;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ale.core.Activator;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.ExtensionLookupEngine;
import org.eclipse.emf.ecoretools.ale.core.validation.IConvertType;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ConvertType;

public class SelectedCallService {
    private ExtensionLookupEngine lookupEngine;
    private IQueryEnvironment queryEnvironment;
    private IConvertType convert;

    public SelectedCallService(IQueryEnvironment queryEnvironment, ExtensionLookupEngine lookupEngine) {
        this.queryEnvironment = queryEnvironment;
        this.lookupEngine = lookupEngine;
        this.convert = new ConvertType((IReadOnlyQueryEnvironment)queryEnvironment);
    }

    public IService createService() {
        try {
            final Method method = SelectedCallService.class.getMethod("selectedCall", EObject.class, String.class, String.class, String.class, Object[].class);
            return new JavaMethodService(method, this){

                protected Object internalInvoke(Object[] arguments) throws Exception {
                    List<Object> allArgs = Arrays.asList(arguments);
                    ArrayList<Object> invokeArgs = new ArrayList<Object>(allArgs);
                    if (arguments.length > 4) {
                        List<Object> selection = allArgs.subList(0, 4);
                        Object[] realArgs = allArgs.subList(4, allArgs.size()).toArray();
                        invokeArgs.retainAll(selection);
                        invokeArgs.add(realArgs);
                    } else {
                        Object[] realArgs = Arrays.asList(new Object[0]).toArray();
                        invokeArgs.add(realArgs);
                    }
                    return method.invoke((Object)SelectedCallService.this, invokeArgs.toArray());
                }

                public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
                    return Sets.newHashSet((Object[])new IType[]{new NothingType("SelectedCallService cannot determine the return type of the method")});
                }
            };
        }
        catch (NoSuchMethodException | SecurityException e) {
            Activator.error("Cannot create the SelectedCallService service", e);
            return null;
        }
    }

    public Object selectedCall(EObject caller, String modelUnitID, String className, String methodName, Object[] args) {
        List<Object> allArgs = Arrays.asList(caller);
        allArgs = new ArrayList<Object>(allArgs);
        Collections.addAll(allArgs, args);
        IType[] types = this.getArgumentTypes(allArgs.toArray());
        IService service = this.lookupEngine.filteredLookup(modelUnitID, className, methodName, types);
        return service.invoke(allArgs.toArray());
    }

    private IType[] getArgumentTypes(Object[] arguments) {
        IType[] argumentTypes = new IType[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argumentTypes[i] = arguments[i] == null ? new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, null) : (arguments[i] instanceof EObject ? new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)((EObject)arguments[i]).eClass()) : new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, arguments[i].getClass()));
            ++i;
        }
        return argumentTypes;
    }
}

