/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.visible;

import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertActivationState;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockActivationState;
import fr.inria.aoste.timesquare.backend.manager.helpers.ClockStateCheckBoxAdapter;
import fr.inria.aoste.timesquare.backend.manager.helpers.ColorAdapter;
import fr.inria.aoste.timesquare.backend.manager.helpers.ComboAdapter;
import fr.inria.aoste.timesquare.backend.manager.helpers.TreeAdapter;
import fr.inria.aoste.timesquare.backend.manager.utils.IFilter;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManagerGUI;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.node.CompatorClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.node.CompatorModelElementReference;
import fr.inria.aoste.timesquare.backend.manager.visible.node.CompatorRelationEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.node.Node;
import fr.inria.aoste.timesquare.backend.manager.visible.node.NodeLabelProvider;
import fr.inria.aoste.timesquare.backend.manager.visible.node.NodeTreeContentProvider;
import fr.inria.aoste.timesquare.launcher.debug.model.output.OutputSetupOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class GUIHelper {
    public static String COMBOSELECTION = "combo.selection";
    private ConfigurationHelper controller;
    private BehaviorManagerGUI gui;

    public GUIHelper(BehaviorManagerGUI gui) {
        this.gui = gui;
    }

    public GUIHelper(ConfigurationHelper c, BehaviorManagerGUI gui) {
        this.controller = c;
        this.gui = gui;
    }

    public void setConfigurationHelper(ConfigurationHelper controller) {
        this.controller = controller;
    }

    private List<ClockEntity> getClocks() {
        if (this.controller == null) {
            return Collections.emptyList();
        }
        return this.controller.getClocks();
    }

    private List<ClockEntity> getAssert() {
        if (this.controller == null) {
            return Collections.emptyList();
        }
        return this.controller.getAssert();
    }

    private List<RelationEntity> getRelationEntities() {
        if (this.controller == null) {
            return Collections.emptyList();
        }
        return this.controller.getRelationEntities();
    }

    public ClockActivationState displayClockState(Composite composite) {
        return this.displayClockState(composite, null);
    }

    public ClockActivationState displayClockState(Composite composite, Object layoutdata) {
        return this.displayClockState(composite, layoutdata, null);
    }

    public ClockActivationState displayClockState(Composite composite, Object layoutdata, String id) {
        if (composite == null) {
            return new ClockActivationState(null);
        }
        boolean[] tab = new boolean[ClockActivationState.stateNumber];
        ClockActivationState cas = new ClockActivationState(tab);
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setText("Clock Activation State");
        if (layoutdata != null) {
            group.setLayoutData(layoutdata);
        }
        ClockActivationState.StateGroup[] stateGroupArray = ClockActivationState.StateGroup.values();
        int n = stateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClockActivationState.StateGroup g = stateGroupArray[n2];
            Group group2 = new Group((Composite)group, 4);
            group2.setText(g.name());
            group2.setLayout((Layout)new GridLayout(2, true));
            group2.setLayoutData((Object)new GridData(4, 0, true, false));
            ClockActivationState.State[] stateArray = ClockActivationState.State.state(g);
            int n3 = stateArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ClockActivationState.State s = stateArray[n4];
                Button check = new Button((Composite)group2, 32);
                check.setText(s.name);
                check.addSelectionListener((SelectionListener)new ClockStateCheckBoxAdapter(tab, s.i));
                check.setLayoutData((Object)new GridData(4, 0, true, false));
                if (s == ClockActivationState.State.ticks) {
                    check.setSelection(true);
                    tab[s.i] = true;
                }
                this.registerID(check, String.valueOf(id) + "." + s.name);
                ++n4;
            }
            ++n2;
        }
        group.pack();
        this.registerID(group, id);
        return cas;
    }

    public boolean[] displayAssertStateCheckBox(Composite composite) {
        if (composite == null) {
            return new boolean[0];
        }
        boolean[] tab = new boolean[2];
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setText("Assert Activation State");
        String[] assertState = AssertActivationState.assertlist;
        int i = 0;
        while (i < assertState.length) {
            Button check = new Button((Composite)group, 32);
            check.setText(assertState[i]);
            check.addSelectionListener((SelectionListener)new ClockStateCheckBoxAdapter(tab, i));
            if (i == 0) {
                check.setEnabled(false);
            }
            ++i;
        }
        group.pack();
        return tab;
    }

    public boolean[] displayAssertStateCheckBox(Composite composite, Object layoutdata) {
        if (composite == null) {
            return new boolean[0];
        }
        boolean[] tab = new boolean[2];
        Group group = new Group(composite, 4);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setText("Assert Activation State");
        group.setLayoutData(layoutdata);
        String[] assertState = AssertActivationState.assertlist;
        int i = 0;
        while (i < assertState.length) {
            Button check = new Button((Composite)group, 32);
            check.setText(assertState[i]);
            check.addSelectionListener((SelectionListener)new ClockStateCheckBoxAdapter(tab, i));
            if (i == 0) {
                check.setEnabled(false);
            }
            ++i;
        }
        group.pack();
        return tab;
    }

    public Combo displayListClock(Composite composite, String id) {
        List<ClockEntity> elements = this.getClocks();
        return this.displayList(composite, elements, id);
    }

    public TreeViewer displayTreeClock(Composite composite, String id, int type) {
        if (composite == null) {
            return null;
        }
        ArrayList<ClockEntity> elements = new ArrayList<ClockEntity>(this.getClocks());
        Collections.sort(elements, new CompatorClockEntity(new CompatorModelElementReference(false)));
        List result = Node.buildListNodesClockEntity(elements);
        Node.optimise(result);
        return this.displayTree(composite, id, result, type);
    }

    public Combo displayListAssert(Composite composite, String id) {
        List<ClockEntity> elements = this.getAssert();
        return this.displayList(composite, elements, id);
    }

    public Combo displayListRelation(Composite composite, String id) {
        List<RelationEntity> elements = this.getRelationEntities();
        return this.displayList(composite, elements, id);
    }

    public TreeViewer displayTreeRelation(Composite composite, String id) {
        if (composite == null) {
            return null;
        }
        ArrayList<RelationEntity> elements = new ArrayList<RelationEntity>(this.getRelationEntities());
        Collections.sort(elements, new CompatorRelationEntity());
        List result = Node.buildListNodesRelationEntity(elements);
        Node.optimise(result);
        return this.displayTree(composite, id, result, 4);
    }

    public <T> TreeViewer displayTree(Composite composite, String id, List<Node<T>> result, int type) {
        Tree tree = new Tree(composite, 0x808 | type | 0x10 | 0x200 | 0x100);
        TreeColumn column = null;
        column = new TreeColumn(tree, 16384, 0);
        column.setMoveable(false);
        column.setWidth(450);
        tree.setData(COMBOSELECTION, new Object());
        tree.pack();
        tree.setHeaderVisible(true);
        TreeViewer tv = new TreeViewer(tree);
        tv.setContentProvider((IContentProvider)new NodeTreeContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tv);
        tv.setLabelProvider((IBaseLabelProvider)new NodeLabelProvider());
        tv.setInput(result);
        tree.addSelectionListener((SelectionListener)new TreeAdapter(this.gui));
        tree.setSize(400, 400);
        this.registerID(tree, id);
        return tv;
    }

    public Combo displayList(Composite composite, List<?> elements, String id) {
        if (composite == null || elements == null) {
            return null;
        }
        Combo comboElements = new Combo(composite, 8);
        comboElements.setData(COMBOSELECTION, new Object());
        for (Object e : elements) {
            comboElements.add(e.toString());
        }
        comboElements.addSelectionListener((SelectionListener)new ComboAdapter(elements, this.gui));
        comboElements.pack();
        if (elements.size() != 0) {
            comboElements.setData(COMBOSELECTION, elements.get(0));
            comboElements.select(0);
        }
        return this.registerID(comboElements, id);
    }

    public <T> Combo displayList(Composite composite, List<? extends T> elements, IFilter<T> filter, String id) {
        if (composite == null) {
            return null;
        }
        ArrayList<T> lst = new ArrayList<T>();
        Combo comboElements = new Combo(composite, 8);
        comboElements.setData(COMBOSELECTION, new Object());
        if (elements != null) {
            for (T e : elements) {
                if (filter != null && !filter.accept(e)) continue;
                comboElements.add(e.toString());
                lst.add(e);
            }
        }
        comboElements.addSelectionListener((SelectionListener)new ComboAdapter(lst, this.gui));
        comboElements.pack();
        if (lst.size() != 0) {
            comboElements.setData(COMBOSELECTION, lst.get(0));
            comboElements.select(0);
        }
        return this.registerID(comboElements, id);
    }

    public RGB displayColorDialog(Composite composite) {
        if (composite == null) {
            return null;
        }
        RGB color = new RGB(255, 255, 255);
        Button button = new Button(composite, 8);
        button.setText("Colors");
        button.addSelectionListener((SelectionListener)new ColorAdapter(color, composite, button));
        return color;
    }

    public Object getSelection(Combo c) {
        return c.getData(COMBOSELECTION);
    }

    public <T extends Widget> T registerID(T w, String id) {
        return (T)OutputSetupOption.registerID(w, (String)id);
    }
}

