/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BasicTypePackage;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BooleanElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.RealElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Type;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.And;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntDivide;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntEqual;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntInf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntMinus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntMultiply;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntPlus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntSup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.Not;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.NumberSeqVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.Or;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.RealVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqDecr;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqGetHead;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqGetTail;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqIsEmpty;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.SeqSched;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.util.ClassicalExpressionSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.AbstractConcreteMapping;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.EvaluationTypeError;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.ExceptionWrapper;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnimplementedEvaluation;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;

public class ClassicalExpressionEvaluator {
    private AbstractConcreteMapping<InstantiatedElement> acm;
    private ClassicalExpressionSwitch<Element> evaluator = new ClassicalExpressionSwitch<Element>(){

        public Element caseClassicalExpression(ClassicalExpression object) {
            throw new ExceptionWrapper(new UnimplementedEvaluation(String.valueOf(object.getName()) + ":" + object.toString()));
        }

        public Element caseIntegerVariableRef(IntegerVariableRef object) {
            InstantiatedElement value = (InstantiatedElement)ClassicalExpressionEvaluator.this.acm.resolveAbstractEntity(object.getReferencedVar());
            if (!(value.getInstantiationPath().getLast() instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntegerVariableRef: IntegerElement expected"));
            }
            return (Element)value.getInstantiationPath().getLast();
        }

        public Element caseRealVariableRef(RealVariableRef object) {
            InstantiatedElement value = (InstantiatedElement)ClassicalExpressionEvaluator.this.acm.resolveAbstractEntity(object.getReferencedVar());
            if (!(value.getInstantiationPath().getLast() instanceof RealElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("RealVariableRef: RealElement expected"));
            }
            return (Element)value.getInstantiationPath().getLast();
        }

        public Element caseAnd(And object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof BooleanElement) || !(right instanceof BooleanElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("And: BooleanElement expected"));
            }
            BooleanElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBooleanElement();
            res.setName(String.valueOf(left.getName()) + " AND " + right.getName());
            res.setType((Type)BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBoolean());
            res.setValue(Boolean.valueOf(((BooleanElement)left).getValue() != false && ((BooleanElement)right).getValue() != false));
            return res;
        }

        public Element caseOr(Or object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof BooleanElement) || !(right instanceof BooleanElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("And: BooleanElement expected"));
            }
            BooleanElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBooleanElement();
            res.setName(String.valueOf(left.getName()) + " AND " + right.getName());
            res.setType((Type)BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBoolean());
            res.setValue(Boolean.valueOf(((BooleanElement)left).getValue() != false || ((BooleanElement)right).getValue() != false));
            return res;
        }

        public Element caseNot(Not object) {
            BooleanExpression operand = object.getOperand();
            Element operandValue = ClassicalExpressionEvaluator.this.evaluate((Element)operand);
            if (!(operandValue instanceof BooleanElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("Not: BooleanElement expected"));
            }
            BooleanElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBooleanElement();
            res.setName(String.valueOf(object.getName()) + ":" + operand.getName());
            res.setType((Type)BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBoolean());
            res.setValue(Boolean.valueOf(((BooleanElement)operandValue).getValue() == false));
            return res;
        }

        public Element caseIntEqual(IntEqual object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof IntegerElement) || !(right instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntEqual: IntegerElement expected"));
            }
            BooleanElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBooleanElement();
            res.setName(String.valueOf(left.getName()) + "==" + right.getName());
            res.setType((Type)BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBoolean());
            res.setValue(Boolean.valueOf(((IntegerElement)left).getValue() == ((IntegerElement)right).getValue()));
            return res;
        }

        public Element caseIntInf(IntInf object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof IntegerElement) || !(right instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntEqual: IntegerElement expected"));
            }
            BooleanElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBooleanElement();
            res.setName(String.valueOf(left.getName()) + "<" + right.getName());
            res.setType((Type)BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBoolean());
            res.setValue(Boolean.valueOf(((IntegerElement)left).getValue() < ((IntegerElement)right).getValue()));
            return res;
        }

        public Element caseIntSup(IntSup object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof IntegerElement) || !(right instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntEqual: IntegerElement expected"));
            }
            BooleanElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBooleanElement();
            res.setName(String.valueOf(left.getName()) + ">" + right.getName());
            res.setType((Type)BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBoolean());
            res.setValue(Boolean.valueOf(((IntegerElement)left).getValue() > ((IntegerElement)right).getValue()));
            return res;
        }

        public Element caseSeqIsEmpty(SeqIsEmpty object) {
            Element operand = ClassicalExpressionEvaluator.this.evaluate((Element)object.getOperand());
            if (!(operand instanceof SequenceElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("SeqIsEmpty: SolverSequenceElement expected"));
            }
            BooleanElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBooleanElement();
            res.setName("isEmpty(" + operand.getName() + ")");
            res.setType((Type)BasicTypePackage.eINSTANCE.getBasicTypeFactory().createBoolean());
            res.setValue(Boolean.valueOf(this.isEmptySequence((SequenceElement)operand)));
            return res;
        }

        private boolean isEmptySequence(SequenceElement seq) {
            return seq.getFinitePart().isEmpty() && seq.getNonFinitePart().isEmpty();
        }

        public Element caseIntegerRef(IntegerRef object) {
            return object.getIntegerElem();
        }

        public Element caseIntPlus(IntPlus object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof IntegerElement) || !(right instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntPlus: IntegerElement expected"));
            }
            IntegerElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createIntegerElement();
            res.setValue(Integer.valueOf(((IntegerElement)left).getValue() + ((IntegerElement)right).getValue()));
            res.setType(left.getType());
            return res;
        }

        public Element caseIntMinus(IntMinus object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof IntegerElement) || !(right instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntMinus: IntegerElement expected"));
            }
            IntegerElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createIntegerElement();
            res.setValue(Integer.valueOf(((IntegerElement)left).getValue() - ((IntegerElement)right).getValue()));
            res.setType(left.getType());
            return res;
        }

        public Element caseIntMultiply(IntMultiply object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof IntegerElement) || !(right instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntMultiply: IntegerElement expected"));
            }
            IntegerElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createIntegerElement();
            res.setValue(Integer.valueOf(((IntegerElement)left).getValue() * ((IntegerElement)right).getValue()));
            res.setType(left.getType());
            return res;
        }

        public Element caseIntDivide(IntDivide object) {
            Element left = ClassicalExpressionEvaluator.this.evaluate((Element)object.getLeftValue());
            Element right = ClassicalExpressionEvaluator.this.evaluate((Element)object.getRightValue());
            if (!(left instanceof IntegerElement) || !(right instanceof IntegerElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("IntDivide: IntegerElement expected"));
            }
            IntegerElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createIntegerElement();
            res.setValue(Integer.valueOf(((IntegerElement)left).getValue() / ((IntegerElement)right).getValue()));
            res.setType(left.getType());
            return res;
        }

        public Element caseSeqGetHead(SeqGetHead object) {
            SeqExpression operand = object.getOperand();
            Element value = ClassicalExpressionEvaluator.this.evaluate((Element)operand);
            if (!(value instanceof SequenceElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("SeqGetHead: SolverSequenceElement expected"));
            }
            PrimitiveElement res = ClassicalExpressionEvaluator.this.getSequenceHead((SequenceElement)value);
            return ClassicalExpressionEvaluator.this.evaluate((Element)res);
        }
    };
    private ClassicalExpressionSwitch<SequenceElement> seqEvaluator = new ClassicalExpressionSwitch<SequenceElement>(){

        public SequenceElement caseClassicalExpression(ClassicalExpression object) {
            throw new ExceptionWrapper(new UnimplementedEvaluation(String.valueOf(object.getName()) + ":" + object.toString()));
        }

        public SequenceElement caseSeqGetTail(SeqGetTail object) {
            SeqExpression operand = object.getOperand();
            Element value = ClassicalExpressionEvaluator.this.evaluate((Element)operand);
            if (!(value instanceof SequenceElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("SeqGetTail: SolverSequenceElement expected"));
            }
            SequenceElement res = this.getSequenceTail((SequenceElement)value);
            return res;
        }

        private SequenceElement getSequenceTail(SequenceElement seq) {
            SequenceElement res = BasicTypePackage.eINSTANCE.getBasicTypeFactory().createSequenceElement();
            if (!seq.getFinitePart().isEmpty()) {
                res.getFinitePart().addAll((Collection)seq.getFinitePart());
                res.getFinitePart().remove(0);
            } else {
                res.getFinitePart().addAll((Collection)seq.getNonFinitePart());
                res.getFinitePart().remove(0);
                res.getNonFinitePart().addAll((Collection)seq.getNonFinitePart());
            }
            return res;
        }

        public SequenceElement caseSeqDecr(SeqDecr object) {
            throw new ExceptionWrapper(new UnimplementedEvaluation("SeqDecr: unimplemented"));
        }

        public SequenceElement caseSeqSched(SeqSched object) {
            throw new ExceptionWrapper(new UnimplementedEvaluation("SeqSched: unimplemented"));
        }

        public SequenceElement caseNumberSeqVariableRef(NumberSeqVariableRef object) {
            InstantiatedElement value = (InstantiatedElement)ClassicalExpressionEvaluator.this.acm.resolveAbstractEntity(object.getReferencedVar());
            NamedElement res = value.getInstantiationPath().getLast();
            if (!(res instanceof SequenceElement)) {
                throw new ExceptionWrapper(new EvaluationTypeError("NumberSeqVariableRef: SolverSequenceElement expected"));
            }
            return (SequenceElement)res;
        }
    };

    public ClassicalExpressionEvaluator(AbstractConcreteMapping<InstantiatedElement> acm) {
        this.acm = acm;
    }

    public Element evaluate(InstantiatedElement elt) throws UnfoldingException {
        try {
            return this.evaluate((Element)elt.getInstantiationPath().getLast());
        }
        catch (ExceptionWrapper e) {
            throw (UnfoldingException)e.getCause();
        }
    }

    private Element evaluate(Element elt) {
        if (elt instanceof ClassicalExpression) {
            if (elt instanceof SeqExpression) {
                return (Element)this.seqEvaluator.doSwitch((EObject)elt);
            }
            Element res = (Element)this.evaluator.doSwitch((EObject)elt);
            return res;
        }
        return elt;
    }

    private PrimitiveElement getSequenceHead(SequenceElement seq) {
        if (seq.getFinitePart().isEmpty()) {
            if (seq.getNonFinitePart().isEmpty()) {
                return null;
            }
            return (PrimitiveElement)seq.getNonFinitePart().get(0);
        }
        return (PrimitiveElement)seq.getFinitePart().get(0);
    }
}

