/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.extension.alternates;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.AbstractConcreteMapping;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.SolverException;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.UnboundAbstract;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.ISolverRelationFactory;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.alternates.BlackboxAlternates;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.AbstractWrappedRelation;

public class AlternatesRelationFactory
implements ISolverRelationFactory {
    public boolean canHandle(RelationDeclaration declaration, ExternalRelationDefinition definition) {
        if (declaration.getName().compareTo("Alternates") != 0) {
            return false;
        }
        if (declaration.getParameters().size() != 2) {
            return false;
        }
        boolean leftFound = false;
        boolean rightFound = false;
        for (AbstractEntity parameter : declaration.getParameters()) {
            if (parameter.getName().compareTo("AlternatesLeftClock") == 0) {
                leftFound = true;
                continue;
            }
            if (parameter.getName().compareTo("AlternatesRightClock") != 0) continue;
            rightFound = true;
        }
        return leftFound && rightFound;
    }

    public AbstractWrappedRelation createRelation(RelationDeclaration declaration, ExternalRelationDefinition definition, AbstractConcreteMapping<ISolverElement> context) throws SolverException {
        BlackboxAlternates newRelation = new BlackboxAlternates();
        boolean leftClockDefined = false;
        boolean rightClockDefined = false;
        for (AbstractEntity parameter : declaration.getParameters()) {
            ISolverElement value = (ISolverElement)context.getLocalValue(parameter);
            if (parameter.getName().compareTo("AlternatesLeftClock") == 0 && value instanceof SolverClock) {
                newRelation.setLeftClock((SolverClock)value);
                leftClockDefined = true;
                ((SolverClock)value).incRefCount();
            }
            if (parameter.getName().compareTo("AlternatesRightClock") != 0 || !(value instanceof SolverClock)) continue;
            newRelation.setRightClock((SolverClock)value);
            rightClockDefined = true;
            ((SolverClock)value).incRefCount();
        }
        if (!leftClockDefined) {
            throw new UnboundAbstract("BlackBoxAlternates: left clock is undefined");
        }
        if (!rightClockDefined) {
            throw new UnboundAbstract("BlackBoxAlternates: right clock is undefined");
        }
        return newRelation;
    }
}

