/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.launcher.tabs;

import fr.inria.diverse.k3.al.annotationprocessor.InitializeModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.commons.eclipse.emf.URIHelper;
import org.eclipse.gemoc.commons.eclipse.ui.dialogs.SelectAnyIFileDialog;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.ConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.launcher.LauncherMessages;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.launcher.tabs.LaunchConfigurationTab;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.ICodeExecutor;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.deciders.DeciderSpecificationExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.deciders.DeciderSpecificationExtensionPoint;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.ConcurrentLanguageDefinitionExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.ConcurrentLanguageDefinitionExtensionPoint;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectAIRDIFileDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LaunchConfigurationMainTab
extends LaunchConfigurationTab {
    protected Composite _parent;
    protected Text _modelLocationText;
    protected Text _modelInitializationMethodText;
    protected Text _modelInitializationArgumentsText;
    protected Text _siriusRepresentationLocationText;
    protected Button _animateButton;
    protected Text _delayText;
    protected Combo _languageCombo;
    protected Combo _deciderCombo;
    protected Text modelofexecutionglml_LocationText;
    public int GRID_DEFAULT_WIDTH = 200;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        this._parent = parent;
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        area.setLayout((Layout)gl);
        area.layout();
        this.setControl((Control)area);
        Group modelArea = this.createGroup(area, "Model:");
        this.createModelLayout((Composite)modelArea, null);
        Group languageArea = this.createGroup(area, "Language:");
        this.createLanguageLayout((Composite)languageArea, null);
        Group debugArea = this.createGroup(area, "Animation:");
        this.createAnimationLayout((Composite)debugArea, null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("GEMOC_ANIMATE_DELAY", 1000);
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_DECIDER", "Step by step user decider");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ConcurrentRunConfiguration runConfiguration = new ConcurrentRunConfiguration(configuration);
            this._modelLocationText.setText(URIHelper.removePlatformScheme((URI)runConfiguration.getExecutedModelURI()));
            if (runConfiguration.getAnimatorURI() != null) {
                this._siriusRepresentationLocationText.setText(URIHelper.removePlatformScheme((URI)runConfiguration.getAnimatorURI()));
            } else {
                this._siriusRepresentationLocationText.setText("");
            }
            this._delayText.setText(Integer.toString(runConfiguration.getAnimationDelay()));
            this._languageCombo.setText(runConfiguration.getLanguageName());
            this._deciderCombo.setText(runConfiguration.getDeciderName());
            this._modelInitializationArgumentsText.setText(runConfiguration.getModelInitializationArguments());
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Resource", this._modelLocationText.getText());
        configuration.setAttribute("airdResource", this._siriusRepresentationLocationText.getText());
        configuration.setAttribute("GEMOC_ANIMATE_DELAY", Integer.parseInt(this._delayText.getText()));
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", this._languageCombo.getText());
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_DECIDER", this._deciderCombo.getText());
        configuration.setAttribute("GEMOC_LAUNCH_INITIALIZATION_METHOD", this._modelInitializationMethodText.getText());
        configuration.setAttribute("GEMOC_LAUNCH_INITIALIZATION_ARGUMENTS", this._modelInitializationArgumentsText.getText());
    }

    public String getName() {
        return "Main";
    }

    public Composite createModelLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Model to execute");
        this._modelLocationText = new Text(parent, 2052);
        this._modelLocationText.setLayoutData((Object)this.createStandardLayout());
        this._modelLocationText.setFont(font);
        this._modelLocationText.addModifyListener(this.fBasicModifyListener);
        Button modelLocationButton = this.createPushButton(parent, "Browse", null);
        modelLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAnyIFileDialog dialog = new SelectAnyIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    LaunchConfigurationMainTab.this._modelLocationText.setText(modelPath);
                    LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.createTextLabelLayout(parent, "Model initialization method");
        this._modelInitializationMethodText = new Text(parent, 2052);
        this._modelInitializationMethodText.setLayoutData((Object)this.createStandardLayout());
        this._modelInitializationMethodText.setFont(font);
        this._modelInitializationMethodText.setEditable(false);
        this.createTextLabelLayout(parent, "");
        this.createTextLabelLayout(parent, "Model initialization arguments");
        this._modelInitializationArgumentsText = new Text(parent, 2626);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 40;
        this._modelInitializationArgumentsText.setLayoutData((Object)gridData);
        this._modelInitializationArgumentsText.setFont(font);
        this._modelInitializationArgumentsText.setEditable(true);
        this._modelInitializationArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "");
        return parent;
    }

    private Composite createAnimationLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Animator");
        this._siriusRepresentationLocationText = new Text(parent, 2052);
        this._siriusRepresentationLocationText.setLayoutData((Object)this.createStandardLayout());
        this._siriusRepresentationLocationText.setFont(font);
        this._siriusRepresentationLocationText.addModifyListener(this.fBasicModifyListener);
        Button siriusRepresentationLocationButton = this.createPushButton(parent, "Browse", null);
        siriusRepresentationLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAIRDIFileDialog dialog = new SelectAIRDIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    LaunchConfigurationMainTab.this._siriusRepresentationLocationText.setText(modelPath);
                    LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.createTextLabelLayout(parent, "Delay");
        this._delayText = new Text(parent, 2052);
        this._delayText.setLayoutData((Object)this.createStandardLayout());
        this._delayText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "(in milliseconds)");
        this.createTextLabelLayout(parent, "Decider");
        this._deciderCombo = new Combo(parent, 2048);
        this._deciderCombo.setLayoutData((Object)this.createStandardLayout());
        ArrayList<String> deciders = new ArrayList<String>();
        for (DeciderSpecificationExtension definition : DeciderSpecificationExtensionPoint.getSpecifications()) {
            deciders.add(definition.getName());
        }
        String[] a = new String[deciders.size()];
        this._deciderCombo.setItems(deciders.toArray(a));
        this._deciderCombo.select(0);
        this._deciderCombo.addModifyListener(this.fBasicModifyListener);
        new Label(parent, 0).setText("");
        return parent;
    }

    private GridData createStandardLayout() {
        return new GridData(4, 0x1000000, true, false);
    }

    public Composite createLanguageLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "DSL languages");
        this._languageCombo = new Combo(parent, 0);
        this._languageCombo.setLayoutData((Object)this.createStandardLayout());
        List languagesNames = DslHelper.getAllLanguages();
        String[] empty = new String[]{};
        this._languageCombo.setItems(languagesNames.toArray(empty));
        this._languageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "");
        return parent;
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        ConcurrentLanguageDefinitionExtension languageDefinitionExtPoint = ConcurrentLanguageDefinitionExtensionPoint.findDefinition((String)this._languageCombo.getText());
        if (languageDefinitionExtPoint != null) {
            this._modelInitializationMethodText.setText(this.getModelInitializationMethodName(languageDefinitionExtPoint));
        } else {
            this._modelInitializationMethodText.setText("");
        }
        this._modelInitializationArgumentsText.setEnabled(!this._modelInitializationMethodText.getText().isEmpty());
    }

    protected String getModelInitializationMethodName(ConcurrentLanguageDefinitionExtension languageDefinitionExtension) {
        try {
            ICodeExecutor codeExecutor = languageDefinitionExtension.instanciateCodeExecutor();
            URI uri = URI.createPlatformResourceURI((String)this._modelLocationText.getText(), (boolean)true);
            Object caller = EMFResource.getFirstContent((URI)uri);
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(new String[1]);
            List methods = codeExecutor.findCompatibleMethodsWithAnnotation(caller, parameters, InitializeModel.class);
            parameters.clear();
            parameters.add(new ArrayList());
            methods.addAll(codeExecutor.findCompatibleMethodsWithAnnotation(caller, parameters, InitializeModel.class));
            parameters.clear();
            parameters.add(new BasicEList());
            methods.addAll(codeExecutor.findCompatibleMethodsWithAnnotation(caller, parameters, InitializeModel.class));
            if (!methods.isEmpty()) {
                Method selectedMethod = (Method)methods.get(0);
                return String.valueOf(selectedMethod.getDeclaringClass().getCanonicalName()) + "." + selectedMethod.getName();
            }
        }
        catch (CoreException e) {
            Activator.warn(e.getMessage(), e);
        }
        return "";
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String modelName = this._modelLocationText.getText().trim();
        if (modelName.length() > 0) {
            IResource modelIResource = workspace.getRoot().findMember(modelName);
            if (modelIResource == null || !modelIResource.exists()) {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.ConcurrentMainTab_model_doesnt_exist, (Object[])new String[]{modelName}));
                return false;
            }
            if (modelName.equals("/")) {
                this.setErrorMessage(LauncherMessages.ConcurrentMainTab_Model_not_specified);
                return false;
            }
            if (!(modelIResource instanceof IFile)) {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.ConcurrentMainTab_invalid_model_file, (Object[])new String[]{modelName}));
                return false;
            }
        }
        if (modelName.length() == 0) {
            this.setErrorMessage(LauncherMessages.ConcurrentMainTab_Model_not_specified);
            return false;
        }
        String languageName = this._languageCombo.getText().trim();
        if (languageName.length() == 0) {
            this.setErrorMessage(LauncherMessages.ConcurrentMainTab_Language_not_specified);
            return false;
        }
        return true;
    }
}

