/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.DefaultConcurrentExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.LogicalStepDeciderFactory;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.ILogicalStepDecider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.ConcurrentLanguageDefinitionExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.ConcurrentLanguageDefinitionExtensionPoint;
import org.eclipse.gemoc.executionframework.engine.commons.AbstractModelExecutionContext;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionModel;
import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;

public class ConcurrentModelExecutionContext
extends AbstractModelExecutionContext<IConcurrentRunConfiguration, IConcurrentExecutionPlatform, ConcurrentLanguageDefinitionExtension>
implements IConcurrentExecutionContext {
    public String alternativeExecutionModelPath = null;
    protected ActionModel _feedbackModel;
    protected ILogicalStepDecider _logicalStepDecider;
    protected MSEModel _mseModel;

    public ConcurrentModelExecutionContext(IConcurrentRunConfiguration runConfiguration, ExecutionMode executionMode) throws EngineContextException {
        super((IRunConfiguration)runConfiguration, executionMode);
        try {
            this._logicalStepDecider = LogicalStepDeciderFactory.createDecider(runConfiguration.getDeciderName(), executionMode);
        }
        catch (CoreException e) {
            EngineContextException exception = new EngineContextException("Cannot initialize the execution context, see inner exception.", (Exception)((Object)e));
            throw exception;
        }
    }

    protected IConcurrentExecutionPlatform createExecutionPlatform() throws CoreException {
        return new DefaultConcurrentExecutionPlatform((ConcurrentLanguageDefinitionExtension)this._languageDefinition, this._runConfiguration);
    }

    protected ConcurrentLanguageDefinitionExtension getLanguageDefinition(String languageName) throws EngineContextException {
        ConcurrentLanguageDefinitionExtension languageDefinition = ConcurrentLanguageDefinitionExtensionPoint.findDefinition((String)((IConcurrentRunConfiguration)this._runConfiguration).getLanguageName());
        if (languageDefinition == null) {
            String message = "Cannot find concurrent xdsml definition for the language " + ((IConcurrentRunConfiguration)this._runConfiguration).getLanguageName() + ", please verify that is is correctly deployed.";
            EngineContextException exception = new EngineContextException(message);
            throw exception;
        }
        return languageDefinition;
    }

    public void setUpMSEModel() {
        URI msemodelPlatformURI = URI.createPlatformResourceURI((String)this.getWorkspace().getMSEModelPath().removeFileExtension().addFileExtension("msemodel").toString(), (boolean)true);
        try {
            Resource resource = this.getResourceModel().getResourceSet().getResource(msemodelPlatformURI, true);
            this._mseModel = (MSEModel)resource.getContents().get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUpFeedbackModel() {
        URI feedbackPlatformURI = URI.createPlatformResourceURI((String)this.getWorkspace().getMSEModelPath().removeFileExtension().addFileExtension("feedback").toString(), (boolean)true);
        try {
            Resource resource = this.getResourceModel().getResourceSet().getResource(feedbackPlatformURI, true);
            this._feedbackModel = (ActionModel)resource.getContents().get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        super.dispose();
        this._logicalStepDecider.dispose();
    }

    public MSEModel getMSEModel() {
        if (this._mseModel == null) {
            this.setUpMSEModel();
        }
        return this._mseModel;
    }

    public ILogicalStepDecider getLogicalStepDecider() {
        return this._logicalStepDecider;
    }

    public ActionModel getFeedbackModel() {
        return this._feedbackModel;
    }
}

