/**
 * generated by Xtext
 */
package org.eclipse.gemoc.gexpressions.xtext.scoping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gemoc.gexpressions.GEnumLiteralExpression;
import org.eclipse.gemoc.gexpressions.GExpression;
import org.eclipse.gemoc.gexpressions.GNavigationExpression;
import org.eclipse.gemoc.gexpressions.GReferenceExpression;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it
 */
@SuppressWarnings("all")
public class GExpressionsScopeProvider extends AbstractDeclarativeScopeProvider {
  public IScope scope_GNavigationExpression_referencedEObject(final GNavigationExpression exp, final EReference ref) {
    final IScope scope = this.scopeForNavigation(exp.getBody(), this.delegateGetScope(exp, ref));
    return this.filterScopeForNavigation(scope, exp.getBody());
  }
  
  protected IScope filterScopeForNavigation(final IScope scope, final GExpression exp) {
    return scope;
  }
  
  protected IScope _scopeForNavigation(final GNavigationExpression exp, final IScope outerScope) {
    return this.getNavigationScopeForEObject(exp.getReferencedEObject(), outerScope);
  }
  
  protected IScope _scopeForNavigation(final GReferenceExpression source, final IScope outerScope) {
    return this.getNavigationScopeForEObject(source.getReferencedEObject(), outerScope);
  }
  
  protected IScope _getNavigationScopeForEObject(final EObject eo, final IScope outerScope) {
    return this.getScopeOfNavigableElementsForType(eo.eClass(), outerScope);
  }
  
  protected IScope _getNavigationScopeForEObject(final ETypedElement eo, final IScope outerScope) {
    return this.getScopeOfNavigableElementsForType(eo.getEType(), outerScope);
  }
  
  protected IScope _getNavigationScopeForEObject(final EClassifier eo, final IScope outerScope) {
    return this.getScopeOfNavigableElementsForType(eo, outerScope);
  }
  
  protected IScope _getNavigationScopeForEObject(final EPackage eo, final IScope outerScope) {
    return this.getScopeOfNavigableElementsForType(eo, outerScope);
  }
  
  protected IScope _getScopeOfNavigableElementsForType(final EClass type, final IScope outerScope) {
    return Scopes.scopeFor(this.getAllNavigableElementsOfType(type));
  }
  
  /**
   * Returns all the navigable elements of an EClass, a.k.a. the EOperations, EAttributes and EReferences.
   */
  protected final Collection<ETypedElement> getAllNavigableElementsOfType(final EClass type) {
    final EList<EStructuralFeature> allStructuralFeatures = type.getEAllStructuralFeatures();
    final EList<EOperation> allOperations = type.getEAllOperations();
    final ArrayList<ETypedElement> allNavigableElements = new ArrayList<ETypedElement>();
    allNavigableElements.addAll(allStructuralFeatures);
    allNavigableElements.addAll(allOperations);
    return allNavigableElements;
  }
  
  protected IScope _getScopeOfNavigableElementsForType(final EDataType type, final IScope outerScope) {
    return IScope.NULLSCOPE;
  }
  
  protected IScope _getScopeOfNavigableElementsForType(final EPackage ePackage, final IScope outerScope) {
    final EList<EPackage> allSubPackages = ePackage.getESubpackages();
    final EList<EClassifier> allClassifiers = ePackage.getEClassifiers();
    final ArrayList<EObject> allNavigableElements = new ArrayList<EObject>();
    allNavigableElements.addAll(allSubPackages);
    allNavigableElements.addAll(allClassifiers);
    return Scopes.scopeFor(allNavigableElements);
  }
  
  public IScope scope_GEnumLiteralExpression_value(final GEnumLiteralExpression exp, final EReference ref) {
    final ArrayList<EEnumLiteral> list = new ArrayList<EEnumLiteral>();
    final ResourceSet resourceSet = exp.eResource().getResourceSet();
    EList<Resource> _resources = resourceSet.getResources();
    for (final Resource resource : _resources) {
      {
        final TreeIterator<EObject> iterator = resource.getAllContents();
        while (iterator.hasNext()) {
          {
            EObject eo = iterator.next();
            if ((eo instanceof EEnumLiteral)) {
              list.add(((EEnumLiteral) eo));
            }
          }
        }
      }
    }
    final Function1<EEnumLiteral, IEObjectDescription> _function = new Function1<EEnumLiteral, IEObjectDescription>() {
      @Override
      public IEObjectDescription apply(final EEnumLiteral enumLiteral) {
        return EObjectDescription.create(enumLiteral.getName(), enumLiteral);
      }
    };
    List<IEObjectDescription> _map = ListExtensions.<EEnumLiteral, IEObjectDescription>map(list, _function);
    return new SimpleScope(IScope.NULLSCOPE, _map);
  }
  
  protected IScope scopeForNavigation(final GExpression exp, final IScope outerScope) {
    if (exp instanceof GNavigationExpression) {
      return _scopeForNavigation((GNavigationExpression)exp, outerScope);
    } else if (exp instanceof GReferenceExpression) {
      return _scopeForNavigation((GReferenceExpression)exp, outerScope);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(exp, outerScope).toString());
    }
  }
  
  protected IScope getNavigationScopeForEObject(final EObject eo, final IScope outerScope) {
    if (eo instanceof EClassifier) {
      return _getNavigationScopeForEObject((EClassifier)eo, outerScope);
    } else if (eo instanceof EPackage) {
      return _getNavigationScopeForEObject((EPackage)eo, outerScope);
    } else if (eo instanceof ETypedElement) {
      return _getNavigationScopeForEObject((ETypedElement)eo, outerScope);
    } else if (eo != null) {
      return _getNavigationScopeForEObject(eo, outerScope);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(eo, outerScope).toString());
    }
  }
  
  protected IScope getScopeOfNavigableElementsForType(final ENamedElement type, final IScope outerScope) {
    if (type instanceof EClass) {
      return _getScopeOfNavigableElementsForType((EClass)type, outerScope);
    } else if (type instanceof EDataType) {
      return _getScopeOfNavigableElementsForType((EDataType)type, outerScope);
    } else if (type instanceof EPackage) {
      return _getScopeOfNavigableElementsForType((EPackage)type, outerScope);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(type, outerScope).toString());
    }
  }
}
