/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.gemoc.generator.codegen;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.trace.commons.CodeGenUtil;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class StateManagerGeneratorJava {
  private final String className;
  
  private final String packageQN;
  
  private final EPackage traceMM;
  
  private final TraceMMGenerationTraceability traceability;
  
  private final Set<GenPackage> refGenPackages;
  
  private final String stateFQN;
  
  private final String valueFQN;
  
  private boolean getTracedToExeUsed = false;
  
  public String getClassName() {
    return this.className;
  }
  
  public StateManagerGeneratorJava(final String languageName, final String packageQN, final EPackage traceMM, final TraceMMGenerationTraceability traceability, final Set<GenPackage> refGenPackages) {
    this.traceMM = traceMM;
    String _firstUpper = StringExtensions.toFirstUpper(languageName.replaceAll(" ", ""));
    String _plus = (_firstUpper + "StateManager");
    this.className = _plus;
    this.packageQN = packageQN;
    this.traceability = traceability;
    this.refGenPackages = refGenPackages;
    this.stateFQN = this.getJavaFQN(traceability.getTraceMMExplorer().getSpecificStateClass());
    this.valueFQN = this.getJavaFQN(traceability.getTraceMMExplorer().getSpecificValueClass());
  }
  
  private String getFQN(final EStructuralFeature eFeature) {
    String _baseFQN = EcoreCraftingUtil.getBaseFQN(eFeature.getEContainingClass());
    String _plus = (_baseFQN + ".");
    String _name = eFeature.getName();
    return (_plus + _name);
  }
  
  private String getJavaFQN(final EClassifier c) {
    return this.getJavaFQN(c, false);
  }
  
  private String getJavaFQN(final EClassifier c, final boolean enforcePrimitiveJavaClass) {
    return EcoreCraftingUtil.getJavaFQN(c, this.refGenPackages, enforcePrimitiveJavaClass);
  }
  
  public String generateCode() {
    final String code = this.generateStateManagerClass();
    try {
      return CodeGenUtil.formatJavaCode(code);
    } catch (final Throwable _t) {
      if (_t instanceof Throwable) {
        return code;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  private String stringGetterExeValue(final String javaVarName, final EStructuralFeature p, final EClass typeToCastTo) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((p instanceof EReference) && this.traceability.hasTracedClass(((EClass) p.getEType())))) {
        _builder.newLine();
        {
          boolean _isMany = p.isMany();
          if (_isMany) {
            _builder.append("(Collection<? extends ");
            String _javaFQN = this.getJavaFQN(p.getEType(), true);
            _builder.append(_javaFQN);
            _builder.append(">) ");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("(");
            String _javaFQN_1 = this.getJavaFQN(p.getEType(), true);
            _builder.append(_javaFQN_1);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          }
        }
        String _tracedToExeMethodName = this.getTracedToExeMethodName();
        _builder.append(_tracedToExeMethodName);
        _builder.append("(((");
        String _javaFQN_2 = this.getJavaFQN(typeToCastTo);
        _builder.append(_javaFQN_2);
        _builder.append(") ");
        _builder.append(javaVarName);
        _builder.append(").");
        String _stringGetter = EcoreCraftingUtil.stringGetter(p);
        _builder.append(_stringGetter);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("((");
        String _javaFQN_3 = this.getJavaFQN(typeToCastTo);
        _builder.append(_javaFQN_3);
        _builder.append(") ");
        _builder.append(javaVarName);
        _builder.append(").");
        String _stringGetter_1 = EcoreCraftingUtil.stringGetter(p);
        _builder.append(_stringGetter_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString();
  }
  
  private String getTracedToExeMethodName() {
    this.getTracedToExeUsed = true;
    return "getTracedToExe";
  }
  
  private String generateImports() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import java.util.ArrayList;");
    _builder.newLine();
    _builder.append("import java.util.Collection;");
    _builder.newLine();
    _builder.append("import java.util.Map;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.EObject;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.resource.Resource;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.transaction.RecordingCommand;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.transaction.TransactionalEditingDomain;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.transaction.util.TransactionUtil;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.State;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.gemoc.api.IStateManager;");
    _builder.newLine();
    return _builder.toString();
  }
  
  private String generateFields() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private final Resource modelResource;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("private final Map<TracedObject<?>, EObject> tracedToExe;");
    _builder.newLine();
    return _builder.toString();
  }
  
  private String generateConstructors() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    _builder.append(this.className);
    _builder.append("(Resource modelResource, Map<TracedObject<?>, EObject> tracedToExe) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.modelResource = modelResource;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.tracedToExe = tracedToExe;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  private String generateMethods() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("public void restoreState(State<?, ?> state) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (modelResource != null && state instanceof ");
    _builder.append(this.stateFQN, "\t");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("final TransactionalEditingDomain ed = TransactionUtil.getEditingDomain(modelResource);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (ed != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("final RecordingCommand command = new RecordingCommand(ed, \"\") {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("protected void doExecute() {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("restoreStateExecute((");
    _builder.append(this.stateFQN, "\t\t\t\t\t\t");
    _builder.append(") state);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("CommandExecution.execute(ed, command);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw e;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("private EObject getTracedToExe(EObject tracedObject) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return tracedToExe.get(tracedObject);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("private Collection<? extends EObject> getTracedToExe(Collection<? extends EObject> tracedObjects) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Collection<EObject> result = new ArrayList<EObject>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (EObject tracedObject : tracedObjects) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("result.add(tracedToExe.get(tracedObject));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("@SuppressWarnings(\"unchecked\")");
    _builder.newLine();
    _builder.append("private void restoreStateExecute(");
    _builder.append(this.stateFQN);
    _builder.append(" state) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (");
    _builder.append(this.valueFQN, "\t");
    _builder.append(" value : state.getValues()) {");
    _builder.newLineIfNotEmpty();
    {
      final Function1<EStructuralFeature, String> _function = new Function1<EStructuralFeature, String>() {
        @Override
        public String apply(final EStructuralFeature it) {
          return StateManagerGeneratorJava.this.getFQN(it);
        }
      };
      List<EStructuralFeature> _sortBy = IterableExtensions.<EStructuralFeature, String>sortBy(this.traceability.getAllMutableProperties(), _function);
      boolean _hasElements = false;
      for(final EStructuralFeature p : _sortBy) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate("else", "\t\t");
        }
        _builder.append("\t\t");
        final EReference pdimension = this.traceability.getDimensionRef(p);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        final EClass tracedObjectClass = pdimension.getEContainingClass();
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        final EClass valueClass = this.traceability.getValueClass(p);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (value instanceof ");
        String _javaFQN = this.getJavaFQN(valueClass);
        _builder.append(_javaFQN, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t");
        _builder.append("final ");
        String _javaFQN_1 = this.getJavaFQN(tracedObjectClass);
        _builder.append(_javaFQN_1, "\t\t\t");
        _builder.append(" tracedObject = (");
        String _javaFQN_2 = this.getJavaFQN(tracedObjectClass);
        _builder.append(_javaFQN_2, "\t\t\t");
        _builder.append(") value.eContainer().eContainer();");
        _builder.newLineIfNotEmpty();
        {
          EObject _eContainer = p.eContainer();
          boolean _contains = this.traceability.getNewClasses().contains(((EClass) _eContainer));
          if (_contains) {
            _builder.append("\t\t");
            _builder.append("\t");
            EObject _eContainer_1 = p.eContainer();
            final EClass extendedClass = ((EClass) _eContainer_1);
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("final ");
            String _javaFQN_3 = this.getJavaFQN(extendedClass);
            _builder.append(_javaFQN_3, "\t\t\t");
            _builder.append(" originalObject = (");
            String _javaFQN_4 = this.getJavaFQN(extendedClass);
            _builder.append(_javaFQN_4, "\t\t\t");
            _builder.append(") tracedToExe.get(tracedObject);");
            _builder.newLineIfNotEmpty();
            {
              boolean _isMany = p.isMany();
              if (_isMany) {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("originalObject.");
                String _stringGetter = EcoreCraftingUtil.stringGetter(p);
                _builder.append(_stringGetter, "\t\t\t");
                _builder.append(".clear();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("originalObject.");
                String _stringGetter_1 = EcoreCraftingUtil.stringGetter(p);
                _builder.append(_stringGetter_1, "\t\t\t");
                _builder.append(".addAll(");
                String _stringGetterExeValue = this.stringGetterExeValue("value", p, valueClass);
                _builder.append(_stringGetterExeValue, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("final ");
                String _javaFQN_5 = this.getJavaFQN(p.getEType());
                _builder.append(_javaFQN_5, "\t\t\t");
                _builder.append(" toSet = ");
                String _stringGetterExeValue_1 = this.stringGetterExeValue("value", p, valueClass);
                _builder.append(_stringGetterExeValue_1, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("final ");
                String _javaFQN_6 = this.getJavaFQN(p.getEType());
                _builder.append(_javaFQN_6, "\t\t\t");
                _builder.append(" current = originalObject.");
                String _stringGetter_2 = EcoreCraftingUtil.stringGetter(p);
                _builder.append(_stringGetter_2, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("if (current != toSet) {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("originalObject.");
                String _stringSetter = EcoreCraftingUtil.stringSetter(p, "toSet", this.refGenPackages);
                _builder.append(_stringSetter, "\t\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
          } else {
            EObject _eContainer_2 = p.eContainer();
            if ((_eContainer_2 instanceof EClass)) {
              _builder.append("\t\t");
              _builder.append("\t");
              final EClass containingClass = p.getEContainingClass();
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("\t");
              String _javaFQN_7 = this.getJavaFQN(containingClass);
              _builder.append(_javaFQN_7, "\t\t\t");
              _builder.append(" exeObject = (");
              String _javaFQN_8 = this.getJavaFQN(containingClass);
              _builder.append(_javaFQN_8, "\t\t\t");
              _builder.append(") ");
              String _tracedToExeMethodName = this.getTracedToExeMethodName();
              _builder.append(_tracedToExeMethodName, "\t\t\t");
              _builder.append("(tracedObject);");
              _builder.newLineIfNotEmpty();
              {
                boolean _isMany_1 = p.isMany();
                if (_isMany_1) {
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("exeObject.");
                  String _stringGetter_3 = EcoreCraftingUtil.stringGetter(p);
                  _builder.append(_stringGetter_3, "\t\t\t");
                  _builder.append(".clear();");
                  _builder.newLineIfNotEmpty();
                  {
                    if ((p instanceof EReference)) {
                      _builder.append("\t\t");
                      _builder.append("\t");
                      _builder.append("exeObject.");
                      String _stringGetter_4 = EcoreCraftingUtil.stringGetter(p);
                      _builder.append(_stringGetter_4, "\t\t\t");
                      _builder.append(".addAll((Collection<? extends ");
                      String _javaFQN_9 = this.getJavaFQN(((EReference)p).getEType(), true);
                      _builder.append(_javaFQN_9, "\t\t\t");
                      _builder.append(">) ");
                      String _tracedToExeMethodName_1 = this.getTracedToExeMethodName();
                      _builder.append(_tracedToExeMethodName_1, "\t\t\t");
                      _builder.append("(((");
                      String _javaFQN_10 = this.getJavaFQN(valueClass);
                      _builder.append(_javaFQN_10, "\t\t\t");
                      _builder.append(") value).");
                      String _stringGetter_5 = EcoreCraftingUtil.stringGetter(p);
                      _builder.append(_stringGetter_5, "\t\t\t");
                      _builder.append("));");
                      _builder.newLineIfNotEmpty();
                    } else {
                      _builder.append("\t\t");
                      _builder.append("\t");
                      _builder.append("exeObject.");
                      String _stringGetter_6 = EcoreCraftingUtil.stringGetter(p);
                      _builder.append(_stringGetter_6, "\t\t\t");
                      _builder.append(".addAll((Collection<? extends ");
                      String _javaFQN_11 = this.getJavaFQN(p.getEType(), true);
                      _builder.append(_javaFQN_11, "\t\t\t");
                      _builder.append(">) ((");
                      String _javaFQN_12 = this.getJavaFQN(valueClass);
                      _builder.append(_javaFQN_12, "\t\t\t");
                      _builder.append(") value).");
                      String _stringGetter_7 = EcoreCraftingUtil.stringGetter(p);
                      _builder.append(_stringGetter_7, "\t\t\t");
                      _builder.append(");");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                } else {
                  _builder.append("\t\t");
                  _builder.append("\t");
                  _builder.append("exeObject.");
                  String _stringSetter_1 = EcoreCraftingUtil.stringSetter(p, this.stringGetterExeValue("value", p, valueClass), this.refGenPackages);
                  _builder.append(_stringSetter_1, "\t\t\t");
                  _builder.append(";");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  private String generateStateManagerClass() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(this.packageQN);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _generateImports = this.generateImports();
    _builder.append(_generateImports);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.newLine();
    _builder.append("public class ");
    _builder.append(this.className);
    _builder.append(" implements IStateManager<State<?,?>> {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    String _generateFields = this.generateFields();
    _builder.append(_generateFields, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _generateConstructors = this.generateConstructors();
    _builder.append(_generateConstructors, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _generateMethods = this.generateMethods();
    _builder.append(_generateMethods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
}
