/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.tracemetamodel.StepStrings;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TraceMMGeneratorSteps {
    private final OperationalSemanticsView mmext;
    private final TraceMMExplorer traceMMExplorer;
    private final boolean gemoc;
    private final EPackage tracemmresult;
    private final TraceMMGenerationTraceability traceability;
    private final Map<Rule, EClass> stepRuleToClass = new HashMap<Rule, EClass>();
    private final String randomStringToFindGetCallerAnnotations = Integer.valueOf(new Random(10000L).nextInt()).toString();
    private static final String GET_CALLER_OPERATION_NAME = "getCaller";

    public TraceMMGeneratorSteps(OperationalSemanticsView mmext, EPackage tracemmresult, TraceMMGenerationTraceability traceability, TraceMMExplorer traceMMExplorer, boolean gemoc) {
        this.traceability = traceability;
        this.tracemmresult = tracemmresult;
        this.traceMMExplorer = traceMMExplorer;
        this.mmext = mmext;
        this.gemoc = gemoc;
    }

    private void debug(Object stuff) {
    }

    private Set<Rule> gatherRulesThatOverride(Rule rule) {
        HashSet<Rule> result = new HashSet<Rule>();
        result.add(rule);
        result.addAll((Collection<Rule>)rule.getOverridenBy());
        EList _overridenBy = rule.getOverridenBy();
        for (Rule ov : _overridenBy) {
            result.addAll(this.gatherRulesThatOverride(ov));
        }
        return result;
    }

    private Set<Rule> gatherStepCalls(Rule rule, Set<Rule> inProgress) {
        boolean _not;
        HashSet<Rule> result = new HashSet<Rule>();
        boolean _contains = inProgress.contains(rule);
        boolean bl = _not = !_contains;
        if (_not) {
            inProgress.add(rule);
            boolean _isStepRule = rule.isStepRule();
            if (_isStepRule) {
                result.add(rule);
            } else {
                EList _calledRules = rule.getCalledRules();
                for (Rule called : _calledRules) {
                    Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
                    result.addAll(gathered);
                }
            }
        }
        return result;
    }

    private EClass getStepClass(Rule stepRule) {
        boolean _containsKey = this.stepRuleToClass.containsKey(stepRule);
        if (_containsKey) {
            return this.stepRuleToClass.get(stepRule);
        }
        EClass stepClass = EcoreFactory.eINSTANCE.createEClass();
        this.traceMMExplorer.stepsPackage.getEClassifiers().add((Object)stepClass);
        this.stepRuleToClass.put(stepRule, stepClass);
        this.traceability.addStepRuleToStepClass(stepRule, stepClass);
        return stepClass;
    }

    private void setClassNameWithoutConflict(EClass clazz, final String name) {
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return !Objects.equal((Object)c.getName(), null) && c.getName().startsWith(name);
            }
        };
        int nbExistingClassesWithName = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)this.tracemmresult.eAllContents()), EClass.class), (Functions.Function1)_function));
        if (nbExistingClassesWithName > 0) {
            clazz.setName(String.valueOf(name) + "_" + Integer.valueOf(nbExistingClassesWithName));
        } else {
            clazz.setName(name);
        }
    }

    public void process() {
        EList _rules = this.mmext.getRules();
        for (Rule rule : _rules) {
            ImmutableList _immutableCopy = ImmutableList.copyOf((Collection)rule.getCalledRules());
            for (Iterator calledRule : _immutableCopy) {
                Set<Rule> overrides = this.gatherRulesThatOverride((Rule)calledRule);
                rule.getCalledRules().addAll(overrides);
            }
        }
        Predicate<Rule> _function = new Predicate<Rule>(){

            @Override
            public boolean test(Rule it) {
                return it.isAbstract();
            }
        };
        this.mmext.getRules().removeIf((Predicate)_function);
        EList _rules_1 = this.mmext.getRules();
        for (Rule rule_1 : _rules_1) {
            Predicate<Rule> _function_1 = new Predicate<Rule>(){

                @Override
                public boolean test(Rule it) {
                    return it.isAbstract();
                }
            };
            rule_1.getCalledRules().removeIf((Predicate)_function_1);
        }
        Functions.Function1<Rule, Boolean> _function_2 = new Functions.Function1<Rule, Boolean>(){

            public Boolean apply(Rule r) {
                return r.isStepRule();
            }
        };
        Set stepRules = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)this.mmext.getRules(), (Functions.Function1)_function_2));
        ImmutableSet _immutableCopy_1 = ImmutableSet.copyOf((Collection)stepRules);
        for (Rule rule_2 : _immutableCopy_1) {
            Set<Rule> overrides = this.gatherRulesThatOverride(rule_2);
            for (Rule o : overrides) {
                o.setStepRule(true);
                stepRules.add(o);
            }
        }
        for (Rule rule_3 : stepRules) {
            Functions.Function1<Rule, Boolean> _function_3 = new Functions.Function1<Rule, Boolean>(){

                public Boolean apply(Rule r) {
                    boolean _isStepRule = r.isStepRule();
                    return !_isStepRule;
                }
            };
            Set calledNonStepRules = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)rule_3.getCalledRules(), (Functions.Function1)_function_3));
            for (Rule called : calledNonStepRules) {
                HashSet<Rule> inProgress = new HashSet<Rule>();
                Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
                rule_3.getCalledRules().addAll(gathered);
            }
            rule_3.getCalledRules().removeAll((Collection)calledNonStepRules);
        }
        this.mmext.getRules().clear();
        this.mmext.getRules().addAll((Collection)stepRules);
        Functions.Function1<Rule, String> _function_3 = new Functions.Function1<Rule, String>(){

            public String apply(Rule r) {
                String _name = r.getContainingClass().getName();
                String _plus = String.valueOf(_name) + ".";
                String _name_1 = r.getOperation().getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + ": ";
                boolean _isEmpty = r.getCalledRules().isEmpty();
                boolean _not = !_isEmpty;
                return String.valueOf(_plus_2) + Boolean.valueOf(_not);
            }
        };
        Iterable prettyStepRules = IterableExtensions.map((Iterable)stepRules, (Functions.Function1)_function_3);
        this.debug(prettyStepRules);
        Resource mseMetamodelResource = ((EGenericType)IterableExtensions.head((Iterable)this.traceMMExplorer.getSpecificTraceClass().getEGenericSuperTypes())).getEClassifier().eResource();
        Functions.Function1<EClass, Boolean> _function_4 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                return it.getName().equals("SequentialStep");
            }
        };
        EClass mseSequentialStepClass = (EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)mseMetamodelResource.getAllContents()), EClass.class), (Functions.Function1)_function_4);
        Functions.Function1<EClass, Boolean> _function_5 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                return it.getName().equals("SmallStep");
            }
        };
        EClass mseSmallStepClass = (EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IteratorExtensions.toSet((Iterator)mseMetamodelResource.getAllContents()), EClass.class), (Functions.Function1)_function_5);
        for (Rule stepRule : stepRules) {
            EClass stepClass = this.getStepClass(stepRule);
            stepClass.setName(stepRule.getOperation().getName());
            if (this.gemoc && !Objects.equal((Object)stepRule.getContainingClass(), null)) {
                EOperation getCallerEOperation = EcoreFactory.eINSTANCE.createEOperation();
                EClass tracedClass = this.traceability.getTracedClass(stepRule.getContainingClass());
                EClass _xifexpression = null;
                boolean _equals = Objects.equal((Object)tracedClass, null);
                _xifexpression = _equals ? stepRule.getContainingClass() : tracedClass;
                getCallerEOperation.setEType((EClassifier)_xifexpression);
                getCallerEOperation.setLowerBound(1);
                getCallerEOperation.setUpperBound(1);
                getCallerEOperation.setName(GET_CALLER_OPERATION_NAME);
                EAnnotation bodyAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                getCallerEOperation.getEAnnotations().add((Object)bodyAnnotation);
                bodyAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                bodyAnnotation.getDetails().put((Object)"body", (Object)this.randomStringToFindGetCallerAnnotations);
                stepClass.getEOperations().add((Object)getCallerEOperation);
            } else {
                EcoreCraftingUtil.addReferenceToClass((EClass)stepClass, (String)"this", (EClass)stepRule.getContainingClass());
            }
            this.setClassNameWithoutConflict(stepClass, StepStrings.stepClassName((EClass)stepRule.getContainingClass(), (EOperation)stepRule.getOperation()));
            EReference ref = EcoreCraftingUtil.addReferenceToClass((EClass)this.traceMMExplorer.specificTraceClass, (String)TraceMMStrings.ref_createTraceClassToStepClass(stepClass), (EClass)stepClass);
            ref.setLowerBound(0);
            ref.setUpperBound(-1);
            ref.setContainment(false);
            this.traceability.addStepSequence(stepClass, ref);
            this.traceability.addStepClass(stepClass);
            stepClass.getESuperTypes().add((Object)this.traceMMExplorer.getSpecificStepClass());
            boolean _isEmpty = stepRule.getCalledRules().isEmpty();
            if (_isEmpty) {
                EGenericType smallStepGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
                smallStepGenericSuperType.setEClassifier((EClassifier)mseSmallStepClass);
                EGenericType smallStepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
                smallStepGenericSuperType.getETypeArguments().add((Object)smallStepTypeBinding);
                smallStepTypeBinding.setEClassifier((EClassifier)this.traceMMExplorer.specificStateClass);
                stepClass.getEGenericSuperTypes().add((Object)smallStepGenericSuperType);
                continue;
            }
            this.traceability.addBigStepClass(stepClass);
            EGenericType genericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
            genericSuperType.setEClassifier((EClassifier)mseSequentialStepClass);
            EGenericType stepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
            EGenericType stateTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
            CollectionExtensions.addAll((Collection)genericSuperType.getETypeArguments(), (Object[])new EGenericType[]{stepTypeBinding, stateTypeBinding});
            stepClass.getEGenericSuperTypes().add((Object)genericSuperType);
            EClass subStepSuperClass = EcoreFactory.eINSTANCE.createEClass();
            this.traceMMExplorer.stepsPackage.getEClassifiers().add((Object)subStepSuperClass);
            this.setClassNameWithoutConflict(subStepSuperClass, StepStrings.abstractSubStepClassName((EClass)stepRule.getContainingClass(), (EOperation)stepRule.getOperation()));
            subStepSuperClass.setAbstract(true);
            subStepSuperClass.setInterface(true);
            subStepSuperClass.getESuperTypes().add((Object)this.traceMMExplorer.specificStepClass);
            stepTypeBinding.setEClassifier((EClassifier)subStepSuperClass);
            stateTypeBinding.setEClassifier((EClassifier)this.traceMMExplorer.specificStateClass);
            EClass implicitStepClass = EcoreFactory.eINSTANCE.createEClass();
            this.traceMMExplorer.stepsPackage.getEClassifiers().add((Object)implicitStepClass);
            this.setClassNameWithoutConflict(implicitStepClass, StepStrings.implicitStepClassName((EClass)stepRule.getContainingClass(), (EOperation)stepRule.getOperation()));
            implicitStepClass.getESuperTypes().add((Object)subStepSuperClass);
            EGenericType smallStepGenericSuperType_1 = EcoreFactory.eINSTANCE.createEGenericType();
            smallStepGenericSuperType_1.setEClassifier((EClassifier)mseSmallStepClass);
            EGenericType smallStepTypeBinding_1 = EcoreFactory.eINSTANCE.createEGenericType();
            smallStepGenericSuperType_1.getETypeArguments().add((Object)smallStepTypeBinding_1);
            smallStepTypeBinding_1.setEClassifier((EClassifier)this.traceMMExplorer.specificStateClass);
            implicitStepClass.getEGenericSuperTypes().add((Object)smallStepGenericSuperType_1);
            this.traceability.putImplicitStepClass(implicitStepClass, stepRule.getContainingClass());
            EList _calledRules = stepRule.getCalledRules();
            for (Rule calledStepRule : _calledRules) {
                EClass subStepClass = this.getStepClass(calledStepRule);
                subStepClass.getESuperTypes().add((Object)subStepSuperClass);
            }
        }
    }

    public void addGetCallerEOperations(Set<EPackage> traceMetamodel, Set<GenPackage> packages) {
        for (EPackage p : traceMetamodel) {
            Set _set = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)p.eAllContents(), EOperation.class));
            for (EOperation operation : _set) {
                boolean _notEquals;
                Functions.Function1<EAnnotation, Boolean> _function_1;
                Functions.Function1<EAnnotation, Boolean> _function = new Functions.Function1<EAnnotation, Boolean>(){

                    public Boolean apply(EAnnotation a) {
                        return a.getDetails().containsKey((Object)"body");
                    }
                };
                Iterable annotationsWithBody = IterableExtensions.filter((Iterable)operation.getEAnnotations(), (Functions.Function1)_function);
                EAnnotation annotationWithUniqueString = (EAnnotation)IterableExtensions.findFirst((Iterable)annotationsWithBody, (Functions.Function1)(_function_1 = new Functions.Function1<EAnnotation, Boolean>(){

                    public Boolean apply(EAnnotation a) {
                        return ((String)a.getDetails().get((Object)"body")).equals(TraceMMGeneratorSteps.this.randomStringToFindGetCallerAnnotations);
                    }
                }));
                boolean bl = _notEquals = !Objects.equal((Object)annotationWithUniqueString, null);
                if (!_notEquals) continue;
                EMap _details = annotationWithUniqueString.getDetails();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return (");
                String _javaFQN = EcoreCraftingUtil.getJavaFQN((EClassifier)operation.getEType(), packages);
                _builder.append(_javaFQN);
                _builder.append(") this.getMseoccurrence().getMse().getCaller();");
                _details.put((Object)"body", (Object)_builder.toString());
            }
        }
    }
}

