/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.xmi.impl.RootXMLContentHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.ecore.EcoreASResourceFactory;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.AbstractASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.PlatformURIHandlerImpl;
import org.eclipse.ocl.pivot.internal.resource.StandalonePlatformURIHandlerImpl;

public class OCLASResourceFactory
extends AbstractASResourceFactory {
    private static @Nullable OCLASResourceFactory INSTANCE = null;
    private static final @NonNull ContentHandler PIVOT_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.ocl.oclas", new String[]{"oclas"}, "xmi", "http://www.eclipse.org/ocl/2015/Pivot", null);
    private @NonNull URIConverter uriConverter = new ExtensibleURIConverterImpl();

    static {
        OCLASResourceFactory.installContentHandler(0, PIVOT_CONTENT_HANDLER);
    }

    public static synchronized @NonNull OCLASResourceFactory getInstance() {
        if (INSTANCE == null) {
            Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
            Object object = extensionToFactoryMap.get("oclas");
            INSTANCE = object instanceof Resource.Factory.Descriptor ? (OCLASResourceFactory)((Resource.Factory.Descriptor)object).createFactory() : new OCLASResourceFactory();
            assert (INSTANCE != null);
            INSTANCE.install(null, null);
        }
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public OCLASResourceFactory() {
        super("org.eclipse.ocl.oclas");
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            StandalonePlatformURIHandlerImpl.install(this.uriConverter, null);
        } else {
            PlatformURIHandlerImpl.install(this.uriConverter);
        }
    }

    @Override
    public void configure(@NonNull ResourceSet resourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getExtensionToFactoryMap().put("oclas", this);
    }

    @Override
    public Resource createResource(URI uri) {
        URI nonASuri = uri.trimFileExtension();
        String oclasExtension = nonASuri.fileExtension();
        ASResourceFactory asResourceFactory = ASResourceFactoryRegistry.INSTANCE.getASResourceFactoryForExtension(oclasExtension);
        if ((asResourceFactory == null || !nonASuri.isFile()) && this.uriConverter.exists(uri, null)) {
            return super.createResource(uri);
        }
        @NonNull String nonASuriString = nonASuri.toString();
        StandardLibraryContribution standardLibraryContribution = StandardLibraryContribution.REGISTRY.get(nonASuriString);
        if (standardLibraryContribution != null) {
            return standardLibraryContribution.getResource();
        }
        if (asResourceFactory == null) {
            asResourceFactory = EcoreASResourceFactory.getInstance();
        }
        assert (!(asResourceFactory instanceof OCLASResourceFactory));
        return asResourceFactory.createResource(uri);
    }

    @Override
    public @NonNull ASResourceFactory getASResourceFactory() {
        return OCLASResourceFactory.getInstance();
    }
}

