/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core.errorhandler;

import fr.inria.aoste.timesquare.launcher.core.errorhandler.ErrorHandler;
import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ErrorHandlerDisplay
extends ErrorHandler {
    @Override
    public void notifyError(String title, String message, IStatus status) throws Exception {
        super.notifyError(title, message, status);
        Display.getDefault().asyncExec((Runnable)new RunnableErrorMessage(title, message, status));
    }

    private static class RunnableErrorMessage
    implements Runnable {
        private String message;
        private String title;
        private Throwable exp = null;
        private IStatus status = null;

        public RunnableErrorMessage(String title, String message, IStatus status) {
            this.title = title;
            this.message = message;
            this.exp = status.getException();
            this.status = status;
        }

        @Override
        public void run() {
            if (this.exp != null) {
                ErrorConsole.printError((Throwable)this.exp);
            }
            ErrorDialog.openError((Shell)new Shell(), (String)this.title, (String)this.message, (IStatus)this.status);
        }
    }
}

