/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model.values;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLVariable;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.values.CCSLIntValue;
import org.eclipse.debug.core.DebugException;

public final class CCSLIntVariable
extends CCSLVariable {
    public CCSLIntVariable(ICCSLDebugTarget target, String name) {
        super(target, name, "int");
        this.setValue(new CCSLIntValue(target, 0));
    }

    public boolean verifyValue(String expression) throws DebugException {
        try {
            Integer.parseInt(expression);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private CCSLIntValue getIntValue() {
        return (CCSLIntValue)super.getValue();
    }

    @Override
    public void setValue(String expression) {
        super.setValue(expression);
        try {
            this.getIntValue().setValue(Integer.parseInt(expression));
        }
        catch (Exception e) {
            this.getIntValue().setMessage(expression);
        }
    }

    public void setValue(int v) {
        super.setValue(String.valueOf(v));
        this.getIntValue().setValue(v);
    }
}

