/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view.figure;

import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import fr.inria.aoste.timesquare.vcd.view.figure.CountFigure;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class DrawX
extends Polygon
implements ExtendFigure {
    private boolean ghostvisible;
    private int length;
    protected int oldvalue = 0;
    private Point tr = new Point(0, 0);
    private VcdFactory vcd;
    private int x;
    private int y;
    Polyline polyline = null;
    private ExtendFigure.Level precedeLevel;
    private ExtendFigure.Level futurLevel;

    public DrawX(VcdFactory vcd, int x, int y, int length) {
        this.vcd = vcd;
        this.y = y;
        this.x = x;
        this.length = length;
        this.ghostvisible = true;
        CountFigure.inc();
    }

    @Override
    public int incLength(int l) {
        this.length += l;
        return this.length;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Point getTr() {
        return this.tr;
    }

    @Override
    public boolean isGhost() {
        return true;
    }

    public boolean isGhostvisible() {
        return this.ghostvisible;
    }

    @Override
    public int mycompute() {
        if (this.ghostvisible) {
            this.setForegroundColor(this.vcd.getMca().colorGhostClock());
            this.setBackgroundColor(this.vcd.getMca().colorGhostClock());
        } else {
            this.setForegroundColor(this.vcd.getMca().colorClock());
            this.setBackgroundColor(this.vcd.getMca().colorBlack());
        }
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setOpaque(false);
        this.setPoints(new PointList());
        int x2 = this.x + this.length;
        int mx = this.x;
        int mx2 = x2;
        if (this.vcd.getVcdZoom() != null) {
            mx = this.vcd.getVcdZoom().computeposition(this.x);
            mx2 = this.vcd.getVcdZoom().computeposition(x2);
        }
        if (this.ghostvisible) {
            this.addPoint(new Point(mx, this.y + this.vcd.getHeight()).translate(this.tr));
            this.addPoint(new Point(mx + 1, this.y + this.vcd.getHeight()).translate(this.tr));
            this.addPoint(new Point(mx + 1, this.y).translate(this.tr));
            this.addPoint(new Point(mx2, this.y).translate(this.tr));
            this.addPoint(new Point(mx2, this.y + this.vcd.getHeight()).translate(this.tr));
            this.addPoint(new Point(mx2 + 1, this.y + this.vcd.getHeight()).translate(this.tr));
        } else {
            this.addPoint(new Point(mx, this.y + this.vcd.getHeight()).translate(this.tr));
            this.addPoint(new Point(mx2, this.y + this.vcd.getHeight()).translate(this.tr));
        }
        if (this.futurLevel == ExtendFigure.Level.z) {
            this.addPoint(new Point(mx2, this.y + this.vcd.getHalfHeight()).translate(this.tr));
            this.addPoint(new Point(mx2, this.y + this.vcd.getHeight()).translate(this.tr));
        }
        this.setFill(true);
        if (this.ghostvisible) {
            if (this.polyline != null) {
                this.remove((IFigure)this.polyline);
            }
            this.polyline = new Polyline();
            this.polyline.setPoints(new PointList());
            this.polyline.setForegroundColor(this.vcd.getMca().colorClock());
            this.polyline.addPoint(new Point(mx, this.y + this.vcd.getHeight()).translate(this.tr));
            this.polyline.addPoint(new Point(mx2, this.y + this.vcd.getHeight()).translate(this.tr));
            this.polyline.setOpaque(false);
            this.add((IFigure)this.polyline);
        }
        return 0;
    }

    public void setGhostvisible(boolean ghostvisible) {
        this.ghostvisible = ghostvisible;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setoldValue(int n) {
        this.oldvalue = n;
    }

    @Override
    public void setTr(Point tr) {
        this.tr = tr;
    }

    @Override
    public ExtendFigure.Level getLevel() {
        return ExtendFigure.Level.x;
    }

    @Override
    public final ExtendFigure.Level getPrecedeLevel() {
        return this.precedeLevel;
    }

    @Override
    public final void setPrecedeLevel(ExtendFigure.Level precedeLevel) {
        this.precedeLevel = precedeLevel;
    }

    @Override
    public final ExtendFigure.Level getFuturLevel() {
        return this.futurLevel;
    }

    @Override
    public final void setFuturLevel(ExtendFigure.Level futurLevel) {
        this.futurLevel = futurLevel;
    }

    protected void finalize() throws Throwable {
        CountFigure.dec();
        super.finalize();
    }
}

