/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.xccsltolc;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.kairos.timesquare.ccsl.ISpecification;
import fr.kairos.timesquare.ccsl.safety.SafetyAnalyser;
import fr.kairos.timesquare.ccsl.simple.Specification;
import fr.kairos.timesquare.xccsltolc.AHandler;
import fr.kairos.timesquare.xccsltolc.XCCSLtoLC;
import java.util.Set;
import javax.swing.JOptionPane;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.console.ConsolePlugin;

public class CheckSafetyHandler
extends AHandler
implements IHandler {
    @Override
    protected void treatCCS(ClockConstraintSystem s) {
        Specification spec = new Specification(s.getName());
        XCCSLtoLC convert = new XCCSLtoLC((ISpecification)spec);
        convert.doSwitch((EObject)s);
        SafetyAnalyser analyzer = new SafetyAnalyser(spec);
        if (!analyzer.hasCounters()) {
            String message = "The specification has no counter => SAFE!";
            JOptionPane.showMessageDialog(null, "CCS " + s.getName(), message, -1);
            ConsolePlugin.getDefault().getLog().log((IStatus)new Status(0, "fr.aoste.timesquare.xccsltolc", message));
            return;
        }
        if (analyzer.checkSafety()) {
            String message = "The specification is SAFE!";
            JOptionPane.showMessageDialog(null, "CCS " + s.getName(), message, -1);
            ConsolePlugin.getDefault().getLog().log((IStatus)new Status(0, "fr.aoste.timesquare.xccsltolc", message));
        } else {
            Set unsafeCounters = analyzer.findUnsafeCounters();
            StringBuilder sb = new StringBuilder("List of unsafe counters:\n");
            for (String counter : unsafeCounters) {
                sb.append(counter).append('\n');
            }
            JOptionPane.showMessageDialog(null, "CCS " + s.getName(), sb.toString(), -1);
            ConsolePlugin.getDefault().getLog().log((IStatus)new Status(1, "fr.aoste.timesquare.xccsltolc", sb.toString()));
        }
    }
}

