/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.sat;

import fr.kairos.timesquare.ccsl.sat.ClockStatus;
import fr.kairos.timesquare.ccsl.sat.IStep;
import java.util.Iterator;

final class StepIterableFilter
implements Iterable<Integer> {
    private IStep step;
    private ClockStatus expected;

    StepIterableFilter(ClockStatus expected, IStep step) {
        this.expected = expected;
        this.step = step;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new MyIterator();
    }

    class MyIterator
    implements Iterator<Integer> {
        private int pos = -1;

        MyIterator() {
            this.findNext();
        }

        private void findNext() {
            do {
                ++this.pos;
            } while (this.pos < StepIterableFilter.this.step.size() && StepIterableFilter.this.step.status(this.pos) != StepIterableFilter.this.expected);
        }

        @Override
        public boolean hasNext() {
            return this.pos < StepIterableFilter.this.step.size();
        }

        @Override
        public Integer next() {
            int res = this.pos;
            this.findNext();
            return res;
        }
    }
}

