/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.formatter.linewrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.core.dom.Assignment;
import org.aspectj.org.eclipse.jdt.core.dom.Block;
import org.aspectj.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.ConditionalExpression;
import org.aspectj.org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.CreationReference;
import org.aspectj.org.eclipse.jdt.core.dom.DoStatement;
import org.aspectj.org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.aspectj.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.EnumDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ExportsDirective;
import org.aspectj.org.eclipse.jdt.core.dom.Expression;
import org.aspectj.org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.aspectj.org.eclipse.jdt.core.dom.FieldAccess;
import org.aspectj.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ForStatement;
import org.aspectj.org.eclipse.jdt.core.dom.IfStatement;
import org.aspectj.org.eclipse.jdt.core.dom.InfixExpression;
import org.aspectj.org.eclipse.jdt.core.dom.LambdaExpression;
import org.aspectj.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.MethodInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.OpensDirective;
import org.aspectj.org.eclipse.jdt.core.dom.ParameterizedType;
import org.aspectj.org.eclipse.jdt.core.dom.ProvidesDirective;
import org.aspectj.org.eclipse.jdt.core.dom.QualifiedName;
import org.aspectj.org.eclipse.jdt.core.dom.Statement;
import org.aspectj.org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.aspectj.org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.SuperMethodReference;
import org.aspectj.org.eclipse.jdt.core.dom.ThisExpression;
import org.aspectj.org.eclipse.jdt.core.dom.TryStatement;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.TypeMethodReference;
import org.aspectj.org.eclipse.jdt.core.dom.UnionType;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.aspectj.org.eclipse.jdt.core.dom.WhileStatement;
import org.aspectj.org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.aspectj.org.eclipse.jdt.internal.formatter.Token;
import org.aspectj.org.eclipse.jdt.internal.formatter.TokenManager;
import org.aspectj.org.eclipse.jdt.internal.formatter.TokenTraverser;
import org.aspectj.org.eclipse.jdt.internal.formatter.linewrap.Aligner;
import org.aspectj.org.eclipse.jdt.internal.formatter.linewrap.CommentWrapExecutor;
import org.aspectj.org.eclipse.jdt.internal.formatter.linewrap.WrapExecutor;
import org.eclipse.jface.text.IRegion;

public class WrapPreparator
extends ASTVisitor {
    private static final Map<InfixExpression.Operator, Integer> OPERATOR_PRECEDENCE;
    private static final float PREFERRED = 0.875f;
    final TokenManager tm;
    final DefaultCodeFormatterOptions options;
    final int kind;
    final Aligner aligner;
    int importsStart = -1;
    int importsEnd = -1;
    private List<Integer> wrapIndexes = new ArrayList<Integer>();
    private List<Integer> secondaryWrapIndexes = new ArrayList<Integer>();
    private List<Float> wrapPenalties = new ArrayList<Float>();
    private int wrapParentIndex = -1;
    private int wrapGroupEnd = -1;
    private int currentDepth = 0;

    static {
        HashMap<InfixExpression.Operator, Integer> precedence = new HashMap<InfixExpression.Operator, Integer>();
        precedence.put(InfixExpression.Operator.TIMES, 1);
        precedence.put(InfixExpression.Operator.DIVIDE, 1);
        precedence.put(InfixExpression.Operator.REMAINDER, 1);
        precedence.put(InfixExpression.Operator.PLUS, 2);
        precedence.put(InfixExpression.Operator.MINUS, 2);
        precedence.put(InfixExpression.Operator.AND, 6);
        precedence.put(InfixExpression.Operator.XOR, 7);
        precedence.put(InfixExpression.Operator.OR, 8);
        precedence.put(InfixExpression.Operator.CONDITIONAL_AND, 9);
        precedence.put(InfixExpression.Operator.CONDITIONAL_OR, 10);
        OPERATOR_PRECEDENCE = Collections.unmodifiableMap(precedence);
    }

    public WrapPreparator(TokenManager tokenManager, DefaultCodeFormatterOptions options, int kind) {
        this.tm = tokenManager;
        this.options = options;
        this.kind = kind;
        this.aligner = new Aligner(this.tm, this.options);
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        boolean isMalformed;
        ++this.currentDepth;
        assert (this.wrapIndexes.isEmpty() && this.secondaryWrapIndexes.isEmpty() && this.wrapPenalties.isEmpty());
        assert (this.wrapParentIndex == -1 && this.wrapGroupEnd == -1);
        boolean bl = isMalformed = (node.getFlags() & 1) != 0;
        if (isMalformed) {
            this.tm.addDisableFormatTokenPair(this.tm.firstTokenIn(node, -1), this.tm.lastTokenIn(node, -1));
        }
        return !isMalformed;
    }

    @Override
    public void postVisit(ASTNode node) {
        --this.currentDepth;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        List imports = node.imports();
        if (!imports.isEmpty()) {
            this.importsStart = this.tm.firstIndexIn((ASTNode)imports.get(0), -1);
            this.importsEnd = this.tm.lastIndexIn((ASTNode)imports.get(imports.size() - 1), -1);
        }
        return true;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.handleArguments(node.values(), this.options.alignment_for_arguments_in_annotation);
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        List superInterfaceTypes;
        Type superclassType = node.getSuperclassType();
        if (superclassType != null) {
            this.wrapParentIndex = this.tm.lastIndexIn(node.getName(), -1);
            this.wrapGroupEnd = this.tm.lastIndexIn(superclassType, -1);
            this.wrapIndexes.add(this.tm.firstIndexBefore(superclassType, 90));
            this.wrapIndexes.add(this.tm.firstIndexIn(superclassType, -1));
            this.handleWrap(this.options.alignment_for_superclass_in_type_declaration, 0.875f);
        }
        if (!(superInterfaceTypes = node.superInterfaceTypes()).isEmpty()) {
            int implementsToken = node.isInterface() ? 90 : 100;
            this.wrapParentIndex = this.tm.lastIndexIn(node.getName(), -1);
            this.wrapIndexes.add(this.tm.firstIndexBefore((ASTNode)superInterfaceTypes.get(0), implementsToken));
            this.prepareElementsList(superInterfaceTypes, 39, -1);
            this.handleWrap(this.options.alignment_for_superinterfaces_in_type_declaration, 0.875f);
        }
        this.prepareElementsList(node.typeParameters(), 39, 7);
        this.handleWrap(this.options.alignment_for_type_parameters);
        this.aligner.handleAlign(node.bodyDeclarations());
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        this.aligner.handleAlign(node.bodyDeclarations());
        return true;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        this.aligner.handleAlign(node.bodyDeclarations());
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        List exceptionTypes;
        List parameters = node.parameters();
        Type receiverType = node.getReceiverType();
        if (!parameters.isEmpty() || receiverType != null) {
            if (receiverType != null) {
                this.wrapIndexes.add(this.tm.firstIndexIn(receiverType, -1));
            }
            int wrappingOption = node.isConstructor() ? this.options.alignment_for_parameters_in_constructor_declaration : this.options.alignment_for_parameters_in_method_declaration;
            this.wrapGroupEnd = this.tm.lastIndexIn(parameters.isEmpty() ? receiverType : (ASTNode)parameters.get(parameters.size() - 1), -1);
            this.handleArguments(parameters, wrappingOption);
        }
        if (!(exceptionTypes = node.thrownExceptionTypes()).isEmpty()) {
            int wrappingOption;
            int n = wrappingOption = node.isConstructor() ? this.options.alignment_for_throws_clause_in_constructor_declaration : this.options.alignment_for_throws_clause_in_method_declaration;
            if ((wrappingOption & 2) == 0) {
                this.wrapParentIndex = this.tm.firstIndexAfter(node.getName(), 19);
            }
            this.prepareElementsList(exceptionTypes, 39, 25);
            this.wrapIndexes.set(0, this.tm.firstIndexBefore((ASTNode)exceptionTypes.get(0), 98));
            this.handleWrap(wrappingOption, 0.5f);
        }
        if (!node.isConstructor()) {
            int returTypeIndex;
            this.wrapParentIndex = this.tm.findFirstTokenInLine(this.tm.firstIndexIn(node.getName(), -1));
            while (this.tm.get(this.wrapParentIndex).isComment()) {
                ++this.wrapParentIndex;
            }
            List typeParameters = node.typeParameters();
            if (!typeParameters.isEmpty()) {
                this.wrapIndexes.add(this.tm.firstIndexIn((ASTNode)typeParameters.get(0), -1));
            }
            if (node.getReturnType2() != null && (returTypeIndex = this.tm.firstIndexIn(node.getReturnType2(), -1)) != this.wrapParentIndex) {
                this.wrapIndexes.add(returTypeIndex);
            }
            this.wrapIndexes.add(this.tm.firstIndexIn(node.getName(), -1));
            this.wrapGroupEnd = this.tm.lastIndexIn(node.getName(), -1);
            this.handleWrap(this.options.alignment_for_method_declaration);
        }
        this.prepareElementsList(node.typeParameters(), 39, 7);
        this.handleWrap(this.options.alignment_for_type_parameters);
        return true;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        List superInterfaceTypes;
        List enumConstants = node.enumConstants();
        int constantsEnd = -1;
        if (!enumConstants.isEmpty()) {
            for (EnumConstantDeclaration constant : enumConstants) {
                this.wrapIndexes.add(this.tm.firstIndexIn(constant, -1));
            }
            this.wrapParentIndex = (this.options.alignment_for_enum_constants & 2) > 0 ? this.tm.firstIndexBefore((ASTNode)enumConstants.get(0), 65) : this.tm.firstIndexIn(node, 82);
            this.wrapGroupEnd = constantsEnd = this.tm.lastIndexIn((ASTNode)enumConstants.get(enumConstants.size() - 1), -1);
            this.handleWrap(this.options.alignment_for_enum_constants, node);
        }
        if (!this.options.join_wrapped_lines) {
            int commaIndex = -1;
            int i = constantsEnd > 0 ? constantsEnd : this.tm.firstIndexAfter(node.getName(), 65);
            while (++i < this.tm.size()) {
                Token t = this.tm.get(i);
                if (t.isComment()) continue;
                if (t.tokenType == 39) {
                    commaIndex = i;
                    continue;
                }
                if (t.tokenType != 26 || commaIndex < 0 || this.tm.countLineBreaksBetween(this.tm.get(commaIndex), t) != 1) break;
                t.setWrapPolicy(new Token.WrapPolicy(Token.WrapMode.WHERE_NECESSARY, commaIndex, 0));
                break;
            }
        }
        if (!(superInterfaceTypes = node.superInterfaceTypes()).isEmpty()) {
            this.wrapParentIndex = this.tm.lastIndexIn(node.getName(), -1);
            this.wrapIndexes.add(this.tm.firstIndexBefore((ASTNode)superInterfaceTypes.get(0), 100));
            this.prepareElementsList(superInterfaceTypes, 39, -1);
            this.handleWrap(this.options.alignment_for_superinterfaces_in_enum_declaration, 0.875f);
        }
        this.aligner.handleAlign(node.bodyDeclarations());
        return true;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_enum_constant);
        AnonymousClassDeclaration anonymousClass = node.getAnonymousClassDeclaration();
        if (anonymousClass != null) {
            this.forceContinuousWrapping(anonymousClass, this.tm.firstIndexIn(node.getName(), -1));
        }
        return true;
    }

    @Override
    public boolean visit(Block node) {
        this.aligner.handleAlign(node);
        return true;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        boolean isInvocationChainRoot;
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_method_invocation);
        this.handleTypeArguments(node.typeArguments());
        boolean bl = isInvocationChainRoot = !(node.getParent() instanceof MethodInvocation) || node.getLocationInParent() != MethodInvocation.EXPRESSION_PROPERTY;
        if (isInvocationChainRoot) {
            Expression expression = node;
            MethodInvocation invocation = node;
            while (expression instanceof MethodInvocation) {
                invocation = expression;
                if ((expression = invocation.getExpression()) == null) continue;
                this.wrapIndexes.add(this.tm.firstIndexBefore(invocation.getName(), 1));
                this.secondaryWrapIndexes.add(this.tm.firstIndexIn(invocation.getName(), 15));
            }
            Collections.reverse(this.wrapIndexes);
            this.wrapParentIndex = expression != null ? this.tm.lastIndexIn(expression, -1) : this.tm.lastIndexIn(invocation, -1);
            this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
            this.handleWrap(this.options.alignment_for_selector_in_method_invocation);
        }
        return true;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_method_invocation);
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        AnonymousClassDeclaration anonymousClass = node.getAnonymousClassDeclaration();
        if (anonymousClass != null) {
            this.forceContinuousWrapping(anonymousClass, this.tm.firstIndexIn(node, 42));
        }
        int wrappingOption = node.getExpression() != null ? this.options.alignment_for_arguments_in_qualified_allocation_expression : this.options.alignment_for_arguments_in_allocation_expression;
        this.handleArguments(node.arguments(), wrappingOption);
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_explicit_constructor_call);
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_explicit_constructor_call);
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(FieldAccess node) {
        this.handleFieldAccess(node);
        return true;
    }

    @Override
    public boolean visit(QualifiedName node) {
        this.handleFieldAccess(node);
        return true;
    }

    @Override
    public boolean visit(ThisExpression node) {
        this.handleFieldAccess(node);
        return true;
    }

    @Override
    public boolean visit(SuperFieldAccess node) {
        this.handleFieldAccess(node);
        return true;
    }

    private void handleFieldAccess(Expression node) {
        boolean isAccessChainRoot;
        boolean bl = isAccessChainRoot = !FieldAccessAdapter.isFieldAccess(node.getParent());
        if (!isAccessChainRoot) {
            return;
        }
        Expression expression = node;
        FieldAccessAdapter access = null;
        while (FieldAccessAdapter.isFieldAccess(expression)) {
            access = new FieldAccessAdapter(expression);
            int nameIndex = access.getIdentifierIndex(this.tm);
            int i = nameIndex - 1;
            while (i > this.tm.firstIndexIn(node, -1)) {
                Token t = this.tm.get(i);
                if (t.tokenType == 1) {
                    this.wrapIndexes.add(i);
                    this.secondaryWrapIndexes.add(nameIndex);
                }
                if (!t.isComment() && t.tokenType != 43) break;
                --i;
            }
            expression = access.getExpression();
        }
        Collections.reverse(this.wrapIndexes);
        this.wrapParentIndex = this.tm.lastIndexIn(expression != null ? expression : access.accessExpression, -1);
        boolean isFollowedByInvocation = node.getParent() instanceof MethodInvocation && node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY;
        this.wrapGroupEnd = isFollowedByInvocation ? this.tm.lastIndexIn(node.getParent(), -1) : new FieldAccessAdapter(node).getIdentifierIndex(this.tm);
        this.handleWrap(0);
    }

    @Override
    public boolean visit(InfixExpression node) {
        Integer operatorPrecedence = OPERATOR_PRECEDENCE.get(node.getOperator());
        if (operatorPrecedence == null) {
            return true;
        }
        ASTNode parent = node.getParent();
        if (parent instanceof InfixExpression && this.samePrecedence(node, (InfixExpression)parent)) {
            return true;
        }
        this.findTokensToWrap(node, 0);
        this.wrapParentIndex = this.wrapIndexes.remove(0);
        this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
        if ((this.options.alignment_for_binary_expression & 2) != 0 && this.wrapParentIndex > 0) {
            --this.wrapParentIndex;
        }
        int i = this.wrapParentIndex;
        while (i >= 0) {
            if (!this.tm.get(i).isComment()) {
                this.wrapParentIndex = i;
                break;
            }
            --i;
        }
        this.handleWrap(this.options.alignment_for_binary_expression, node);
        return true;
    }

    private void findTokensToWrap(InfixExpression node, int depth) {
        Expression left = node.getLeftOperand();
        if (left instanceof InfixExpression && this.samePrecedence(node, (InfixExpression)left)) {
            this.findTokensToWrap((InfixExpression)left, depth + 1);
        } else if (this.wrapIndexes.isEmpty() || !this.options.wrap_before_binary_operator) {
            this.wrapIndexes.add(this.tm.firstIndexIn(left, -1));
        }
        Expression right = node.getRightOperand();
        List extended = node.extendedOperands();
        int i = -1;
        while (i < extended.size()) {
            Expression operand;
            Expression expression = operand = i == -1 ? right : (Expression)extended.get(i);
            if (operand instanceof InfixExpression && this.samePrecedence(node, (InfixExpression)operand)) {
                this.findTokensToWrap((InfixExpression)operand, depth + 1);
            }
            int indexBefore = this.tm.firstIndexBefore(operand, -1);
            while (this.tm.get(indexBefore).isComment()) {
                --indexBefore;
            }
            assert (node.getOperator().toString().equals(this.tm.toString(indexBefore)));
            int indexAfter = this.tm.firstIndexIn(operand, -1);
            this.wrapIndexes.add(this.options.wrap_before_binary_operator ? indexBefore : indexAfter);
            this.secondaryWrapIndexes.add(this.options.wrap_before_binary_operator ? indexAfter : indexBefore);
            if (!this.options.join_wrapped_lines) {
                if (this.options.wrap_before_binary_operator) {
                    if (this.tm.countLineBreaksBetween(this.tm.get(indexAfter - 1), this.tm.get(indexAfter)) > 0) {
                        this.wrapIndexes.add(indexAfter);
                    }
                } else if (this.tm.countLineBreaksBetween(this.tm.get(indexBefore), this.tm.get(indexBefore - 1)) > 0) {
                    this.wrapIndexes.add(indexBefore);
                }
            }
            ++i;
        }
    }

    private boolean samePrecedence(InfixExpression expression1, InfixExpression expression2) {
        Integer precedence1 = OPERATOR_PRECEDENCE.get(expression1.getOperator());
        Integer precedence2 = OPERATOR_PRECEDENCE.get(expression2.getOperator());
        if (precedence1 == null || precedence2 == null) {
            return false;
        }
        return precedence1.equals(precedence2);
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        boolean wrapBefore = this.options.wrap_before_conditional_operator;
        List<Integer> before = wrapBefore ? this.wrapIndexes : this.secondaryWrapIndexes;
        List<Integer> after = wrapBefore ? this.secondaryWrapIndexes : this.wrapIndexes;
        before.add(this.tm.firstIndexAfter(node.getExpression(), 35));
        before.add(this.tm.firstIndexAfter(node.getThenExpression(), 66));
        after.add(this.tm.firstIndexIn(node.getThenExpression(), -1));
        after.add(this.tm.firstIndexIn(node.getElseExpression(), -1));
        this.wrapParentIndex = this.tm.lastIndexIn(node.getExpression(), -1);
        this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
        this.handleWrap(this.options.alignment_for_conditional_expression);
        return true;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        int openingBraceIndex;
        Token openingBrace;
        List expressions = node.expressions();
        if (!expressions.isEmpty()) {
            this.prepareElementsList(expressions, 39, 65);
            this.handleWrap(this.options.alignment_for_expressions_in_array_initializer, node);
        }
        if ((openingBrace = this.tm.get(openingBraceIndex = this.tm.firstIndexIn(node, 65))).isNextLineOnWrap() && openingBrace.getWrapPolicy() == null && openingBraceIndex > 0) {
            openingBrace.setWrapPolicy(new Token.WrapPolicy(Token.WrapMode.DISABLED, openingBraceIndex - 1, 0));
        }
        if (!this.options.join_wrapped_lines && !this.options.insert_new_line_before_closing_brace_in_array_initializer) {
            int closingBraceIndex = this.tm.lastIndexIn(node, 40);
            Token closingBrace = this.tm.get(closingBraceIndex);
            if (this.tm.countLineBreaksBetween(this.tm.get(closingBraceIndex - 1), closingBrace) == 1) {
                closingBrace.setWrapPolicy(new Token.WrapPolicy(Token.WrapMode.WHERE_NECESSARY, openingBraceIndex, closingBraceIndex, 0, this.currentDepth, 1.0f, true, false));
            }
        }
        return true;
    }

    @Override
    public boolean visit(Assignment node) {
        int rightSideIndex = this.tm.firstIndexIn(node.getRightHandSide(), -1);
        if (this.tm.get(rightSideIndex).getLineBreaksBefore() > 0) {
            return true;
        }
        int operatorIndex = this.tm.firstIndexBefore(node.getRightHandSide(), -1);
        while (this.tm.get(operatorIndex).isComment()) {
            --operatorIndex;
        }
        assert (node.getOperator().toString().equals(this.tm.toString(operatorIndex)));
        this.wrapIndexes.add(this.options.wrap_before_assignment_operator ? operatorIndex : rightSideIndex);
        this.secondaryWrapIndexes.add(this.options.wrap_before_assignment_operator ? rightSideIndex : operatorIndex);
        this.wrapParentIndex = operatorIndex - 1;
        this.wrapGroupEnd = this.tm.lastIndexIn(node.getRightHandSide(), -1);
        this.handleWrap(this.options.alignment_for_assignment);
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        if (node.getInitializer() == null) {
            return true;
        }
        int rightSideIndex = this.tm.firstIndexIn(node.getInitializer(), -1);
        if (this.tm.get(rightSideIndex).getLineBreaksBefore() > 0) {
            return true;
        }
        int equalIndex = this.tm.firstIndexBefore(node.getInitializer(), 74);
        this.wrapIndexes.add(this.options.wrap_before_assignment_operator ? equalIndex : rightSideIndex);
        this.secondaryWrapIndexes.add(this.options.wrap_before_assignment_operator ? rightSideIndex : equalIndex);
        this.wrapParentIndex = equalIndex - 1;
        this.wrapGroupEnd = this.tm.lastIndexIn(node.getInitializer(), -1);
        this.handleWrap(this.options.alignment_for_assignment);
        return true;
    }

    @Override
    public boolean visit(IfStatement node) {
        boolean keepThenOnSameLine;
        boolean bl = keepThenOnSameLine = this.options.keep_then_statement_on_same_line || this.options.keep_simple_if_on_one_line && node.getElseStatement() == null;
        if (keepThenOnSameLine) {
            this.handleSimpleLoop(node.getThenStatement(), this.options.alignment_for_compact_if);
        }
        return true;
    }

    @Override
    public boolean visit(ForStatement node) {
        List updaters;
        List initializers = node.initializers();
        if (!initializers.isEmpty()) {
            this.wrapIndexes.add(this.tm.firstIndexIn((ASTNode)initializers.get(0), -1));
        }
        if (node.getExpression() != null) {
            this.wrapIndexes.add(this.tm.firstIndexIn(node.getExpression(), -1));
        }
        if (!(updaters = node.updaters()).isEmpty()) {
            this.wrapIndexes.add(this.tm.firstIndexIn((ASTNode)updaters.get(0), -1));
        }
        if (!this.wrapIndexes.isEmpty()) {
            this.wrapParentIndex = this.tm.firstIndexIn(node, 19);
            this.wrapGroupEnd = this.tm.firstIndexBefore(node.getBody(), 25);
            this.handleWrap(this.options.alignment_for_expressions_in_for_loop_header);
        }
        if (this.options.keep_simple_for_body_on_same_line) {
            this.handleSimpleLoop(node.getBody(), this.options.alignment_for_compact_loop);
        }
        return true;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        if (this.options.keep_simple_for_body_on_same_line) {
            this.handleSimpleLoop(node.getBody(), this.options.alignment_for_compact_loop);
        }
        return true;
    }

    @Override
    public boolean visit(WhileStatement node) {
        if (this.options.keep_simple_while_body_on_same_line) {
            this.handleSimpleLoop(node.getBody(), this.options.alignment_for_compact_loop);
        }
        return true;
    }

    private void handleSimpleLoop(Statement body, int wrappingOption) {
        if (!(body instanceof Block)) {
            this.wrapIndexes.add(this.tm.firstIndexIn(body, -1));
            this.wrapParentIndex = this.tm.firstIndexBefore(body, 25);
            this.wrapGroupEnd = this.tm.lastIndexIn(body, -1);
            this.handleWrap(wrappingOption, body.getParent());
            body.accept(new ASTVisitor(){

                @Override
                public boolean visit(Block node) {
                    WrapPreparator.this.forceContinuousWrapping(node, WrapPreparator.this.tm.firstIndexIn(node, -1));
                    return false;
                }
            });
        }
    }

    @Override
    public void endVisit(DoStatement node) {
        if (this.options.keep_simple_do_while_body_on_same_line && !(node.getBody() instanceof Block)) {
            int whileIndex = this.tm.firstIndexAfter(node.getBody(), 77);
            this.wrapIndexes.add(whileIndex);
            this.wrapParentIndex = this.tm.lastIndexIn(node.getBody(), -1);
            this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
            int alignment = this.options.alignment_for_compact_loop;
            int i = this.tm.firstIndexIn(node, -1) + 1;
            while (i < whileIndex) {
                Token token = this.tm.get(i);
                if (token.getLineBreaksBefore() > 0 || token.getLineBreaksAfter() > 0) {
                    alignment |= 1;
                }
                ++i;
            }
            this.handleWrap(alignment, node);
        }
    }

    @Override
    public boolean visit(TryStatement node) {
        this.prepareElementsList(node.resources(), 26, 19);
        this.handleWrap(this.options.alignment_for_resources_in_try);
        return true;
    }

    @Override
    public boolean visit(UnionType node) {
        List types = node.types();
        if (types.isEmpty()) {
            return true;
        }
        if (this.options.wrap_before_or_operator_multicatch) {
            for (Type type : types) {
                if (this.wrapIndexes.isEmpty()) {
                    this.wrapIndexes.add(this.tm.firstIndexIn(type, -1));
                    continue;
                }
                this.wrapIndexes.add(this.tm.firstIndexBefore(type, 36));
                this.secondaryWrapIndexes.add(this.tm.firstIndexIn(type, -1));
            }
            this.wrapParentIndex = this.tm.firstIndexBefore(node, -1);
            while (this.tm.get(this.wrapParentIndex).isComment()) {
                --this.wrapParentIndex;
            }
            this.wrapGroupEnd = this.tm.lastIndexIn((ASTNode)types.get(types.size() - 1), -1);
            this.handleWrap(this.options.alignment_for_union_type_in_multicatch);
        } else {
            this.prepareElementsList(types, 36, 19);
            this.handleWrap(this.options.alignment_for_union_type_in_multicatch);
        }
        return true;
    }

    @Override
    public boolean visit(LambdaExpression node) {
        if (node.getBody() instanceof Block) {
            this.forceContinuousWrapping(node.getBody(), this.tm.firstIndexIn(node, -1));
        }
        if (node.hasParentheses()) {
            List parameters = node.parameters();
            ++this.currentDepth;
            this.handleArguments(parameters, this.options.alignment_for_parameters_in_method_declaration);
            --this.currentDepth;
        }
        return true;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        this.handleVariableDeclarations(node.fragments());
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.handleVariableDeclarations(node.fragments());
        return true;
    }

    @Override
    public boolean visit(ParameterizedType node) {
        this.prepareElementsList(node.typeArguments(), 39, 7);
        this.handleWrap(this.options.alignment_for_parameterized_type_references);
        return true;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    @Override
    public boolean visit(CreationReference node) {
        this.handleTypeArguments(node.typeArguments());
        return true;
    }

    private void handleTypeArguments(List<Type> typeArguments) {
        if (typeArguments.isEmpty()) {
            return;
        }
        this.prepareElementsList(typeArguments, 39, 7);
        this.handleWrap(this.options.alignment_for_type_arguments);
    }

    @Override
    public boolean visit(ExportsDirective node) {
        this.handleModuleStatement(node.modules(), 130);
        return true;
    }

    @Override
    public boolean visit(OpensDirective node) {
        this.handleModuleStatement(node.modules(), 130);
        return true;
    }

    @Override
    public boolean visit(ProvidesDirective node) {
        this.handleModuleStatement(node.implementations(), 131);
        return true;
    }

    private void handleModuleStatement(List<Name> names, int joiningTokenType) {
        if (names.isEmpty()) {
            return;
        }
        int joiningTokenIndex = this.tm.firstIndexBefore(names.get(0), joiningTokenType);
        this.wrapParentIndex = this.tm.firstIndexBefore(names.get(0), 15);
        this.wrapIndexes.add(joiningTokenIndex);
        this.prepareElementsList(names, 39, -1);
        this.handleWrap(this.options.alignment_for_module_statements, 0.875f);
    }

    void forceContinuousWrapping(ASTNode node, int parentIndex) {
        int parentIndent = this.tm.get(parentIndex).getIndent();
        int indentChange = -parentIndent;
        int lineStart = this.tm.findFirstTokenInLine(parentIndex);
        int i = parentIndex;
        while (i >= lineStart) {
            int align = this.tm.get(i).getAlign();
            if (align > 0) {
                indentChange = -2 * parentIndent + align;
                break;
            }
            --i;
        }
        Token previous = null;
        int from = this.tm.firstIndexIn(node, -1);
        int to = this.tm.lastIndexIn(node, -1);
        int i2 = from;
        while (i2 <= to) {
            Token token = this.tm.get(i2);
            if ((token.getLineBreaksBefore() > 0 || previous != null && previous.getLineBreaksAfter() > 0) && (token.getWrapPolicy() == null || token.getWrapPolicy().wrapMode == Token.WrapMode.BLOCK_INDENT)) {
                int extraIndent = token.getIndent() + indentChange;
                token.setWrapPolicy(new Token.WrapPolicy(Token.WrapMode.BLOCK_INDENT, parentIndex, extraIndent));
                token.setIndent(parentIndent + extraIndent);
            }
            previous = token;
            ++i2;
        }
    }

    private void handleVariableDeclarations(List<VariableDeclarationFragment> fragments) {
        if (fragments.size() > 1) {
            this.wrapParentIndex = this.tm.firstIndexIn(fragments.get(0), -1);
            this.prepareElementsList(fragments, 39, -1);
            this.wrapIndexes.remove(0);
            this.handleWrap(this.options.alignment_for_multiple_fields);
        }
    }

    private void handleArguments(List<? extends ASTNode> arguments, int wrappingOption) {
        this.wrapPenalties.add(Float.valueOf(1.1428572f));
        this.prepareElementsList(arguments, 39, 19);
        this.handleWrap(wrappingOption);
    }

    private void prepareElementsList(List<? extends ASTNode> elements, int separatorType, int wrapParentType) {
        int i = 0;
        while (i < elements.size()) {
            ASTNode element = elements.get(i);
            this.wrapIndexes.add(this.tm.firstIndexIn(element, -1));
            if (i > 0) {
                this.secondaryWrapIndexes.add(this.tm.firstIndexBefore(element, separatorType));
            }
            ++i;
        }
        if (!this.wrapIndexes.isEmpty()) {
            Token firstToken = this.tm.get(this.wrapIndexes.get(0));
            if (this.wrapParentIndex < 0) {
                this.wrapParentIndex = this.tm.findIndex(firstToken.originalStart - 1, wrapParentType, false);
            }
            if (!elements.isEmpty() && this.wrapGroupEnd < 0) {
                this.wrapGroupEnd = this.tm.lastIndexIn(elements.get(elements.size() - 1), -1);
            }
        }
    }

    private void handleWrap(int wrappingOption) {
        this.handleWrap(wrappingOption, null);
    }

    private void handleWrap(int wrappingOption, float firstPenaltyMultiplier) {
        this.wrapPenalties.add(Float.valueOf(firstPenaltyMultiplier));
        this.handleWrap(wrappingOption, null);
    }

    private void handleWrap(int wrappingOption, ASTNode parentNode) {
        this.doHandleWrap(wrappingOption, parentNode);
        this.wrapIndexes.clear();
        this.secondaryWrapIndexes.clear();
        this.wrapPenalties.clear();
        this.wrapGroupEnd = -1;
        this.wrapParentIndex = -1;
    }

    /*
     * Unable to fully structure code
     */
    private void doHandleWrap(int wrappingOption, ASTNode parentNode) {
        if (this.wrapIndexes.isEmpty()) {
            return;
        }
        if (!(WrapPreparator.$assertionsDisabled || this.wrapParentIndex >= 0 && this.wrapParentIndex < this.wrapIndexes.get(0))) {
            throw new AssertionError();
        }
        if (WrapPreparator.$assertionsDisabled || this.wrapGroupEnd >= this.wrapIndexes.get(this.wrapIndexes.size() - 1)) ** GOTO lbl8
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            --this.wrapParentIndex;
lbl8:
            // 2 sources

            ** while (this.tm.get((int)this.wrapParentIndex).isComment() && this.wrapParentIndex > 0)
        }
lbl9:
        // 1 sources

        penalty = this.wrapPenalties.isEmpty() != false ? 1.0f : this.wrapPenalties.get(0).floatValue();
        policy = this.getWrapPolicy(wrappingOption, penalty, true, parentNode);
        existing = this.tm.get(this.wrapIndexes.get(0)).getWrapPolicy();
        if (existing != null && existing.wrapMode == Token.WrapMode.TOP_PRIORITY) {
            if (!WrapPreparator.$assertionsDisabled && existing.wrapParentIndex != this.wrapParentIndex) {
                throw new AssertionError();
            }
            this.wrapGroupEnd = existing.groupEndIndex;
            policy = new Token.WrapPolicy(Token.WrapMode.TOP_PRIORITY, policy.wrapParentIndex, this.wrapGroupEnd, policy.extraIndent, policy.structureDepth, policy.penaltyMultiplier, true, policy.indentOnColumn);
        }
        this.setTokenWrapPolicy(0, policy, true);
        wrapPreceedingComments = parentNode instanceof InfixExpression == false || this.options.wrap_before_binary_operator == false;
        i = 1;
        while (i < this.wrapIndexes.size()) {
            v0 = penalty = this.wrapPenalties.size() > i ? this.wrapPenalties.get(i).floatValue() : 1.0f;
            if (penalty != policy.penaltyMultiplier || i == 1) {
                policy = this.getWrapPolicy(wrappingOption, penalty, false, parentNode);
            }
            this.setTokenWrapPolicy(i, policy, wrapPreceedingComments);
            ++i;
        }
        if (!this.secondaryWrapIndexes.isEmpty()) {
            optionNoAlignment = wrappingOption & -113;
            policy = this.getWrapPolicy(optionNoAlignment, 1.0f, false, parentNode);
            for (int index : this.secondaryWrapIndexes) {
                token = this.tm.get(index);
                if (token.getWrapPolicy() != null) continue;
                token.setWrapPolicy(policy);
            }
        }
    }

    private void setTokenWrapPolicy(int wrapIndexesIndex, Token.WrapPolicy policy, boolean wrapPreceedingComments) {
        Token token;
        int index = this.wrapIndexes.get(wrapIndexesIndex);
        if (wrapPreceedingComments) {
            int i = index - 1;
            while (i >= 0) {
                Token previous = this.tm.get(i);
                if (!previous.isComment() || previous.getWrapPolicy() == Token.WrapPolicy.FORCE_FIRST_COLUMN) break;
                if (previous.getLineBreaksAfter() == 0 && i == index - 1) {
                    index = i;
                }
                if (previous.getLineBreaksBefore() > 0) {
                    previous.setWrapPolicy(policy);
                }
                --i;
            }
            this.wrapIndexes.set(wrapIndexesIndex, index);
        }
        if ((token = this.tm.get(index)).getWrapPolicy() == Token.WrapPolicy.DISABLE_WRAP) {
            return;
        }
        token.setWrapPolicy(policy);
        if (policy.wrapMode == Token.WrapMode.FORCE) {
            token.breakBefore();
        } else if (this.options.join_wrapped_lines && token.tokenType == 1002) {
            token.clearLineBreaksBefore();
        }
    }

    private Token.WrapPolicy getWrapPolicy(int wrappingOption, float penaltyMultiplier, boolean isFirst, ASTNode parentNode) {
        assert (this.wrapParentIndex >= 0 && this.wrapGroupEnd >= 0);
        int extraIndent = this.options.continuation_indentation;
        boolean indentOnColumn = (wrappingOption & 2) != 0;
        boolean isForceWrap = (wrappingOption & 1) != 0;
        boolean isAlreadyWrapped = false;
        if (indentOnColumn) {
            extraIndent = 0;
        } else if (parentNode instanceof EnumDeclaration) {
            int n = extraIndent = (wrappingOption & 4) != 0 ? 2 : 1;
            if (!this.options.indent_body_declarations_compare_to_enum_declaration_header) {
                --extraIndent;
            }
            isAlreadyWrapped = isFirst;
        } else if (parentNode instanceof IfStatement || parentNode instanceof ForStatement || parentNode instanceof EnhancedForStatement || parentNode instanceof WhileStatement) {
            extraIndent = 1;
            this.wrapParentIndex = this.tm.firstIndexIn(parentNode, -1);
        } else if (parentNode instanceof DoStatement) {
            extraIndent = 0;
            this.wrapParentIndex = this.tm.firstIndexIn(parentNode, -1);
        } else if ((wrappingOption & 4) != 0) {
            extraIndent = 1;
        } else if (parentNode instanceof ArrayInitializer) {
            extraIndent = this.options.continuation_indentation_for_array_initializer;
            isAlreadyWrapped = isFirst && this.options.insert_new_line_after_opening_brace_in_array_initializer;
        }
        Token.WrapMode wrapMode = Token.WrapMode.WHERE_NECESSARY;
        boolean isTopPriority = false;
        switch (wrappingOption & 0x70) {
            case 0: {
                wrapMode = Token.WrapMode.DISABLED;
                isForceWrap = false;
                break;
            }
            case 32: {
                isTopPriority = isFirst;
                isForceWrap &= isFirst;
                break;
            }
            case 48: {
                isTopPriority = true;
                break;
            }
            case 64: {
                isTopPriority = true;
                if (isFirst) break;
                ++extraIndent;
                break;
            }
            case 80: {
                isTopPriority = !isFirst;
                isForceWrap &= !isFirst;
            }
        }
        if (isForceWrap) {
            wrapMode = Token.WrapMode.FORCE;
        } else if (isAlreadyWrapped) {
            wrapMode = Token.WrapMode.DISABLED;
        } else if (isTopPriority) {
            wrapMode = Token.WrapMode.TOP_PRIORITY;
        }
        return new Token.WrapPolicy(wrapMode, this.wrapParentIndex, this.wrapGroupEnd, extraIndent *= this.options.indentation_size, this.currentDepth, penaltyMultiplier, isFirst, indentOnColumn);
    }

    public void finishUp(ASTNode astRoot, List<IRegion> regions) {
        this.preserveExistingLineBreaks();
        this.applyBreaksOutsideRegions(regions);
        new WrapExecutor(this.tm, this.options).executeWraps();
        this.aligner.alignComments();
        this.wrapComments();
        this.fixEnumConstantIndents(astRoot);
    }

    private void preserveExistingLineBreaks() {
        Token first = this.tm.get(0);
        int startingBreaks = first.getLineBreaksBefore();
        first.clearLineBreaksBefore();
        first.putLineBreaksBefore(startingBreaks - 1);
        this.tm.traverse(0, new TokenTraverser(){
            boolean join_wrapped_lines;
            {
                this.join_wrapped_lines = WrapPreparator.this.options.join_wrapped_lines;
            }

            @Override
            protected boolean token(Token token, int index) {
                boolean isBetweenImports = index > WrapPreparator.this.importsStart && index < WrapPreparator.this.importsEnd;
                int lineBreaks = WrapPreparator.this.getLineBreaksToPreserve(this.getPrevious(), token, isBetweenImports);
                if (lineBreaks > 1 || !this.join_wrapped_lines && token.isWrappable() || index == 0) {
                    token.putLineBreaksBefore(lineBreaks);
                }
                return true;
            }
        });
        Token last = this.tm.get(this.tm.size() - 1);
        last.clearLineBreaksAfter();
        int endingBreaks = this.getLineBreaksToPreserve(last, null, false);
        if (endingBreaks > 0) {
            last.putLineBreaksAfter(endingBreaks);
        } else if ((this.kind & 0x88) != 0 && this.options.insert_new_line_at_end_of_file_if_missing) {
            last.breakAfter();
        }
    }

    int getLineBreaksToPreserve(Token token1, Token token2, boolean isBetweenImports) {
        List<Token> structure;
        if (token1 != null && (structure = token1.getInternalStructure()) != null && !structure.isEmpty()) {
            token1 = structure.get(structure.size() - 1);
        }
        if (token2 != null && (structure = token2.getInternalStructure()) != null && !structure.isEmpty()) {
            token2 = structure.get(0);
        }
        int lineBreaks = this.tm.countLineBreaksBetween(token1, token2);
        if (isBetweenImports) {
            return lineBreaks > 1 ? this.options.blank_lines_between_import_groups + 1 : 0;
        }
        int toPreserve = this.options.number_of_empty_lines_to_preserve;
        if (token1 != null && token2 != null) {
            ++toPreserve;
        }
        return Math.min(lineBreaks, toPreserve);
    }

    private void applyBreaksOutsideRegions(List<IRegion> regions) {
        String source = this.tm.getSource();
        int previousRegionEnd = 0;
        for (IRegion region : regions) {
            int index = this.tm.findIndex(previousRegionEnd, -1, true);
            Token token = this.tm.get(index);
            if (this.tm.countLineBreaksBetween(source, previousRegionEnd, Math.min(token.originalStart, region.getOffset())) > 0) {
                token.breakBefore();
            }
            ++index;
            while (index < this.tm.size()) {
                Token next = this.tm.get(index);
                if (next.originalStart > region.getOffset()) {
                    if (this.tm.countLineBreaksBetween(source, token.originalEnd, region.getOffset()) <= 0) break;
                    next.breakBefore();
                    break;
                }
                if (this.tm.countLineBreaksBetween(token, next) > 0) {
                    next.breakBefore();
                }
                token = next;
                ++index;
            }
            previousRegionEnd = region.getOffset() + region.getLength() - 1;
        }
    }

    private void wrapComments() {
        CommentWrapExecutor commentWrapper = new CommentWrapExecutor(this.tm, this.options);
        boolean isNLSTagInLine = false;
        int i = 0;
        while (i < this.tm.size()) {
            List<Token> structure;
            Token token = this.tm.get(i);
            if (token.getLineBreaksBefore() > 0 || token.getLineBreaksAfter() > 0) {
                isNLSTagInLine = false;
            }
            if (token.hasNLSTag()) {
                assert (token.tokenType == 64);
                isNLSTagInLine = true;
            }
            if ((structure = token.getInternalStructure()) != null && !structure.isEmpty() && !isNLSTagInLine) {
                int startPosition = this.tm.getPositionInLine(i);
                if (token.tokenType == 1001) {
                    commentWrapper.wrapLineComment(token, startPosition);
                } else {
                    assert (token.tokenType == 1002 || token.tokenType == 1003);
                    commentWrapper.wrapMultiLineComment(token, startPosition, false, false);
                }
            }
            ++i;
        }
    }

    private void fixEnumConstantIndents(ASTNode astRoot) {
        if (this.options.use_tabs_only_for_leading_indentations) {
            astRoot.accept(new ASTVisitor(){

                @Override
                public boolean visit(EnumConstantDeclaration node) {
                    WrapPreparator.this.tm.firstTokenIn(node, -1).setWrapPolicy(null);
                    return true;
                }
            });
        }
    }

    private static class FieldAccessAdapter {
        final Expression accessExpression;

        public FieldAccessAdapter(Expression expression) {
            this.accessExpression = expression;
        }

        public static boolean isFieldAccess(ASTNode expr) {
            return expr instanceof FieldAccess || expr instanceof QualifiedName || expr instanceof ThisExpression || expr instanceof SuperFieldAccess;
        }

        public Expression getExpression() {
            if (this.accessExpression instanceof FieldAccess) {
                return ((FieldAccess)this.accessExpression).getExpression();
            }
            if (this.accessExpression instanceof QualifiedName) {
                return ((QualifiedName)this.accessExpression).getQualifier();
            }
            if (this.accessExpression instanceof ThisExpression) {
                return ((ThisExpression)this.accessExpression).getQualifier();
            }
            if (this.accessExpression instanceof SuperFieldAccess) {
                return ((SuperFieldAccess)this.accessExpression).getQualifier();
            }
            throw new AssertionError();
        }

        public int getIdentifierIndex(TokenManager tm) {
            if (this.accessExpression instanceof FieldAccess) {
                return tm.firstIndexIn(((FieldAccess)this.accessExpression).getName(), 15);
            }
            if (this.accessExpression instanceof QualifiedName) {
                return tm.firstIndexIn(((QualifiedName)this.accessExpression).getName(), 15);
            }
            if (this.accessExpression instanceof ThisExpression) {
                return tm.lastIndexIn(this.accessExpression, 44);
            }
            if (this.accessExpression instanceof SuperFieldAccess) {
                return tm.lastIndexIn(this.accessExpression, 43);
            }
            throw new AssertionError();
        }
    }
}

