/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.egit.ui.internal.repository.tree.BranchHierarchyNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.util.LfsFactory;

public class RepositoriesViewPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean value = this.internalTest(receiver, property);
        boolean trace = GitTraceLocation.PROPERTIESTESTER.isActive();
        if (trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.PROPERTIESTESTER.getLocation(), "prop " + property + " of " + receiver + " = " + value + ", expected = " + expectedValue);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalTest(Object receiver, String property) {
        if (!(receiver instanceof RepositoryTreeNode)) {
            return false;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)receiver;
        Repository repository = node.getRepository();
        if (repository == null) {
            return false;
        }
        if (property.equals("isBare")) {
            return repository.isBare();
        }
        if (property.equals("containsHead")) {
            return this.containsHead(repository);
        }
        if (ResourcePropertyTester.testRepositoryState(repository, property)) {
            return true;
        }
        if (property.equals("isRefCheckedOut")) {
            Ref ref2;
            if (node instanceof BranchHierarchyNode) {
                try {
                    for (Ref ref2 : ((BranchHierarchyNode)node).getChildRefsRecursive()) {
                        if (!this.isRefCheckedOut(repository, ref2)) continue;
                        return true;
                    }
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (!(node.getObject() instanceof Ref)) {
                return false;
            }
            ref2 = (Ref)node.getObject();
            return this.isRefCheckedOut(repository, ref2);
        }
        if (property.equals("isLocalBranch")) {
            if (!(node.getObject() instanceof Ref)) {
                return false;
            }
            Ref ref = (Ref)node.getObject();
            return ref.getName().startsWith("refs/heads/");
        }
        if (property.equals("fetchExists") && node instanceof RemoteNode) {
            RemoteConfig rconfig;
            String configName = (String)((RemoteNode)node).getObject();
            try {
                rconfig = new RemoteConfig((Config)repository.getConfig(), configName);
            }
            catch (URISyntaxException e2) {
                return false;
            }
            if (rconfig.getFetchRefSpecs().isEmpty()) return false;
            if (rconfig.getURIs().isEmpty()) return false;
            return true;
        }
        if (property.equals("pushExists") && node instanceof RemoteNode) {
            RemoteConfig rconfig;
            String configName = (String)((RemoteNode)node).getObject();
            try {
                rconfig = new RemoteConfig((Config)repository.getConfig(), configName);
            }
            catch (URISyntaxException e2) {
                return false;
            }
            if (rconfig.getPushRefSpecs().isEmpty()) return false;
            if (!rconfig.getPushURIs().isEmpty()) return true;
            if (rconfig.getURIs().isEmpty()) return false;
            return true;
        }
        if (property.equals("canStash")) {
            return repository.getRepositoryState().canCommit();
        }
        if (property.equals("canMerge")) {
            if (repository.getRepositoryState() != RepositoryState.SAFE) {
                return false;
            }
            try {
                String branch = repository.getFullBranch();
                if (branch != null) return branch.startsWith("refs/heads/");
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        if ("isSubmodule".equals(property)) {
            RepositoryTreeNode parent = node.getParent();
            if (parent == null) return false;
            if (parent.getType() != RepositoryTreeNodeType.SUBMODULES) return false;
            return true;
        }
        if (!"canEnableLfs".equals(property)) return false;
        if (!LfsFactory.getInstance().isAvailable()) return false;
        if (!LfsFactory.getInstance().isEnabled(repository)) return true;
        return false;
    }

    private boolean isRefCheckedOut(Repository repository, Ref ref) {
        block6: {
            block5: {
                try {
                    if (ref.getName().startsWith("refs/")) {
                        return ref.getName().equals(repository.getFullBranch());
                    }
                    if (!ref.getName().equals("HEAD")) break block5;
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            String leafname = ref.getLeaf().getName();
            if (!leafname.startsWith("refs/") || !leafname.equals(repository.getFullBranch())) break block6;
            return true;
        }
        ObjectId objectId = ref.getLeaf().getObjectId();
        return objectId != null && objectId.equals((AnyObjectId)repository.resolve("HEAD"));
    }

    private boolean containsHead(Repository repository) {
        try {
            return repository.resolve("HEAD") != null;
        }
        catch (IOException e) {
            return false;
        }
    }
}

