/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.delegate;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecoretools.ale.core.delegate.ALEInvocationDelegate;
import org.eclipse.emf.ecoretools.ale.core.delegate.EAnnotationParser;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ALEEngine;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DiagnosticLogger;
import org.eclipse.emf.ecoretools.ale.core.interpreter.EvalEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ExtensionEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class ALEInvocationDelegateFactory
implements EOperation.Internal.InvocationDelegate.Factory {
    ALEEngine engine;
    List<ModelUnit> allBehaviors;
    List<EPackage> scope;

    public ALEInvocationDelegateFactory() {
    }

    public ALEInvocationDelegateFactory(List<EPackage> scope) {
        this.scope = scope;
    }

    public EOperation.Internal.InvocationDelegate createInvocationDelegate(EOperation operation) {
        ALEEngine engine = this.getEngine();
        Optional<Method> method = this.allBehaviors.stream().flatMap(unit -> unit.getClassExtensions().stream()).flatMap(cls -> cls.getMethods().stream()).filter(mtd -> mtd.getOperationRef() == operation).findFirst();
        return new ALEInvocationDelegate(engine, method);
    }

    public ALEEngine getEngine() {
        if (this.engine == null) {
            ExtensionEnvironment qryEnv = new ExtensionEnvironment();
            qryEnv.registerEPackage((EPackage)EcorePackage.eINSTANCE);
            qryEnv.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
            qryEnv.registerEPackage(ImplementationPackage.eINSTANCE);
            qryEnv.registerEPackage((EPackage)AstPackage.eINSTANCE);
            List<EPackage> pkgs = this.getAllPackages();
            for (EPackage ePkg : pkgs) {
                qryEnv.registerEPackage(ePkg);
            }
            List<ParseResult<ModelUnit>> parsedSemantics = new EAnnotationParser(qryEnv).parse(pkgs);
            this.allBehaviors = parsedSemantics.stream().filter(sem -> sem.getRoot() != null).map(sem -> (ModelUnit)sem.getRoot()).collect(Collectors.toList());
            DiagnosticLogger logger = new DiagnosticLogger(parsedSemantics);
            EvalEnvironment env = new EvalEnvironment(qryEnv, this.allBehaviors, logger, null);
            this.engine = new ALEEngine(env);
        }
        return this.engine;
    }

    private List<EPackage> getAllPackages() {
        if (this.scope != null) {
            return this.scope;
        }
        ArrayList<EPackage> pkgs = new ArrayList<EPackage>();
        pkgs.addAll(EPackageRegistryImpl.createGlobalRegistry().values());
        return pkgs;
    }
}

