/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.delegate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.parser.ALELexer;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.AstVisitors;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ModelBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationFactory;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class EAnnotationParser {
    ImplementationFactory factory = (ImplementationFactory)ImplementationPackage.eINSTANCE.getEFactoryInstance();

    public EAnnotationParser(IQueryEnvironment qryEnv) {
        ModelBuilder.createSingleton(qryEnv);
    }

    public List<ParseResult<ModelUnit>> parse(List<EPackage> pkgs) {
        ArrayList<ParseResult<ModelUnit>> results = new ArrayList<ParseResult<ModelUnit>>();
        pkgs.forEach(pkg -> {
            Optional<ParseResult<ModelUnit>> unit = this.parse((EPackage)pkg);
            if (unit.isPresent()) {
                results.add(unit.get());
            }
        });
        return results;
    }

    public Optional<ParseResult<ModelUnit>> parse(EPackage pkg) {
        ParseResult<ModelUnit> parseRes = new ParseResult<ModelUnit>();
        parseRes.setDiagnostic((Diagnostic)new BasicDiagnostic());
        ArrayList allExtensions = new ArrayList();
        pkg.getEClassifiers().stream().filter(cls -> cls instanceof EClass).forEach(cls -> {
            List<Method> allImplem = this.parse((EClass)cls, parseRes);
            if (!allImplem.isEmpty()) {
                ExtendedClass xtdCls = this.factory.createExtendedClass();
                xtdCls.setBaseClass((EClass)cls);
                xtdCls.setName(cls.getName());
                xtdCls.getMethods().addAll(allImplem);
                allExtensions.add(xtdCls);
            }
        });
        if (!allExtensions.isEmpty()) {
            ModelUnit unit = this.factory.createModelUnit();
            unit.setName(this.qualifiedName(pkg));
            unit.getClassExtensions().addAll(allExtensions);
            parseRes.setRoot(unit);
            return Optional.of(parseRes);
        }
        return Optional.empty();
    }

    public List<Method> parse(EClass cls, ParseResult<ModelUnit> parseRes) {
        ArrayList<Method> allImplem = new ArrayList<Method>();
        cls.getEOperations().forEach(op -> {
            Optional<Method> mtd = this.parse((EOperation)op, parseRes);
            if (mtd.isPresent()) {
                allImplem.add(mtd.get());
            }
        });
        return allImplem;
    }

    public Optional<Method> parse(EOperation op, ParseResult<ModelUnit> parseRes) {
        String body = EcoreUtil.getAnnotation((EModelElement)op, (String)"http://implementation/", (String)"body");
        if (body != null) {
            if (!body.trim().startsWith("{") || !body.trim().endsWith("}")) {
                body = "{" + body + "}";
            }
            try {
                ALEParser.RBlockContext blockAst = this.parse(body);
                Block block = (Block)new AstVisitors.BlockVisitor(parseRes).visit((ParseTree)blockAst);
                return Optional.of(ModelBuilder.singleton.buildMethod(op, block, Arrays.asList(new String[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    private ALEParser.RBlockContext parse(String content) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        ANTLRInputStream input = new ANTLRInputStream((InputStream)stream);
        ALELexer lexer = new ALELexer((CharStream)input);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ALEParser parser = new ALEParser((TokenStream)tokens);
        return parser.rBlock();
    }

    private String qualifiedName(EPackage pkg) {
        return pkg.getESuperPackage() == null ? pkg.getName() : String.valueOf(this.qualifiedName(pkg.getESuperPackage())) + "." + pkg.getName();
    }
}

