/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.services;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.impl.completion.EFeatureCompletionProposal;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DynamicFeatureRegistry;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;

public class DynamicEObjectFeatureAccess
extends JavaMethodService {
    public static final String UNKNOWN_FEATURE = "Feature %s not found in EClass %s";
    private static final String DON_T_KNOW_WHAT_TO_DO_WITH = "don't know what to do with ";
    private static final String NON_EOBJECT_FEATURE_ACCESS = "Attempt to access feature (%s) on a non ModelObject value (%s).";
    DynamicFeatureRegistry dynamicFeatures;

    public DynamicEObjectFeatureAccess(Method method, Object serviceInstance, DynamicFeatureRegistry dynamicFeatures) {
        super(method, serviceInstance);
        this.dynamicFeatures = dynamicFeatures;
    }

    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        String featureName = ((StringLiteral)call.getArguments().get(1)).getValue();
        Set<IType> result = this.featureAccessTypes(services, queryEnvironment, argTypes.get(0), featureName);
        return result;
    }

    public Set<IType> featureAccessTypes(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, IType receiverType, String featureName) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        LinkedHashSet<EClass> receiverEClasses = new LinkedHashSet<EClass>();
        if (receiverType.getType() instanceof EClass) {
            receiverEClasses.add((EClass)receiverType.getType());
        } else if (receiverType.getType() instanceof Class) {
            Set eClassifiers = queryEnvironment.getEPackageProvider().getEClassifiers((Class)receiverType.getType());
            if (eClassifiers != null) {
                for (EClassifier eCls : eClassifiers) {
                    if (!(eCls instanceof EClass)) continue;
                    receiverEClasses.add((EClass)eCls);
                }
            }
        } else if (receiverType.getType() != null) {
            throw new IllegalStateException(DON_T_KNOW_WHAT_TO_DO_WITH + receiverType.getType());
        }
        if (receiverEClasses.isEmpty()) {
            if (receiverType.getType() != null) {
                result.add((IType)services.nothing(NON_EOBJECT_FEATURE_ACCESS, new Object[]{featureName, receiverType.getType().toString()}));
            } else {
                result.add((IType)services.nothing(NON_EOBJECT_FEATURE_ACCESS, new Object[]{featureName, "null"}));
            }
        } else {
            for (EClass eClass : receiverEClasses) {
                Optional<Attribute> dynamicFeature;
                EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
                if (feature == null && (dynamicFeature = this.dynamicFeatures.findFeature(eClass, featureName)).isPresent()) {
                    feature = dynamicFeature.get().getFeatureRef();
                }
                if (feature == null) {
                    result.add((IType)services.nothing(UNKNOWN_FEATURE, new Object[]{featureName, eClass.getName()}));
                    continue;
                }
                EClassifierType featureBasicType = new EClassifierType(queryEnvironment, feature.getEType());
                if (feature.isMany()) {
                    result.add((IType)new SequenceType(queryEnvironment, (IType)featureBasicType));
                    continue;
                }
                result.add((IType)featureBasicType);
            }
        }
        return result;
    }

    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        LinkedHashSet<IType> knownReceiverTypes = new LinkedHashSet<IType>();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            if (!knownReceiverTypes.add(entry.getKey().get(0))) continue;
            result.addAll((Collection<IType>)entry.getValue());
        }
        return result;
    }

    public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        return this.getEStructuralFeatureProposals(queryEnvironment, receiverTypes);
    }

    public List<ICompletionProposal> getEStructuralFeatureProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        for (IType iType : receiverTypes) {
            if (!(iType.getType() instanceof EClass)) continue;
            eClasses.add((EClass)iType.getType());
        }
        for (EStructuralFeature feature : queryEnvironment.getEPackageProvider().getEStructuralFeatures(eClasses)) {
            result.add((ICompletionProposal)new EFeatureCompletionProposal(feature));
        }
        return result;
    }
}

