/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecoretools.ale.core.parser.AstBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class DslBuilder {
    IQueryEnvironment queryEnvironment;
    ResourceSet rs;

    public DslBuilder(IQueryEnvironment qryEnv) {
        this.queryEnvironment = qryEnv;
        this.rs = new ResourceSetImpl();
    }

    public DslBuilder(IQueryEnvironment qryEnv, ResourceSet rs) {
        this.queryEnvironment = qryEnv;
        this.rs = rs;
    }

    public List<ParseResult<ModelUnit>> parse(Dsl dsl) {
        this.cleanUp();
        this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new XMIResourceFactoryImpl());
        dsl.getAllSyntaxes().stream().forEach(syntaxURI -> {
            List<EPackage> pkgImports = DslBuilder.load(syntaxURI, this.rs);
            ArrayList<EPackage> toRegister = new ArrayList<EPackage>();
            for (EPackage pkg : pkgImports) {
                EPackage registryPkg = this.rs.getPackageRegistry().getEPackage(pkg.getNsURI());
                if (registryPkg == null) {
                    toRegister.add(pkg);
                    continue;
                }
                toRegister.add(registryPkg);
            }
            this.register(toRegister);
        });
        List<ParseResult<ModelUnit>> parsedSemantics = new AstBuilder(this.queryEnvironment).parseFromFiles(dsl.getAllSemantics());
        return parsedSemantics;
    }

    public List<ParseResult<ModelUnit>> parse(List<EPackage> context, List<InputStream> inputs) {
        this.cleanUp();
        this.register(context);
        List<ParseResult<ModelUnit>> parsedSemantics = new AstBuilder(this.queryEnvironment).parseFromInputStreams(inputs);
        return parsedSemantics;
    }

    public List<EPackage> getSyntaxes(Dsl dsl) {
        return dsl.getAllSyntaxes().stream().flatMap(syntaxURI -> DslBuilder.load(syntaxURI, this.rs).stream()).collect(Collectors.toList());
    }

    private void cleanUp() {
        List<EPackage> toRemove = this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().stream().filter(p -> p.getNsURI().startsWith("http://ale/runtime/")).collect(Collectors.toList());
        toRemove.forEach(p -> this.queryEnvironment.removeEPackage(p));
    }

    private void register(List<EPackage> packages) {
        packages.stream().forEach(pkg -> {
            Collection matchingPkgs = this.queryEnvironment.getEPackageProvider().getEPackage(pkg.getName());
            Optional<EPackage> existingPkg = matchingPkgs.stream().filter(p -> p.getNsURI().equals(pkg.getNsURI())).findFirst();
            if (!existingPkg.isPresent()) {
                this.queryEnvironment.registerEPackage(pkg);
            }
        });
    }

    public static List<EPackage> load(String ecoreURI, ResourceSet rs) {
        URI uri = URI.createURI((String)ecoreURI);
        Resource res = rs.getResource(uri, true);
        return res.getContents().stream().filter(o -> o instanceof EPackage).map(o -> (EPackage)o).collect(Collectors.toList());
    }
}

