/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser.visitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.Diagnostic;

public class ParseResult<T> {
    private String sourceFile;
    private final Map<Object, Integer> startPositions = new HashMap<Object, Integer>();
    private final Map<Object, Integer> endPositions = new HashMap<Object, Integer>();
    private Diagnostic diagnostic;
    private T root;

    public Map<Object, Integer> getStartPositions() {
        return this.startPositions;
    }

    public Map<Object, Integer> getEndPositions() {
        return this.endPositions;
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }

    public T getRoot() {
        return this.root;
    }

    public void setRoot(T root) {
        this.root = root;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public Optional<String> getText(Object element) {
        int start = this.startPositions.get(element);
        int end = this.endPositions.get(element);
        int length = end - start + 1;
        char[] cbuf = new char[length];
        Path path = Paths.get(this.sourceFile, new String[0]);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (BufferedReader reader = Files.newBufferedReader(path);){
                reader.read(cbuf, start, length);
                return Optional.of(new String(cbuf));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

