/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine.ui.launcher.tabs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.gemoc.ale.interpreted.engine.Helper;
import org.eclipse.gemoc.ale.interpreted.engine.ui.Activator;
import org.eclipse.gemoc.ale.interpreted.engine.ui.MethodLabelProvider;
import org.eclipse.gemoc.ale.interpreted.engine.ui.SelectMainMethodDialog;
import org.eclipse.gemoc.commons.eclipse.emf.URIHelper;
import org.eclipse.gemoc.commons.eclipse.ui.dialogs.SelectAnyIFileDialog;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.sequential.SequentialRunConfiguration;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs.ILaunchLanguageSelectionListener;
import org.eclipse.gemoc.executionframework.ui.utils.ENamedElementQualifiedNameLabelProvider;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectAIRDIFileDialog;
import org.eclipse.gemoc.xdsmlframework.ui.utils.dialogs.SelectAnyEObjectDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class LaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    protected Composite parent;
    protected IProject _modelProject;
    protected Text _modelLocationText;
    protected Text _modelInitializationMethodText;
    protected Text _modelInitializationArgumentsText;
    protected Combo _languageCombo;
    protected Text _siriusRepresentationLocationText;
    protected Text _delayText;
    protected Button _animationFirstBreak;
    protected Group _execArea;
    protected Text _entryPointModelElementText;
    protected Label _entryPointModelElementLabel;
    protected Text _entryPointMethodText;
    protected ArrayList<ILaunchLanguageSelectionListener> _languageSelectionListeners = new ArrayList();
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private Resource currentModelResource;

    public void createControl(Composite parent) {
        this.parent = parent;
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        area.setLayout((Layout)gl);
        area.layout();
        this.setControl((Control)area);
        Group modelArea = this.createGroup(area, "Model:");
        this.createModelLayout((Composite)modelArea, null);
        Group languageArea = this.createGroup(area, "Language:");
        this.createLanguageLayout((Composite)languageArea, null);
        Group debugArea = this.createGroup(area, "Animation:");
        this.createAnimationLayout((Composite)debugArea, null);
        this._execArea = this.createGroup(area, "Sequential DSA execution:");
        this.createExecLayout((Composite)this._execArea, null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("LAUNCH_MODEL_ENTRY_POINT", "/");
        configuration.setAttribute("GEMOC_ANIMATE_DELAY", 1000);
        configuration.setAttribute("LAUNCH_MODEL_ENTRY_POINT", "");
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            SequentialRunConfiguration runConfiguration = new SequentialRunConfiguration(configuration);
            this._modelLocationText.setText(URIHelper.removePlatformScheme((URI)runConfiguration.getExecutedModelURI()));
            if (runConfiguration.getAnimatorURI() != null) {
                this._siriusRepresentationLocationText.setText(URIHelper.removePlatformScheme((URI)runConfiguration.getAnimatorURI()));
            } else {
                this._siriusRepresentationLocationText.setText("");
            }
            this._delayText.setText(Integer.toString(runConfiguration.getAnimationDelay()));
            this._animationFirstBreak.setSelection(runConfiguration.getBreakStart());
            this._entryPointModelElementText.setText(runConfiguration.getModelEntryPoint());
            this._languageCombo.setText(runConfiguration.getLanguageName());
            this._modelInitializationMethodText.setText(runConfiguration.getModelInitializationMethod());
            this._modelInitializationArgumentsText.setText(runConfiguration.getModelInitializationArguments());
            this._entryPointModelElementLabel.setText("");
            this._entryPointMethodText.setText(runConfiguration.getExecutionEntryPoint());
            this.updateMainElementName();
            org.eclipse.gemoc.dsl.Dsl language = DslHelper.load((String)this._languageCombo.getText());
            if (language != null) {
                List errors = Helper.validate((org.eclipse.gemoc.dsl.Dsl)language);
                for (String error : errors) {
                    this.setErrorMessage(error);
                }
            } else {
                this.setErrorMessage("Can't find the language: '" + this._languageCombo.getText() + "'");
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean isValid = super.isValid(launchConfig);
        this.setErrorMessage(null);
        this.setMessage(null);
        org.eclipse.gemoc.dsl.Dsl language = DslHelper.load((String)this._languageCombo.getText());
        if (language != null) {
            List errors = Helper.validate((org.eclipse.gemoc.dsl.Dsl)language);
            for (String error : errors) {
                isValid = false;
                this.setErrorMessage(error);
            }
        }
        try {
            Resource model = this.getModel();
            if (model == null) {
                this.setErrorMessage("Please select a model to execute.");
            } else if (this._languageCombo.getText() == null || this._languageCombo.getText().isEmpty()) {
                this.setErrorMessage("Please select a language.");
            } else if (this._entryPointMethodText.getText() == null || this._entryPointMethodText.getText().equals("")) {
                this.setErrorMessage("Please select a main method.");
            } else if (this._entryPointModelElementText.getText() == null || this._entryPointModelElementText.getText().isEmpty()) {
                this.setErrorMessage("Please select the main model element.");
            }
        }
        catch (Exception e) {
            this.setErrorMessage("Please select a model to execute.");
        }
        return isValid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Resource", this._modelLocationText.getText());
        configuration.setAttribute("airdResource", this._siriusRepresentationLocationText.getText());
        configuration.setAttribute("GEMOC_ANIMATE_DELAY", Integer.parseInt(this._delayText.getText()));
        configuration.setAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", this._languageCombo.getText());
        configuration.setAttribute("LAUNCH_MODEL_ENTRY_POINT", this._entryPointModelElementText.getText());
        configuration.setAttribute("LAUNCH_METHOD_ENTRY_POINT", this._entryPointMethodText.getText());
        configuration.setAttribute("GEMOC_LAUNCH_INITIALIZATION_METHOD", this._modelInitializationMethodText.getText());
        configuration.setAttribute("GEMOC_LAUNCH_INITIALIZATION_ARGUMENTS", this._modelInitializationArgumentsText.getText());
        configuration.setAttribute("GEMOC_LAUNCH_BREAK_START", this._animationFirstBreak.getSelection());
        configuration.setAttribute("GEMOC_DEBUG_MODEL_ID", "org.eclipse.gemoc.executionframework.engine.ui.generic.debugModel");
    }

    public String getName() {
        return "Main";
    }

    protected Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout locationLayout = new GridLayout();
        locationLayout.numColumns = 3;
        locationLayout.marginHeight = 10;
        locationLayout.marginWidth = 10;
        group.setLayout((Layout)locationLayout);
        return group;
    }

    protected void createTextLabelLayout(Composite parent, String labelString) {
        GridData gd = new GridData(768);
        parent.setLayoutData((Object)gd);
        Label inputLabel = new Label(parent, 0);
        inputLabel.setText(labelString);
    }

    private GridData createStandardLayout() {
        return new GridData(4, 0x1000000, true, false);
    }

    public Composite createModelLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Model to execute");
        this._modelLocationText = new Text(parent, 2052);
        this._modelLocationText.setLayoutData((Object)this.createStandardLayout());
        this._modelLocationText.setFont(font);
        this._modelLocationText.addModifyListener(this.fBasicModifyListener);
        Button modelLocationButton = this.createPushButton(parent, "Browse", null);
        modelLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAnyIFileDialog dialog = new SelectAnyIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    LaunchConfigurationMainTab.this._modelLocationText.setText(modelPath);
                    LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                    LaunchConfigurationMainTab.this._modelProject = ((IResource)dialog.getResult()[0]).getProject();
                }
            }
        });
        this.createTextLabelLayout(parent, "Model initialization method");
        this._modelInitializationMethodText = new Text(parent, 2052);
        this._modelInitializationMethodText.setLayoutData((Object)this.createStandardLayout());
        this._modelInitializationMethodText.setFont(font);
        this._modelInitializationMethodText.setEditable(false);
        this.createTextLabelLayout(parent, "");
        this.createTextLabelLayout(parent, "Model initialization arguments");
        this._modelInitializationArgumentsText = new Text(parent, 2626);
        this._modelInitializationArgumentsText.setToolTipText("one argument per line");
        GridData gridData = new GridData(1808);
        gridData.heightHint = 40;
        this._modelInitializationArgumentsText.setLayoutData((Object)gridData);
        this._modelInitializationArgumentsText.setLayoutData((Object)this.createStandardLayout());
        this._modelInitializationArgumentsText.setFont(font);
        this._modelInitializationArgumentsText.setEditable(true);
        this._modelInitializationArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "");
        return parent;
    }

    public Composite createLanguageLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "ALE Languages");
        this._languageCombo = new Combo(parent, 0);
        this._languageCombo.setLayoutData((Object)this.createStandardLayout());
        List<String> languagesNames = this.getAllLanguages();
        String[] empty = new String[]{};
        this._languageCombo.setItems(languagesNames.toArray(empty));
        this._languageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ILaunchLanguageSelectionListener listener : LaunchConfigurationMainTab.this._languageSelectionListeners) {
                    listener.languageChanged(LaunchConfigurationMainTab.this._languageCombo.getText());
                }
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "");
        return parent;
    }

    private Composite createAnimationLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Animator");
        this._siriusRepresentationLocationText = new Text(parent, 2052);
        this._siriusRepresentationLocationText.setLayoutData((Object)this.createStandardLayout());
        this._siriusRepresentationLocationText.setFont(font);
        this._siriusRepresentationLocationText.addModifyListener(this.fBasicModifyListener);
        Button siriusRepresentationLocationButton = this.createPushButton(parent, "Browse", null);
        siriusRepresentationLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SelectAIRDIFileDialog dialog = new SelectAIRDIFileDialog();
                if (dialog.open() == 0) {
                    String modelPath = ((IResource)dialog.getResult()[0]).getFullPath().toPortableString();
                    LaunchConfigurationMainTab.this._siriusRepresentationLocationText.setText(modelPath);
                    LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.createTextLabelLayout(parent, "Delay");
        this._delayText = new Text(parent, 2052);
        this._delayText.setLayoutData((Object)this.createStandardLayout());
        this._delayText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createTextLabelLayout(parent, "(in milliseconds)");
        new Label(parent, 0).setText("");
        this._animationFirstBreak = new Button(parent, 32);
        this._animationFirstBreak.setText("Break at start");
        this._animationFirstBreak.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        return parent;
    }

    private Composite createExecLayout(Composite parent, Font font) {
        this.createTextLabelLayout(parent, "Main method");
        this._entryPointMethodText = new Text(parent, 2052);
        this._entryPointMethodText.setLayoutData((Object)this.createStandardLayout());
        this._entryPointMethodText.setFont(font);
        this._entryPointMethodText.setEditable(false);
        this._entryPointMethodText.addModifyListener(this.fBasicModifyListener);
        Button mainMethodBrowseButton = this.createPushButton(parent, "Browse", null);
        mainMethodBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (LaunchConfigurationMainTab.this._languageCombo.getText() == null) {
                    LaunchConfigurationMainTab.this.setErrorMessage("Please select a language.");
                } else {
                    MethodLabelProvider labelProvider;
                    org.eclipse.gemoc.dsl.Dsl language = DslHelper.load((String)LaunchConfigurationMainTab.this._languageCombo.getText());
                    SelectMainMethodDialog dialog = new SelectMainMethodDialog(language, null, (ILabelProvider)(labelProvider = new MethodLabelProvider()));
                    int res = dialog.open();
                    if (res == 0) {
                        Method selection = (Method)dialog.getFirstResult();
                        LaunchConfigurationMainTab.this._entryPointMethodText.setText(labelProvider.getText(selection));
                    }
                }
            }
        });
        this.createTextLabelLayout(parent, "Main model element path");
        this._entryPointModelElementText = new Text(parent, 2052);
        this._entryPointModelElementText.setLayoutData((Object)this.createStandardLayout());
        this._entryPointModelElementText.setFont(font);
        this._entryPointModelElementText.setEditable(false);
        this._entryPointModelElementText.addModifyListener(event -> this.updateMainElementName());
        this._entryPointModelElementText.addModifyListener(this.fBasicModifyListener);
        Button mainModelElemBrowseButton = this.createPushButton(parent, "Browse", null);
        mainModelElemBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Resource model = LaunchConfigurationMainTab.this.getModel();
                if (model == null) {
                    LaunchConfigurationMainTab.this.setErrorMessage("Please select a model to execute.");
                } else if (LaunchConfigurationMainTab.this._entryPointMethodText.getText() == null || LaunchConfigurationMainTab.this._entryPointMethodText.getText().equals("")) {
                    LaunchConfigurationMainTab.this.setErrorMessage("Please select a main method.");
                } else {
                    SelectAnyEObjectDialog dialog = new SelectAnyEObjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), model.getResourceSet(), (ILabelProvider)new ENamedElementQualifiedNameLabelProvider()){

                        protected boolean select(EObject obj) {
                            String methodSignature = (this).LaunchConfigurationMainTab.this._entryPointMethodText.getText();
                            ArrayList segments = Lists.newArrayList((Object[])methodSignature.split("::"));
                            if (segments.size() >= 2) {
                                String callerTypeName = (String)segments.get(segments.size() - 2);
                                if (obj.eClass().getName().equals(callerTypeName)) {
                                    return true;
                                }
                            }
                            return false;
                        }
                    };
                    int res = dialog.open();
                    if (res == 0) {
                        EObject selection = (EObject)dialog.getFirstResult();
                        String uriFragment = selection.eResource().getURIFragment(selection);
                        LaunchConfigurationMainTab.this._entryPointModelElementText.setText(uriFragment);
                    }
                }
            }
        });
        this.createTextLabelLayout(parent, "Main model element name");
        this._entryPointModelElementLabel = new Label(parent, 256);
        this._entryPointModelElementLabel.setText("");
        return parent;
    }

    private Resource getModel() {
        URI modelURI = URI.createPlatformResourceURI((String)this._modelLocationText.getText(), (boolean)true);
        if (this.currentModelResource == null || !this.currentModelResource.getURI().equals(modelURI)) {
            this.currentModelResource = LaunchConfigurationMainTab.loadModel(modelURI);
        }
        return this.currentModelResource;
    }

    public static Resource loadModel(URI modelURI) {
        Resource resource = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resource = resourceSet.createResource(modelURI);
        try {
            resource.load(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource;
    }

    private void updateMainElementName() {
        try {
            Resource model = this.getModel();
            EObject mainElement = null;
            if (model != null) {
                mainElement = model.getEObject(this._entryPointModelElementText.getText());
            }
            if (mainElement != null) {
                DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
                QualifiedName qname = nameprovider.getFullyQualifiedName(mainElement);
                String objectName = qname != null ? qname.toString() : mainElement.toString();
                String prettyName = String.valueOf(objectName) + " : " + mainElement.eClass().getName();
                this._entryPointModelElementLabel.setText(prettyName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this._execArea.setVisible(true);
        this._modelInitializationMethodText.setText(this.getModelInitializationMethodName());
        this._modelInitializationArgumentsText.setEnabled(!this._modelInitializationMethodText.getText().isEmpty());
    }

    protected String getModelInitializationMethodName() {
        List<String> segments;
        if (this._languageCombo.getText() != null && this._entryPointMethodText.getText() != null && (segments = Arrays.asList(this._entryPointMethodText.getText().split("::"))).size() >= 2) {
            String tagetClassName = segments.get(segments.size() - 2);
            org.eclipse.gemoc.dsl.Dsl language = DslHelper.load((String)this._languageCombo.getText());
            Dsl environment = Helper.gemocDslToAleDsl((org.eclipse.gemoc.dsl.Dsl)language);
            Throwable throwable = null;
            Object var6_7 = null;
            try (ALEInterpreter interpreter = new ALEInterpreter();){
                Optional<Object> initOperation = Optional.empty();
                try {
                    List parsedSemantics = new DslBuilder(interpreter.getQueryEnvironment()).parse(environment);
                    initOperation = parsedSemantics.stream().filter(sem -> sem.getRoot() != null).map(sem -> (ModelUnit)sem.getRoot()).flatMap(unit -> unit.getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass().getName().equals(tagetClassName)).flatMap(xtdCls -> xtdCls.getMethods().stream()).filter(op -> op.getTags().contains((Object)"init")).findFirst();
                }
                catch (Exception e) {
                    Activator.error(e.getMessage(), e);
                }
                if (initOperation.isPresent()) {
                    return new MethodLabelProvider().getText(initOperation.get());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return "";
    }

    public List<String> getAllLanguages() {
        IConfigurationElement[] languages;
        ArrayList<String> languagesNames = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = languages = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.xdsml");
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lang = iConfigurationElementArray[n2];
            String xdsmlPath = lang.getAttribute("xdsmlFilePath");
            String xdsmlName = lang.getAttribute("name");
            if (xdsmlPath.endsWith(".dsl")) {
                languagesNames.add(xdsmlName);
            }
            ++n2;
        }
        return languagesNames;
    }

    public void registerLaunchLanguageSelectionListener(ILaunchLanguageSelectionListener listener) {
        this._languageSelectionListeners.add(listener);
    }
}

