/**
 * generated by Xtext 2.10.0
 */
package org.eclipse.gemoc.validation;

import com.google.common.base.Objects;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.DslPackage;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.validation.AbstractDslValidator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.ILanguageComponentValidator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.LanguageComponentHelper;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Message;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Severity;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class DslValidator extends AbstractDslValidator {
  public final static String MISSING_NAME = "missingName";
  
  public final static String MISSING_KEY = "missingKey";
  
  public final static String DUPLICATEKEY = "duplicateKey";
  
  public final IConfigurationElement[] exts = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.gemoc_language_workbench.metaprog");
  
  public final LanguageComponentHelper languageHelper = new LanguageComponentHelper();
  
  public ArrayList<IConfigurationElement> keys = new ArrayList<IConfigurationElement>();
  
  public String metaprog;
  
  @Check
  public void checkDSLHasName(final Dsl dsl) {
    boolean _isEmpty = dsl.getName().isEmpty();
    if (_isEmpty) {
      this.error("Missing an entry \"name\"", 
        DslPackage.Literals.DSL__NAME, 
        DslValidator.MISSING_NAME);
    }
  }
  
  @Check
  public void checkDuplicateKeys(final Entry entry) {
    EObject _eContainer = entry.eContainer();
    final Dsl dsl = ((Dsl) _eContainer);
    final Function1<Entry, Boolean> _function = (Entry e) -> {
      String _key = e.getKey();
      String _key_1 = entry.getKey();
      return Boolean.valueOf(Objects.equal(_key, _key_1));
    };
    final Function1<Entry, Boolean> _function_1 = (Entry e) -> {
      return Boolean.valueOf((e == entry));
    };
    boolean _forall = IterableExtensions.<Entry>forall(IterableExtensions.<Entry>filter(dsl.getEntries(), _function), _function_1);
    boolean _not = (!_forall);
    if (_not) {
      String _key = entry.getKey();
      String _plus = ("Duplicate key \"" + _key);
      String _plus_1 = (_plus + "\"");
      this.error(_plus_1, 
        DslPackage.Literals.ENTRY__KEY, 
        DslValidator.DUPLICATEKEY);
    }
  }
  
  @Check
  public void checkForEntry(final Entry entry) {
    try {
      for (final IConfigurationElement key : this.keys) {
        {
          Object _createExecutableExtension = key.createExecutableExtension("validationRule");
          final ILanguageComponentValidator rule = ((ILanguageComponentValidator) _createExecutableExtension);
          Message message = rule.validate(entry);
          Severity _severity = message.getSeverity();
          if (_severity != null) {
            switch (_severity) {
              case ERROR:
                this.error(message.getContent(), 
                  DslPackage.Literals.ENTRY__VALUE);
                break;
              case WARNING:
                this.warning(message.getContent(), 
                  DslPackage.Literals.ENTRY__VALUE);
                break;
              case INFO:
                this.info(message.getContent(), 
                  DslPackage.Literals.ENTRY__VALUE);
                break;
              case DEFAULT:
                Message _message = new Message();
                message = _message;
                break;
              default:
                InputOutput.<String>print("Unknown severity");
                break;
            }
          } else {
            InputOutput.<String>print("Unknown severity");
          }
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Check
  public void checkForApproachEntry(final Dsl dsl) {
    final Function1<Entry, Boolean> _function = (Entry e) -> {
      String _key = e.getKey();
      return Boolean.valueOf(Objects.equal(_key, "metaprog"));
    };
    boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<Entry>filter(dsl.getEntries(), _function));
    if (_isEmpty) {
      this.warning("Missing \"metaprog\" entry to define the metaprogramming approach used", DslPackage.Literals.DSL__NAME);
    }
  }
  
  @Check
  public void checkApproach(final Entry entry) {
    ArrayList<String> approachesList = new ArrayList<String>();
    boolean _matches = "metaprog".matches(entry.getKey());
    if (_matches) {
      this.metaprog = entry.getValue();
      for (final IConfigurationElement elem : this.exts) {
        approachesList.add(elem.getAttribute("name"));
      }
      boolean _contains = approachesList.contains(this.metaprog);
      boolean _not = (!_contains);
      if (_not) {
        this.error("Unknown metaprogramming approach", DslPackage.Literals.ENTRY__VALUE);
      }
    }
  }
  
  @Check
  public void checkMissingKeys(final Dsl dsl) {
    ArrayList<String> dslKeys = new ArrayList<String>();
    EList<Entry> _entries = dsl.getEntries();
    for (final Entry entry : _entries) {
      dslKeys.add(entry.getKey());
    }
    this.keys = this.languageHelper.getFullApproachKeys(this.metaprog);
    for (final IConfigurationElement elem : this.keys) {
      {
        String name = elem.getAttribute("name");
        if (((!dslKeys.contains(name)) && "false".matches(elem.getAttribute("optional")))) {
          this.error((("Missing entry " + name) + " in the dsl file."), DslPackage.Literals.DSL__NAME, DslValidator.MISSING_KEY);
        }
      }
    }
  }
}
