/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.executionframework.debugger;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.commons.eclipse.emf.EObjectUtil;
import org.eclipse.gemoc.executionframework.debugger.IMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

@SuppressWarnings("all")
public class AnnotationMutableFieldExtractor implements IMutableFieldExtractor {
  private final DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
  
  @Override
  public List<MutableField> extractMutableField(final EObject eObject) {
    final List<MutableField> result = new ArrayList<MutableField>();
    final EAttribute idProp = eObject.eClass().getEIDAttribute();
    String _xifexpression = null;
    if (((idProp != null) && (eObject.eGet(idProp) != null))) {
      String _xblockexpression = null;
      {
        final Object id = eObject.eGet(idProp);
        final NumberFormat formatter = new DecimalFormat("00");
        String _xifexpression_1 = null;
        if ((id instanceof Integer)) {
          _xifexpression_1 = formatter.format(((Integer) id));
        } else {
          _xifexpression_1 = id.toString();
        }
        final String idString = _xifexpression_1;
        String _name = eObject.eClass().getName();
        String _plus = (_name + "_");
        _xblockexpression = (_plus + idString);
      }
      _xifexpression = _xblockexpression;
    } else {
      String _xblockexpression_1 = null;
      {
        final QualifiedName qname = this.nameprovider.getFullyQualifiedName(eObject);
        String _xifexpression_1 = null;
        if ((qname != null)) {
          _xifexpression_1 = qname.toString();
        } else {
          String _xblockexpression_2 = null;
          {
            final String uriBasedName = EObjectUtil.getResourceBasedName(eObject, false);
            String _xifexpression_2 = null;
            if ((uriBasedName != null)) {
              _xifexpression_2 = uriBasedName;
            } else {
              _xifexpression_2 = eObject.toString();
            }
            _xblockexpression_2 = _xifexpression_2;
          }
          _xifexpression_1 = _xblockexpression_2;
        }
        _xblockexpression_1 = _xifexpression_1;
      }
      _xifexpression = _xblockexpression_1;
    }
    final String objectName = _xifexpression;
    EList<EStructuralFeature> _eAllStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
    for (final EStructuralFeature prop : _eAllStructuralFeatures) {
      boolean _isDynamic = DynamicAnnotationHelper.isDynamic(prop);
      if (_isDynamic) {
        String _name = prop.getName();
        String _plus = (_name + " ([");
        String _name_1 = eObject.eClass().getName();
        String _plus_1 = (_plus + _name_1);
        String _plus_2 = (_plus_1 + "] ");
        String _plus_3 = (_plus_2 + objectName);
        String _plus_4 = (_plus_3 + ")");
        final Supplier<Object> _function = () -> {
          return eObject.eGet(prop);
        };
        final Consumer<Object> _function_1 = (Object o) -> {
          final TransactionalEditingDomain ed = TransactionUtil.getEditingDomain(eObject.eResource());
          String _name_2 = prop.getName();
          String _plus_5 = ((((("Setting value " + o) + " in ") + objectName) + ".") + _name_2);
          String _plus_6 = (_plus_5 + " from the debugger");
          RecordingCommand command = new RecordingCommand(ed, _plus_6) {
            @Override
            protected void doExecute() {
              eObject.eSet(prop, o);
            }
          };
          CommandExecution.execute(ed, command);
        };
        final MutableField mut = new MutableField(_plus_4, eObject, prop, _function, _function_1);
        result.add(mut);
      }
    }
    return result;
  }
}
