/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;

public abstract class StandaloneCommand {
    private static final Logger logger = Logger.getLogger(StandaloneCommand.class);
    protected static @NonNull Appendable DEFAULT_OUTPUT_STREAM = System.out;
    protected final @NonNull StandaloneApplication standaloneApplication;
    protected final @NonNull String name;
    protected final @NonNull String help;
    protected final @NonNull Map<String, CommandToken> tokens = new HashMap<String, CommandToken>();

    public static @NonNull Appendable setDefaultOutputStream(@NonNull Appendable defaultOutputStream) {
        Appendable savedDefaultOutputStream = defaultOutputStream;
        DEFAULT_OUTPUT_STREAM = defaultOutputStream;
        return savedDefaultOutputStream;
    }

    protected StandaloneCommand(@NonNull StandaloneApplication standaloneApplication, @NonNull String name, @NonNull String help) {
        this.standaloneApplication = standaloneApplication;
        this.name = name;
        this.help = help;
    }

    protected void addToken(@NonNull CommandToken commandToken) {
        this.tokens.put(commandToken.getName(), commandToken);
    }

    public boolean check(@NonNull Map<CommandToken, List<String>> token2strings) {
        for (CommandToken token : token2strings.keySet()) {
            List<String> strings = token2strings.get(token);
            if (token == null || token.check(strings)) continue;
            return false;
        }
        for (CommandToken token : this.tokens.values()) {
            if (!token.isRequired() || token2strings.containsKey(token)) continue;
            logger.error((Object)("Missing mandatory token '" + token.getName() + "'"));
            return false;
        }
        return true;
    }

    public abstract @NonNull StandaloneResponse execute(@NonNull Map<CommandToken, List<String>> var1);

    public @NonNull String getHelp() {
        return this.help;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Collection<CommandToken> getTokens() {
        return this.tokens.values();
    }

    public @Nullable Map<CommandToken, List<String>> parse(@NonNull String @NonNull [] arguments) {
        HashMap<CommandToken, List<String>> parsedTokens = new HashMap<CommandToken, List<String>>();
        int i = 1;
        while (i < arguments.length) {
            String argument;
            CommandToken token;
            ArrayList<String> strings;
            if ((strings = (ArrayList<String>)parsedTokens.get(token = this.tokens.get(argument = arguments[i++]))) == null) {
                strings = new ArrayList<String>();
                parsedTokens.put(token, strings);
            } else if (token.isSingleton()) {
                logger.error((Object)("Token '" + token.getName() + "' may only be used once"));
                return null;
            }
            if (token == null) {
                strings.add(argument);
                continue;
            }
            if ((i = token.parseArgument(strings, arguments, i)) >= 0) continue;
            return null;
        }
        return parsedTokens;
    }

    public String toString() {
        return this.name;
    }

    public static abstract class CommandToken {
        protected final @NonNull String name;
        protected final @NonNull String help;
        protected boolean isRequired = false;

        protected CommandToken(@NonNull String name, @NonNull String help) {
            this.name = name;
            this.help = help;
        }

        public boolean check(@NonNull List<String> strings) {
            return true;
        }

        public @Nullable String getArgsHelp() {
            return null;
        }

        public @NonNull String getHelp() {
            return this.help;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public int parseArgument(@NonNull List<String> strings, @NonNull String @NonNull [] arguments, int i) {
            return i;
        }

        public void setIsRequired() {
            this.isRequired = true;
        }

        public boolean isSingleton() {
            return true;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class StringToken
    extends CommandToken {
        protected StringToken(@NonNull String name, @NonNull String help) {
            super(name, help);
        }

        @Override
        public boolean check(@NonNull List<String> strings) {
            return strings.size() == 1;
        }

        @Override
        public @Nullable String getArgsHelp() {
            return "<string-value>";
        }

        @Override
        public int parseArgument(@NonNull List<String> strings, @NonNull String @NonNull [] arguments, int i) {
            if (i < arguments.length) {
                String argument = arguments[i++];
                strings.add(argument);
                return i;
            }
            logger.error((Object)("Missing argument for '" + this.name + "'"));
            return -1;
        }
    }
}

