/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ASSaverLocateVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverNormalizeVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverResolveVisitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class ASSaver {
    protected final @NonNull Resource resource;
    private Map<@NonNull String, @NonNull Operation> operations = new HashMap<String, Operation>();
    private @NonNull LinkedHashSet<@NonNull Element> unresolvedSpecializingElements = new LinkedHashSet();
    private @NonNull Set<@NonNull Element> resolvedSpecializingElements = new HashSet<Element>();
    private Package orphanage = null;
    private @NonNull Map<@NonNull Class, @NonNull Class> specializations = new HashMap<Class, Class>();
    private Class orphanageClass = null;
    private Map<@NonNull Resource, @NonNull ASSaverNormalizeVisitor> resource2normalizeVisitor = null;

    public ASSaver(@NonNull Resource resource) {
        this.resource = resource;
    }

    public void addSpecializingElement(@NonNull Element object) {
        if (!this.resolvedSpecializingElements.contains(object)) {
            this.unresolvedSpecializingElements.add(object);
        }
    }

    public boolean addSpecializingElement(@NonNull Element object, @NonNull Class referredType) {
        if (!PivotUtilInternal.isOrphanType(referredType)) {
            return false;
        }
        this.addSpecializingElement(object);
        return true;
    }

    public boolean addSpecializingElement(@NonNull Element object, @NonNull Operation referredOperation) {
        if (!this.isOrphanOperation(referredOperation)) {
            return false;
        }
        this.addSpecializingElement(object);
        return true;
    }

    public boolean addSpecializingElement(@NonNull Element object, @NonNull Property referredProperty) {
        if (!PivotUtilInternal.isOrphanProperty(referredProperty)) {
            return false;
        }
        this.addSpecializingElement(object);
        return true;
    }

    protected @NonNull ASSaverLocateVisitor getLocateVisitor(@NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof ASResource) {
            return ((ASResource)resource).getASResourceFactory().createASSaverLocateVisitor(this);
        }
        if (resource == null) {
            throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for resource-less " + eObject.eClass().getName());
        }
        throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for non-OCL " + resource.getClass().getName());
    }

    protected @NonNull ASSaverNormalizeVisitor getNormalizeVisitor(@NonNull EObject eObject) {
        ASSaverNormalizeVisitor visitor;
        Resource resource = eObject.eResource();
        if (resource == null) {
            throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for resource-less " + eObject.eClass().getName());
        }
        if (this.resource2normalizeVisitor == null) {
            this.resource2normalizeVisitor = new HashMap<Resource, ASSaverNormalizeVisitor>();
        }
        if ((visitor = this.resource2normalizeVisitor.get(resource)) != null) {
            return visitor;
        }
        if (resource instanceof ASResource) {
            ASResource asResource = (ASResource)resource;
            visitor = asResource.getASResourceFactory().createASSaverNormalizeVisitor(this);
            this.resource2normalizeVisitor.put(resource, visitor);
            return visitor;
        }
        throw new IllegalStateException("Cannot locate " + ASSaverLocateVisitor.class.getName() + " for non-OCL " + resource.getClass().getName());
    }

    protected @NonNull Class getOrphanClass(@NonNull Package orphanagePackage) {
        Class orphanageClass2 = this.orphanageClass;
        if (orphanageClass2 == null) {
            this.orphanageClass = orphanageClass2 = PivotFactory.eINSTANCE.createAnyType();
            orphanageClass2.setName("$$");
            orphanagePackage.getOwnedClasses().add(orphanageClass2);
        }
        return orphanageClass2;
    }

    protected @NonNull Package getOrphanPackage(@NonNull Resource resource) {
        Package orphanage2 = this.orphanage;
        if (orphanage2 == null) {
            this.orphanage = orphanage2 = PivotFactory.eINSTANCE.createPackage();
            orphanage2.setName("$$");
            orphanage2.setNsPrefix("orphanage");
            orphanage2.setURI("http://www.eclipse.org/ocl/2015/Orphanage");
            EList contents = resource.getContents();
            if (contents.size() > 0 && contents.get(0) instanceof Model) {
                ((Model)contents.get(0)).getOwnedPackages().add(orphanage2);
            } else {
                contents.add((Object)orphanage2);
            }
        }
        return orphanage2;
    }

    protected @NonNull ASSaverResolveVisitor getResolveVisitor(@NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof ASResource) {
            return ((ASResource)resource).getASResourceFactory().createASSaverResolveVisitor(this);
        }
        if (resource == null) {
            throw new IllegalStateException("Cannot locate " + ASSaverResolveVisitor.class.getName() + " for resource-less " + eObject.eClass().getName());
        }
        throw new IllegalStateException("Cannot locate " + ASSaverResolveVisitor.class.getName() + " for non-OCL " + resource.getClass().getName());
    }

    protected boolean isOrphanOperation(@NonNull Operation operation) {
        return operation.getOwnedBindings().size() > 0;
    }

    public void localizeSpecializations() {
        this.locateSpecializations((List<? extends EObject>)this.resource.getContents());
        if (this.unresolvedSpecializingElements.size() > 0) {
            this.loadOrphanage(this.resource);
            while (this.unresolvedSpecializingElements.size() > 0) {
                ArrayList<@NonNull Element> elements = new ArrayList<Element>(this.unresolvedSpecializingElements);
                for (Element element : elements) {
                    ASSaverResolveVisitor resolveVisitor = this.getResolveVisitor(element);
                    resolveVisitor.safeVisit(element);
                    this.resolvedSpecializingElements.add(element);
                    this.unresolvedSpecializingElements.remove(element);
                }
            }
            if (this.resource instanceof ASResourceImpl) {
                ((ASResourceImpl)this.resource).resetLUSSIDs();
            }
        }
    }

    protected void loadOrphanage(@NonNull Resource resource) {
        Model root = null;
        Package orphanage2 = this.orphanage;
        if (orphanage2 == null) {
            for (EObject eRoot : resource.getContents()) {
                if (eRoot instanceof Model) {
                    if (root == null) {
                        root = (Model)eRoot;
                    }
                    if (orphanage2 == null) {
                        for (Package asPackage : ((Model)eRoot).getOwnedPackages()) {
                            if (!Orphanage.isTypeOrphanage(asPackage)) continue;
                            this.orphanage = orphanage2 = asPackage;
                            for (Class asType : orphanage2.getOwnedClasses()) {
                                if ("$$".equals(asType.getName())) {
                                    this.orphanageClass = asType;
                                    continue;
                                }
                                this.specializations.put(asType, asType);
                            }
                        }
                    }
                }
                if (!(eRoot instanceof Package) || !Orphanage.isTypeOrphanage((Package)eRoot)) continue;
                this.orphanage = orphanage2 = (Package)eRoot;
                for (Class asType : orphanage2.getOwnedClasses()) {
                    if ("$$".equals(asType.getName())) {
                        this.orphanageClass = asType;
                        continue;
                    }
                    this.specializations.put(asType, asType);
                }
            }
        }
    }

    protected void locateSpecializations(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            if (eObject instanceof Visitable) {
                ASSaverLocateVisitor locateVisitor = this.getLocateVisitor(eObject);
                locateVisitor.safeVisit((Visitable)eObject);
            }
            if (eObject == null) continue;
            this.locateSpecializations((List<? extends EObject>)eObject.eContents());
        }
    }

    public void normalizeContents() {
        ArrayList<@NonNull EObject> allContents = new ArrayList<EObject>();
        @NonNull TreeIterator tit = this.resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Visitable)) continue;
            allContents.add(eObject);
        }
        HashMap<EClass, @NonNull ASSaverNormalizeVisitor> eClass2normalizeVisitor = new HashMap<EClass, ASSaverNormalizeVisitor>();
        for (EObject eObject : allContents) {
            EClass eClass = eObject.eClass();
            ASSaverNormalizeVisitor normalizeVisitor = (ASSaverNormalizeVisitor)eClass2normalizeVisitor.get(eClass);
            if (normalizeVisitor == null) {
                normalizeVisitor = this.getNormalizeVisitor(eObject);
                eClass2normalizeVisitor.put(eClass, normalizeVisitor);
            }
            normalizeVisitor.safeVisit((Visitable)eObject);
        }
    }

    public <T extends Operation> @NonNull T resolveOperation(@NonNull T referredOperation) {
        if (!this.isOrphanOperation(referredOperation)) {
            return referredOperation;
        }
        String moniker = AS2Moniker.toString(referredOperation);
        Operation operation = this.operations.get(moniker);
        if (operation != null) {
            Operation castOperation = operation;
            return (T)castOperation;
        }
        Operation resolvedOperation = ClassUtil.nonNullEMF((Operation)EcoreUtil.copy(referredOperation));
        if (this.orphanageClass == null) {
            Package orphanage2 = this.orphanage;
            if (orphanage2 == null) {
                orphanage2 = this.getOrphanPackage(this.resource);
            }
            this.orphanageClass = this.getOrphanClass(orphanage2);
        }
        this.orphanageClass.getOwnedOperations().add(resolvedOperation);
        this.operations.put(moniker, resolvedOperation);
        String newMoniker = AS2Moniker.toString(resolvedOperation);
        assert (moniker.equals(newMoniker));
        this.locateSpecializations(Collections.singletonList(resolvedOperation));
        return (T)resolvedOperation;
    }

    public @NonNull Property resolveProperty(@NonNull Property referredProperty) {
        if (!PivotUtilInternal.isOrphanProperty(referredProperty)) {
            return referredProperty;
        }
        Class referredClass = PivotUtil.getOwningClass(referredProperty);
        Class resolvedClass = this.resolveType(referredClass);
        Property resolvedProperty = NameUtil.getNameable(resolvedClass.getOwnedProperties(), PivotUtil.getName(referredProperty));
        return ClassUtil.nonNullState(resolvedProperty);
    }

    public <T extends Class> @NonNull T resolveType(@NonNull T referredType) {
        if (!PivotUtilInternal.isOrphanType(referredType)) {
            return referredType;
        }
        Class resolvedType = this.specializations.get(referredType);
        if (resolvedType == null) {
            resolvedType = ClassUtil.nonNullEMF((Class)EcoreUtil.copy(referredType));
            this.specializations.put(referredType, resolvedType);
            this.specializations.put(resolvedType, resolvedType);
            EObject eContainer = resolvedType.eContainer();
            if (eContainer == null) {
                Package orphanage2 = this.orphanage;
                if (orphanage2 == null) {
                    orphanage2 = this.getOrphanPackage(this.resource);
                }
                this.orphanage.getOwnedClasses().add(resolvedType);
            }
        }
        this.locateSpecializations(Collections.singletonList(resolvedType));
        Class castType = resolvedType;
        return (T)castType;
    }
}

