/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout;

import com.google.common.collect.Iterables;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.flag.SequenceDiagramAbsoluteBoundsFlagger;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.horizontal.SequenceHorizontalLayout;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.observation.SequenceObservationLayout;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.vertical.SequenceVerticalLayout;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.ext.base.Option;

public class SequenceLayout {
    private final Option<SequenceDiagram> sequenceDiagram;
    private SequenceHorizontalLayout sequenceHorizontalLayout;
    private SequenceVerticalLayout sequenceVerticalLayout;
    private SequenceObservationLayout sequenceObservationLayout;

    public SequenceLayout(Diagram diagram) {
        this.sequenceDiagram = ISequenceElementAccessor.getSequenceDiagram(diagram);
        this.sequenceHorizontalLayout = new SequenceHorizontalLayout((SequenceDiagram)this.sequenceDiagram.get());
        this.sequenceVerticalLayout = new SequenceVerticalLayout((SequenceDiagram)this.sequenceDiagram.get());
        this.sequenceObservationLayout = new SequenceObservationLayout((SequenceDiagram)this.sequenceDiagram.get());
    }

    public Option<SequenceDiagram> getSequenceDiagram() {
        return this.sequenceDiagram;
    }

    public boolean horizontalLayout(boolean pack) {
        if (this.sequenceHorizontalLayout != null && this.sequenceDiagram.some()) {
            return this.sequenceHorizontalLayout.layout(pack);
        }
        return false;
    }

    public boolean verticalLayout(boolean pack) {
        if (this.sequenceVerticalLayout != null && this.sequenceDiagram.some()) {
            return this.sequenceVerticalLayout.layout(pack);
        }
        return false;
    }

    public boolean observationLayout(boolean pack) {
        if (this.sequenceObservationLayout != null && this.sequenceDiagram.some()) {
            return this.sequenceObservationLayout.layout(pack);
        }
        return false;
    }

    public void flagSequenceEvents() {
        if (this.sequenceDiagram.some()) {
            SequenceDiagramAbsoluteBoundsFlagger flagHelper = new SequenceDiagramAbsoluteBoundsFlagger((SequenceDiagram)this.sequenceDiagram.get());
            flagHelper.flag();
            this.updateCollapseFilters();
        }
    }

    private void updateCollapseFilters() {
        for (ISequenceNode isn : Iterables.concat(((SequenceDiagram)this.sequenceDiagram.get()).getAllAbstractNodeEvents(), ((SequenceDiagram)this.sequenceDiagram.get()).getAllObservationPoints(), ((SequenceDiagram)this.sequenceDiagram.get()).getAllLifelines())) {
            Node node = isn.getNotationNode();
            if (!new NodeQuery(node).isCollapsed() || !(node.getElement() instanceof DDiagramElement) || !(node.getLayoutConstraint() instanceof Size)) continue;
            Size size = (Size)node.getLayoutConstraint();
            DDiagramElement dde = (DDiagramElement)node.getElement();
            for (CollapseFilter collapseFilter : Iterables.filter((Iterable)dde.getGraphicalFilters(), CollapseFilter.class)) {
                collapseFilter.setHeight(size.getHeight());
            }
        }
    }
}

