/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions;

import fr.inria.aoste.timesquare.backend.codeexecution.CodeExecutionHelper;
import fr.inria.aoste.timesquare.backend.codeexecution.CodeExecutionJdtClassLoader;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;

public class Variable
implements Serializable {
    private static final long serialVersionUID = 3965023336242443147L;
    public String name;
    public String typename;
    private transient IType type;
    private transient Object o;
    private transient CodeExecutionHelper codeExecutionHelper;
    private transient List<IMethod> lst;

    public CodeExecutionHelper getCodeExecutionHelper() {
        return this.codeExecutionHelper;
    }

    public void setCodeExecutionHelper(CodeExecutionHelper codeExecutionHelper) {
        this.codeExecutionHelper = codeExecutionHelper;
    }

    public Variable() {
        this.init();
    }

    public String getTypeName() {
        if (this.type != null) {
            return this.type.getFullyQualifiedName();
        }
        return this.typename;
    }

    public Variable(String name, IType type) {
        this.name = name;
        this.type = type;
        this.typename = this.getStringFromJavaElement((IJavaElement)type);
    }

    public Variable(String name, String typeName) {
        this.name = name;
        this.typename = typeName;
        this.type = null;
        this.init();
    }

    public void init() {
        if (this.type == null) {
            this.type = (IType)this.getJavaElementFromString(this.typename);
        }
    }

    protected String getStringFromJavaElement(IJavaElement javaElement) {
        if (javaElement != null) {
            String ret = javaElement.getHandleIdentifier();
            return ret;
        }
        return null;
    }

    protected IJavaElement getJavaElementFromString(String s) {
        try {
            return JavaCore.create((String)s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Object getObject() {
        if (this.o == null) {
            try {
                this.init();
                if (this.type != null) {
                    String _className = this.type.getFullyQualifiedParameterizedName();
                    URLClassLoader newLoader = this.codeExecutionHelper.getPcl().getProjectClassLoader((IJavaElement)this.type);
                    Class<?> clazz = newLoader.loadClass(_className);
                    this.o = clazz.newInstance();
                } else {
                    String _className = this.typename;
                    CodeExecutionJdtClassLoader newLoader = new CodeExecutionJdtClassLoader(this.getClass().getClassLoader());
                    Class<?> clazz = newLoader.loadClass(_className);
                    this.o = clazz.newInstance();
                }
            }
            catch (Throwable e) {
                System.err.println("error " + e);
                e.printStackTrace();
            }
        }
        return this.o;
    }

    public List<IMethod> getIMethods() {
        if (this.type == null) {
            return null;
        }
        if (this.lst == null) {
            this.lst = new ArrayList<IMethod>();
            IType t = this.type;
            try {
                IMethod[] iMethodArray = t.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod m = iMethodArray[n2];
                    this.lst.add(m);
                    ++n2;
                }
                ITypeHierarchy th = t.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                th.refresh((IProgressMonitor)new NullProgressMonitor());
                IType[] iTypeArray = th.getAllSuperclasses(t);
                int n3 = iTypeArray.length;
                n = 0;
                while (n < n3) {
                    IType t2 = iTypeArray[n];
                    IMethod[] iMethodArray2 = t2.getMethods();
                    int n4 = iMethodArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        int flags;
                        IMethod m = iMethodArray2[n5];
                        if (!m.isConstructor() && Flags.isPublic((int)(flags = m.getFlags())) && !Flags.isStatic((int)flags)) {
                            this.lst.add(m);
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.lst;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Variable) {
            ((Variable)obj).init();
            this.init();
            if (this.type != null && ((Variable)obj).type != null) {
                if (((Variable)obj).type.equals(this.type) && ((Variable)obj).name.equals(this.name)) {
                    return true;
                }
            } else {
                return ((Variable)obj).typename.compareTo(this.typename) == 0 && ((Variable)obj).name.equals(this.name);
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.name != null ? this.name.hashCode() : 0) + (this.type != null ? this.type.hashCode() : 0);
    }
}

