/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.datastructure.clock;

import fr.inria.aoste.timesquare.backend.manager.datastructure.ABehaviorList;
import fr.inria.aoste.timesquare.backend.manager.datastructure.Entity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehaviorAgain;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.trace.EventOccurrence;
import java.util.ArrayList;
import java.util.List;

public class ClockBehaviorList
extends ABehaviorList<ClockBehaviorEntity> {
    public ClockBehaviorList() {
        super(new ArrayList());
    }

    public void executeNewBehaviors(ClockEntity clockEntity, EventOccurrence clockState) {
        if (clockEntity == null || clockState == null) {
            return;
        }
        for (ClockBehaviorEntity e : this.getData()) {
            if (!e.getClockEntity().equals(clockEntity)) continue;
            if (e.getClockActivationState().stateActivationOK(clockState)) {
                e.getBehavior().run(new TraceHelper(clockState, clockEntity));
                continue;
            }
            e.getBehavior().runWithWrongActivationState(new TraceHelper(clockState, clockEntity));
        }
    }

    public void executeBehaviors(ClockEntity clockEntity, EventOccurrence clockState) {
        if (clockEntity == null || clockState == null) {
            return;
        }
        for (ClockBehaviorEntity e : this.getData()) {
            ClockBehavior cb = e.getBehavior();
            if (!(cb instanceof ClockBehaviorAgain)) continue;
            ClockBehaviorAgain cba = (ClockBehaviorAgain)cb;
            if (!e.getClockEntity().equals(clockEntity)) continue;
            if (e.getClockActivationState().stateActivationOK(clockState)) {
                cba.againRun(new TraceHelper(clockState, clockEntity));
                continue;
            }
            cba.againRunWithWrongActivationState(new TraceHelper(clockState, clockEntity));
        }
    }

    public void checkConsistency(List<ClockEntity> clocks) {
        if (clocks == null) {
            this.clear();
            return;
        }
        ArrayList<ClockBehaviorEntity> toDelete = new ArrayList<ClockBehaviorEntity>();
        for (Entity e : this.getData()) {
            if (clocks.contains(e.getClockEntity())) continue;
            toDelete.add((ClockBehaviorEntity)e);
        }
        for (Entity e : toDelete) {
            this.getData().remove(e);
        }
    }
}

