/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.utils;

import fr.inria.aoste.timesquare.trace.util.adapter.IModelAdapter;

public enum EventEnumeratorPair {
    StartFinish(IModelAdapter.EventEnumerator.START, IModelAdapter.EventEnumerator.FINISH),
    SendRecieve(IModelAdapter.EventEnumerator.SEND, IModelAdapter.EventEnumerator.RECEIVE),
    ProduceConsume(IModelAdapter.EventEnumerator.PRODUCE, IModelAdapter.EventEnumerator.CONSUME);

    private final IModelAdapter.EventEnumerator src;
    private final IModelAdapter.EventEnumerator dst;

    private EventEnumeratorPair(IModelAdapter.EventEnumerator src, IModelAdapter.EventEnumerator dst) {
        this.src = src;
        this.dst = dst;
    }

    public IModelAdapter.EventEnumerator getSource() {
        return this.src;
    }

    public IModelAdapter.EventEnumerator getDestination() {
        return this.dst;
    }

    public static EventEnumeratorPair getPair(IModelAdapter.EventEnumerator ee) {
        if (ee != null) {
            switch (ee) {
                case START: 
                case FINISH: {
                    return StartFinish;
                }
                case CONSUME: 
                case PRODUCE: {
                    return ProduceConsume;
                }
                case SEND: 
                case RECEIVE: {
                    return SendRecieve;
                }
                case UNDEFINED: {
                    return null;
                }
            }
        }
        return null;
    }
}

