/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.visible;

import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.trace.AssertionState;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.NamedReference;
import fr.inria.aoste.trace.Reference;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;

public class TraceHelper {
    private EventOccurrence _clockState;
    private ClockEntity _clockEntity;
    private AssertionState _assertState;

    public TraceHelper(EventOccurrence clockState, ClockEntity clockEntity) {
        this._clockEntity = clockEntity;
        this._clockState = clockState;
    }

    public TraceHelper(AssertionState assertState) {
        this._assertState = assertState;
    }

    public EventOccurrence getClockState() {
        return this._clockState;
    }

    public ClockEntity getClockEntity() {
        return this._clockEntity;
    }

    public int getCurrentStepNumber() {
        if (this._clockState != null) {
            LogicalStep step = (LogicalStep)this._clockState.eContainer();
            return step.getStepNumber();
        }
        if (this._assertState != null) {
            LogicalStep step = (LogicalStep)this._assertState.eContainer();
            return step.getStepNumber();
        }
        return -1;
    }

    public String getHRef() {
        if (this._clockState != null) {
            return TraceHelper.getRef(this._clockState.getReferedElement());
        }
        if (this._assertState != null) {
            return TraceHelper.getRef(this._assertState.getReferedElement());
        }
        return "";
    }

    private static final String getRef(Reference rf) {
        block6: {
            if (!(rf instanceof NamedReference)) break block6;
            return null;
        }
        try {
            if (rf instanceof ModelElementReference) {
                Reference eo = rf;
                Resource rs = rf.eResource();
                if (rs instanceof XMLResource) {
                    XMLHelperImpl xmlhelper = new XMLHelperImpl((XMLResource)rs);
                    HashMap<String, URIHandlerImpl> map = new HashMap<String, URIHandlerImpl>();
                    URIHandlerImpl urih = new URIHandlerImpl();
                    urih.setBaseURI(rs.getURI());
                    map.put("URI_HANDLER", urih);
                    xmlhelper.setOptions(map);
                    String s = xmlhelper.getHREF((EObject)eo);
                    if (s.charAt(0) == '#') {
                        return String.valueOf(rs.getURI().lastSegment()) + s;
                    }
                    return s;
                }
            }
        }
        catch (Throwable e) {
            System.err.println(e.getStackTrace()[1] + " : " + e.getMessage());
        }
        return null;
    }
}

