/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core.console;

import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLProcess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleTerminateAction
extends Action
implements IUpdate,
ILaunchesListener2 {
    private ConsoleSimulation fConsole;

    public ConsoleTerminateAction(IWorkbenchWindow window, ConsoleSimulation console) {
        super("&Terminate");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.console_terminate_action_context");
        this.fConsole = console;
        this.setToolTipText("Terminate");
        this.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_LCL_TERMINATE"));
        this.setDisabledImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_DLCL_TERMINATE"));
        this.setHoverImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_LCL_TERMINATE"));
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        this.update();
    }

    public void update() {
        CCSLProcess process = this.fConsole.getiProcess();
        ILaunch launch = process.getLaunch();
        if (launch != null) {
            this.setEnabled(!launch.isTerminated() && launch.canTerminate());
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        CCSLProcess process = this.fConsole.getiProcess();
        List<IAdaptable> targets = this.collectTargets(process);
        targets.add((IAdaptable)process);
        this.executeCommand(targets.toArray());
        this.setEnabled(false);
    }

    private List<IAdaptable> collectTargets(CCSLProcess process) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        ArrayList<IAdaptable> targets = new ArrayList<IAdaptable>();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            IProcess[] processes = launch.getProcesses();
            int j = 0;
            while (j < processes.length) {
                IProcess process2 = processes[j];
                if (process2.equals((Object)process)) {
                    IDebugTarget[] debugTargets = launch.getDebugTargets();
                    int k = 0;
                    while (k < debugTargets.length) {
                        targets.add((IAdaptable)debugTargets[k]);
                        ++k;
                    }
                    return targets;
                }
                ++j;
            }
            ++i;
        }
        return targets;
    }

    public void dispose() {
        this.fConsole = null;
    }

    public boolean executeCommand(Object[] elements) {
        if (elements.length == 1) {
            Object element = elements[0];
            IDebugCommandHandler handler = this.getHandler(element);
            if (handler != null) {
                DebugCommandRequest request = new DebugCommandRequest(elements);
                return handler.execute((IDebugCommandRequest)request);
            }
        } else {
            Map<IDebugCommandHandler, List<Object>> map = this.collate(elements);
            if (map != null) {
                boolean enabled = true;
                for (Map.Entry<IDebugCommandHandler, List<Object>> entry : map.entrySet()) {
                    IDebugCommandHandler handler = entry.getKey();
                    List<Object> list = entry.getValue();
                    DebugCommandRequest request = new DebugCommandRequest(list.toArray());
                    enabled &= handler.execute((IDebugCommandRequest)request);
                }
                return enabled;
            }
        }
        return false;
    }

    private Map<IDebugCommandHandler, List<Object>> collate(Object[] elements) {
        HashMap<IDebugCommandHandler, List<Object>> map = new HashMap<IDebugCommandHandler, List<Object>>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            IDebugCommandHandler handler = this.getHandler(element);
            if (handler == null) {
                return null;
            }
            ArrayList<Object> list = (ArrayList<Object>)map.get(handler);
            if (list == null) {
                list = new ArrayList<Object>();
                map.put(handler, list);
            }
            list.add(element);
            ++i;
        }
        return map;
    }

    private IDebugCommandHandler getHandler(Object element) {
        return (IDebugCommandHandler)DebugPlugin.getAdapter((Object)element, ITerminateHandler.class);
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.update();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.update();
    }

    public void launchesChanged(ILaunch[] launches) {
        this.update();
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.update();
    }

    private static class DebugCommandRequest
    implements IDebugCommandRequest {
        private Object[] fElements;
        private IStatus fStatus;
        private boolean fCanceled = false;

        public DebugCommandRequest(Object[] elements) {
            this.fElements = elements;
        }

        public Object[] getElements() {
            return this.fElements;
        }

        public void done() {
        }

        public IStatus getStatus() {
            return this.fStatus;
        }

        public void setStatus(IStatus status) {
            this.fStatus = status;
        }

        public synchronized void cancel() {
            this.fCanceled = true;
        }

        public synchronized boolean isCanceled() {
            return this.fCanceled;
        }
    }
}

