/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.ui;

import fr.inria.aoste.timesquare.launcher.core.OutputManager;
import fr.inria.aoste.timesquare.launcher.core.PESolverManager;
import fr.inria.aoste.timesquare.launcher.core.inter.ICCSLProxy;
import fr.inria.aoste.timesquare.launcher.debug.model.output.ICCSLModelTab;
import fr.inria.aoste.timesquare.launcher.debug.model.output.OutputSetupOption;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.CCSLSimulationConfigurationHelper;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputOption;
import fr.inria.aoste.timesquare.launcher.ui.Activator;
import fr.inria.aoste.timesquare.launcher.ui.MetaGroup;
import fr.inria.aoste.timesquare.launcher.ui.MyAbstractLaunchConfigurationTab;
import fr.inria.aoste.timesquare.launcher.ui.TextBrowse;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyManager;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.utils.ui.listeners.IntListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class CCSLModelSimulationTab
extends MyAbstractLaunchConfigurationTab {
    private TextBrowse fNameText;
    private TextBrowse prioritySpecificationBrowser;
    private ArrayList<OutputSetupOption> listoption = new ArrayList();
    private MetaGroup metoption;
    private String[] policies = SimulationPolicyManager.getDefault().getPolicyNamesAsArray();
    private Combo policyCombo;
    private Button eState;
    private Button eTime;
    private Button ecpsrc;
    private Text stepsText;
    private Composite simulationParameters;
    private Composite tampon;
    private IFile valuefile;
    private IFile prioritySpecificationIFile = null;
    private Composite parent;
    List<Group> lsgroup = new ArrayList<Group>();
    private static final int CONTROL_OFFSET = 5;
    boolean flaginit = false;
    Object registercontext = null;

    public void createControl(Composite _parent) {
        this.parent = _parent;
        this.simulationParameters = new Composite(this.parent, 16);
        this.setControl((Control)this.simulationParameters);
        FormData data3 = new FormData();
        data3.top = new FormAttachment(0, 2);
        data3.left = new FormAttachment(0, 2);
        data3.right = new FormAttachment(100, -2);
        data3.bottom = new FormAttachment(100, -2);
        this.simulationParameters.setLayoutData((Object)new GridData(4, 4, true, true));
        FormLayout layout = new FormLayout();
        this.simulationParameters.setLayout((Layout)layout);
        this.callSource();
        this.callSimulation();
        this.callOuptut();
        this.tampon = new Composite(this.simulationParameters, 16);
        this.generateLayout();
        this.simulationParameters.addControlListener((ControlListener)new SimulationParametersControlListener(this.simulationParameters));
        Dialog.applyDialogFont((Control)this.parent);
    }

    private int callSource() {
        this.fNameText = new TextBrowse(this, this.simulationParameters, "Source:", PESolverManager.getDefault().getListExtension());
        String[] prioExtensions = new String[]{"ccslPriority", "ccslprioritymodel", "prioritymodel"};
        this.prioritySpecificationBrowser = new TextBrowse(this, this.simulationParameters, "Priority Source:", prioExtensions);
        return 0;
    }

    private int callSimulation() {
        this.metoption = new MetaGroup(this, this.simulationParameters, "Simulation", 16);
        Group option = this.metoption.g;
        this.stepsText = this.createLabelInput((Composite)option, "Simulation steps: ", 150);
        this.stepsText.addListener(25, (Listener)new IntListener());
        this.policyCombo = this.createCombo((Composite)option, "Simulation policy:", this.policies, 150);
        this.policyCombo.addSelectionListener((SelectionListener)new SelectionPolicyListener());
        this.policyCombo.setToolTipText("Select Simulation Policy");
        this.eState = this.createCheckButton((Composite)option, "Compute ghost");
        this.eState.setLayoutData((Object)new GridData(4, 4, true, true));
        this.eState.addSelectionListener((SelectionListener)this);
        this.eTime = this.createCheckButton((Composite)option, "Show Time");
        this.eTime.setLayoutData((Object)new GridData(4, 4, true, true));
        this.eTime.addSelectionListener((SelectionListener)this);
        this.ecpsrc = this.createCheckButton((Composite)option, "Copy Source");
        this.ecpsrc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.ecpsrc.addSelectionListener((SelectionListener)this);
        option.pack();
        return 0;
    }

    private int callOuptut() {
        OutputManager outputManager = OutputManager.getDefault();
        for (String key : outputManager.getListkey()) {
            OutputSetupOption oso = outputManager.getUIforKey(key);
            if (oso == null) continue;
            Group group = oso.initMeta((ICCSLModelTab)this, this.simulationParameters);
            this.lsgroup.add(group);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            this.listoption.add(oso);
        }
        return 0;
    }

    private int generateLayout() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.fNameText.getGroup().setLayoutData((Object)data);
        FormData prioFormData = new FormData();
        prioFormData.top = new FormAttachment((Control)this.fNameText.getGroup(), 5);
        prioFormData.left = new FormAttachment(0, 5);
        prioFormData.right = new FormAttachment(100, -5);
        this.prioritySpecificationBrowser.getGroup().setLayoutData((Object)prioFormData);
        FormData data2 = new FormData();
        data2.top = new FormAttachment((Control)this.prioritySpecificationBrowser.getGroup(), 5);
        data2.left = new FormAttachment(0, 5);
        data2.right = new FormAttachment(100, -5);
        this.metoption.g.setLayoutData((Object)data2);
        int size = this.lsgroup.size();
        Group oldlgroup = this.metoption.g;
        int i = 0;
        while (i < size) {
            FormData data3 = new FormData();
            data3.top = new FormAttachment((Control)oldlgroup, 5);
            data3.left = new FormAttachment(0, 5);
            data3.right = new FormAttachment(100, -5);
            Group g = this.lsgroup.get(i);
            g.setLayoutData((Object)data3);
            oldlgroup = g;
            ++i;
        }
        FormData data3 = new FormData();
        data3.top = new FormAttachment((Control)oldlgroup, 5);
        data3.height = 100;
        data3.left = new FormAttachment(0, 5);
        data3.right = new FormAttachment(100, -5);
        data3.bottom = new FormAttachment(100, -5);
        this.tampon.setLayoutData((Object)data3);
        this.simulationParameters.layout();
        return 0;
    }

    public void dispose() {
        for (OutputSetupOption oso : this.listoption) {
            oso.dispose();
        }
        super.dispose();
        PESolverManager.getDefault().clearCache(0);
    }

    public String getErrorMessage() {
        return super.getErrorMessage();
    }

    public Image getImage() {
        return PluginHelpers.getImage((String)"fr.inria.aoste.timesquare.launcher.ui", (String)"icons/tsq.gif");
    }

    public String getName() {
        return "CCSLModel Main";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.flaginit = true;
            CCSLSimulationConfigurationHelper ccslproxy = CCSLSimulationConfigurationHelper.create((ILaunchConfiguration)config);
            this.valuefile = ccslproxy.get_SourceIFile();
            this.fNameText.setSourceFile(this.valuefile);
            this.prioritySpecificationIFile = ccslproxy.get_PrioritySourceIFile();
            this.prioritySpecificationBrowser.setSourceFile(this.prioritySpecificationIFile);
            int n = ccslproxy.getStepNbr();
            if (n == 0) {
                n = PESolverManager.getDefault().getDefaultStep((ICCSLProxy)ccslproxy);
            }
            this.stepsText.setText(Integer.toString(n));
            this.policyCombo.select(ccslproxy.getPolicyId());
            this.eState.setSelection(ccslproxy.getEstate());
            this.eState.setEnabled(ccslproxy.solverUsedEstate());
            this.eTime.setSelection(ccslproxy.getTime());
            this.eTime.setEnabled(true);
            this.ecpsrc.setSelection(ccslproxy.getCopy());
            this.ecpsrc.setEnabled(true);
            try {
                for (OutputSetupOption oso : this.listoption) {
                    IOutputOption ioo = ccslproxy.getTable(oso.getKey());
                    oso.initializeFrom(ioo);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        finally {
            this.flaginit = false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isValid(ILaunchConfiguration launchConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void notifyChange() {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        CCSLSimulationConfigurationHelper ccslProxyWrite = CCSLSimulationConfigurationHelper.create((ILaunchConfiguration)configuration);
        IFile newvaluefile = this.fNameText.getSourceFile();
        ccslProxyWrite.setSource(newvaluefile);
        IFile newPrioSpecFile = this.prioritySpecificationBrowser.getSourceFile();
        ccslProxyWrite.setPrioritySource(newPrioSpecFile);
        ccslProxyWrite.setPolicyId(this.policyCombo.getSelectionIndex());
        ccslProxyWrite.setEstate(this.eState.getSelection());
        ccslProxyWrite.setTime(this.eTime.getSelection());
        ccslProxyWrite.setCopy(this.ecpsrc.getSelection());
        String s = this.stepsText.getText();
        if (s == null) {
            s = "0";
        } else if (s.length() == 0) {
            s = "0";
        }
        try {
            int n = Integer.parseInt(s);
            ccslProxyWrite.setStepNbr(n);
        }
        catch (Throwable n) {
            // empty catch block
        }
        try {
            PESolverManager.getDefault();
            for (OutputSetupOption oso : this.listoption) {
                if (this.registercontext instanceof OutputSetupOption && this.registercontext != oso) continue;
                IOutputOption ioo = ccslProxyWrite.getTable(oso.getKey());
                oso.performApply(ioo);
                ccslProxyWrite.writeTable(ioo);
            }
            this.valuefile = newvaluefile;
            this.prioritySpecificationIFile = newPrioSpecFile;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Object s;
        CCSLSimulationConfigurationHelper ccslProxyWrite = CCSLSimulationConfigurationHelper.create((ILaunchConfiguration)configuration);
        ccslProxyWrite.setDefault();
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        ISelection sel = workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
        for (OutputSetupOption oso : this.listoption) {
            IOutputOption ioo = ccslProxyWrite.getTable(oso.getKey());
            if (ioo == null) continue;
            ioo.setDefault();
            oso.setDefaults(ioo);
            ccslProxyWrite.writeTable(ioo);
        }
        if (sel instanceof IStructuredSelection && (s = ((IStructuredSelection)sel).getFirstElement()) instanceof IFile) {
            IFile file = (IFile)s;
            ccslProxyWrite.setSource(file);
        }
    }

    @Override
    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public void updateLaunchConfigurationDialog(Object context) {
        try {
            this.registercontext = context;
            this.updateLaunchConfigurationDialog();
        }
        finally {
            this.registercontext = null;
        }
    }

    @Override
    protected void updateLaunchConfigurationDialog() {
        if (!this.flaginit) {
            this.flaginit = true;
            super.updateLaunchConfigurationDialog();
            this.flaginit = false;
        }
        if (this.simulationParameters != null) {
            this.simulationParameters.layout(true, true);
            this.simulationParameters.setVisible(true);
            this.simulationParameters.update();
            this.simulationParameters.pack(true);
            this.parent.layout(true, true);
            this.parent.update();
            this.parent.getParent().update();
            this.parent.getParent().layout();
        }
    }

    public final class SelectionPolicyListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CCSLModelSimulationTab.this.policyCombo.setToolTipText("Select Simulation Policy :" + SimulationPolicyManager.getDefault().getComment(CCSLModelSimulationTab.this.policyCombo.getSelectionIndex()));
        }
    }

    public static final class SimulationParametersControlListener
    implements ControlListener {
        Composite composite = null;

        public SimulationParametersControlListener(Composite simulationParameters) {
            this.composite = simulationParameters;
        }

        public void controlMoved(ControlEvent e) {
            Point pt = this.composite.getSize();
            Control[] controlArray = this.composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                Point tmp = c.getSize();
                if (tmp.x > pt.x) {
                    pt.x = tmp.x;
                }
                ++n2;
            }
        }

        public void controlResized(ControlEvent e) {
            try {
                Point pt = this.composite.getSize();
                pt.y = 0;
                Control[] controlArray = this.composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    Point tmp = c.getSize();
                    pt.y += tmp.y;
                    if (tmp.x > pt.x) {
                        pt.x = tmp.x;
                    }
                    ++n2;
                }
                if (pt.x < 400) {
                    pt.x = 400;
                }
                if (this.composite.getParent() instanceof ScrolledComposite) {
                    ((ScrolledComposite)this.composite.getParent()).setMinHeight(pt.y);
                }
                this.composite.layout();
            }
            catch (Throwable t) {
                System.err.println(t.getMessage());
            }
        }
    }
}

