/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.lightccsl.core.stepper;

import fr.kairos.lightccsl.core.stepper.Clock;
import fr.kairos.lightccsl.core.stepper.IClock;
import fr.kairos.lightccsl.core.stepper.IClockBuilder;
import fr.kairos.lightccsl.core.stepper.INameToIntegerMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class ClockCollector
implements Iterable<IClock>,
INameToIntegerMapper {
    private HashMap<String, Integer> namesToId = new HashMap();
    private ArrayList<IClock> clocks = new ArrayList();
    private ArrayList<String> names = new ArrayList();
    private IClockBuilder clockBuilder;

    public ClockCollector(IClockBuilder clockBuilder) {
        this.clockBuilder = clockBuilder;
    }

    private int addClock(String name) {
        Integer i = this.namesToId.get(name);
        if (i == null) {
            i = this.names.size();
            this.namesToId.put(name, i);
            if (this.clockBuilder != null) {
                this.clocks.add(this.clockBuilder.buildClock(name));
            } else {
                this.clocks.add(new Clock());
            }
            this.names.add(name);
        }
        return i;
    }

    @Override
    public Iterator<IClock> iterator() {
        return this.clocks.iterator();
    }

    @Override
    public int getIdFromName(String name) {
        return this.addClock(name);
    }

    IClock nameToClock(String name) {
        return this.idToClock(this.addClock(name));
    }

    IClock idToClock(int id) {
        return this.clocks.get(id);
    }

    @Override
    public String getNameFromId(int id) {
        return this.names.get(id);
    }

    @Override
    public int size() {
        return this.names.size();
    }

    @Override
    public Iterable<String> getClockNames() {
        return this.names;
    }
}

