/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.simple;

import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import java.util.LinkedHashSet;

public class CollectClocks
implements ISimpleSpecification {
    private LinkedHashSet<String> clocks = new LinkedHashSet();
    private boolean onlyDeclared = true;

    public CollectClocks(boolean onlyDeclaredClocks) {
        this.onlyDeclared = onlyDeclaredClocks;
    }

    @Override
    public void addClock(String name) {
        this.clocks.add(name);
    }

    public Iterable<String> clocks() {
        return this.clocks;
    }

    @Override
    public void subclock(String left, String right) {
        if (!this.onlyDeclared) {
            this.addClock(left);
            this.addClock(right);
        }
    }

    @Override
    public void exclusion(String left, String right) {
        if (!this.onlyDeclared) {
            this.addClock(left);
            this.addClock(right);
        }
    }

    @Override
    public void precedence(String left, String right) {
        if (!this.onlyDeclared) {
            this.addClock(left);
            this.addClock(right);
        }
    }

    @Override
    public void precedence(String left, String right, int min, int max) {
        if (!this.onlyDeclared) {
            this.addClock(left);
            this.addClock(right);
        }
    }

    @Override
    public void causality(String left, String right) {
        if (!this.onlyDeclared) {
            this.addClock(left);
            this.addClock(right);
        }
    }

    @Override
    public void causality(String left, String right, int min, int max) {
        if (!this.onlyDeclared) {
            this.addClock(left);
            this.addClock(right);
        }
    }

    private void expression(String defClock, String ... clocks) {
        if (!this.onlyDeclared) {
            this.addClock(defClock);
            String[] stringArray = clocks;
            int n = clocks.length;
            int n2 = 0;
            while (n2 < n) {
                String clock = stringArray[n2];
                this.addClock(clock);
                ++n2;
            }
        }
    }

    @Override
    public void inf(String defClock, String ... clocks) {
        this.expression(defClock, clocks);
    }

    @Override
    public void sup(String defClock, String ... clocks) {
        this.expression(defClock, clocks);
    }

    @Override
    public void union(String defClock, String ... clocks) {
        this.expression(defClock, clocks);
    }

    @Override
    public void intersection(String defClock, String ... clocks) {
        this.expression(defClock, clocks);
    }

    @Override
    public void minus(String defClock, String ... clocks) {
        this.expression(defClock, clocks);
    }

    @Override
    public void periodic(String defClock, String ref, int period, int from, int upto) {
        if (!this.onlyDeclared) {
            this.addClock(defClock);
            this.addClock(ref);
        }
    }

    @Override
    public void delayFor(String defClock, String ref, int from, int upto, String base) {
        if (!this.onlyDeclared) {
            this.addClock(defClock);
            this.addClock(ref);
        }
    }
}

