/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.simple;

import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import java.io.PrintWriter;
import java.io.Writer;

public class PrettyPrint
implements ISimpleSpecification {
    protected PrintWriter pw;
    private boolean isFirstConstraint = true;

    public PrettyPrint(Writer wr, String name, Iterable<String> clocks) {
        this.pw = new PrintWriter(wr);
        this.pw.println("Specification " + name + " {");
        this.pw.print("\tClock");
        for (String clock : clocks) {
            this.pw.print(" " + clock);
        }
    }

    @Override
    public void addClock(String name) {
    }

    public void finish() {
        this.pw.println();
        this.pw.println("\t]");
        this.pw.println("}");
    }

    private void startConstraints() {
        this.pw.println("\n\t[");
    }

    protected void checkFirst() {
        if (this.isFirstConstraint) {
            this.startConstraints();
        } else {
            this.pw.println();
        }
        this.isFirstConstraint = false;
        this.pw.append("\t\t");
    }

    @Override
    public void subclock(String left, String right) {
        this.checkFirst();
        this.pw.append("SubClocking ").append(left).append(" <- ").append(right);
    }

    @Override
    public void exclusion(String left, String right) {
        this.checkFirst();
        this.pw.append("Exclusion ").append(left).append(" # ").append(right);
    }

    @Override
    public void precedence(String left, String right) {
        this.checkFirst();
        this.pw.append("Precedence ");
        this.pw.append(left).append(" < ").append(right);
    }

    @Override
    public void precedence(String left, String right, int min, int max) {
        boolean par;
        this.checkFirst();
        this.pw.append("Precedence ").append(left).append(" < ");
        boolean bl = par = max != -1 || min > 0;
        if (par) {
            this.pw.append('(');
        }
        if (min > 0) {
            this.pw.append("init:").print(String.valueOf(min) + " ");
        }
        if (max != -1) {
            this.pw.append("max:").print(max);
        }
        if (par) {
            this.pw.append(") ");
        }
        this.pw.append(right);
    }

    @Override
    public void causality(String left, String right) {
        this.checkFirst();
        this.pw.append("Precedence ");
        this.pw.append(left).append(" <= ").append(right);
    }

    @Override
    public void causality(String left, String right, int min, int max) {
        boolean par;
        this.checkFirst();
        this.pw.append("Precedence ").append(left).append(" <= ");
        boolean bl = par = max != -1 || min > 0;
        if (par) {
            this.pw.append('(');
        }
        if (min > 0) {
            this.pw.append("init:").print(String.valueOf(min) + " ");
        }
        if (max != -1) {
            this.pw.append("max:").print(max);
        }
        if (par) {
            this.pw.append(") ");
        }
        this.pw.append(right);
    }

    private void prefix(String defClock, String op, String ... clocks) {
        this.checkFirst();
        this.pw.append("Let ");
        this.pw.append(defClock).append(" be ").append(op).append('(');
        this.pw.append(String.join((CharSequence)", ", clocks));
        this.pw.append(")");
    }

    @Override
    public void inf(String defClock, String ... clocks) {
        this.prefix(defClock, "inf", clocks);
    }

    @Override
    public void sup(String defClock, String ... clocks) {
        this.prefix(defClock, "sup", clocks);
    }

    private void infix(String defClock, String op, String ... clocks) {
        this.checkFirst();
        this.pw.append("Let ");
        this.pw.append(defClock).append(" be ");
        this.pw.append(String.join((CharSequence)op, clocks));
    }

    @Override
    public void union(String defClock, String ... clocks) {
        this.infix(defClock, " + ", clocks);
    }

    @Override
    public void intersection(String defClock, String ... clocks) {
        this.infix(defClock, " * ", clocks);
    }

    @Override
    public void minus(String defClock, String ... clocks) {
        this.infix(defClock, " - ", clocks);
    }

    @Override
    public void periodic(String defClock, String ref, int period, int from, int upto) {
        if (period == 1) {
            this.delayFor(defClock, ref, from, upto, null);
            return;
        }
        this.checkFirst();
        this.pw.append("repeat ");
        this.pw.append(defClock).append(" every ").print(period);
        this.pw.append(" ").print(ref);
        if (from != 0) {
            this.pw.append(" from ").print(from);
        }
        if (upto != -1) {
            this.pw.append(" upTo ").print(upto);
        }
    }

    @Override
    public void delayFor(String defClock, String ref, int from, int upto, String base) {
        this.checkFirst();
        this.pw.append(defClock).append(" = ").append(ref);
        if (base != null && from == 0) {
            this.pw.append(" sampledOn ").print(base);
        } else if (upto == -1) {
            this.pw.append(" $ ").print(from);
            if (base != null) {
                this.pw.append(" on ").print(base);
            }
        } else {
            this.pw.append("[").print(from);
            this.pw.append(", ").print(upto);
            this.pw.append("]");
        }
    }
}

