/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.contribution.xref.internal.ui.providers.TreeObject;
import org.eclipse.contribution.xref.internal.ui.providers.TreeParent;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceContentProvider;
import org.eclipse.contribution.xref.ui.IDeferredXReference;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;

public class XRefUIUtils {
    private static Map workingCopyManagersForEditors = new HashMap();
    private static boolean selectedOutsideJavaElement = false;
    static /* synthetic */ Class class$0;

    public static ISourceReference computeHighlightRangeSourceReference(JavaEditor editor) {
        ISourceViewer sourceViewer = editor.getViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = XRefUIUtils.getElementAt(editor, caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private static IJavaElement getElementAt(JavaEditor editor, int offset, boolean reconcile) {
        block20: {
            void var3_5;
            if (workingCopyManagersForEditors.get(editor) instanceof IWorkingCopyManager) {
                IWorkingCopyManager iWorkingCopyManager = (IWorkingCopyManager)workingCopyManagersForEditors.get(editor);
            } else {
                WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
            }
            ICompilationUnit unit = var3_5.getWorkingCopy(editor.getEditorInput());
            if (unit != null) {
                try {
                    if (reconcile) {
                        ICompilationUnit iCompilationUnit = unit;
                        synchronized (iCompilationUnit) {
                            unit.reconcile(0, false, null, null);
                        }
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IJavaElement[] children = unit.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i] instanceof SourceType) {
                                return children[i];
                            }
                            ++i;
                        }
                        break block20;
                    }
                    if (unit.isConsistent()) {
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IResource res = unit.getCorrespondingResource();
                        if (res instanceof IFile) {
                            IFile file = (IFile)res;
                            IProject containingProject = file.getProject();
                            IMarker[] javaModelMarkers = containingProject.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                            int i = 0;
                            while (i < javaModelMarkers.length) {
                                IMarker marker = javaModelMarkers[i];
                                if (marker.getResource().equals((Object)file)) {
                                    return null;
                                }
                                ++i;
                            }
                        }
                        if (elementAt == null && unit.getChildren().length != 0) {
                            selectedOutsideJavaElement = true;
                            return unit.getChildren()[0];
                        }
                    }
                }
                catch (JavaModelException x) {
                    if (!x.isDoesNotExist()) {
                        JavaPlugin.log((IStatus)x.getStatus());
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    public static void revealInEditor(IJavaElement j) {
        try {
            IEditorPart p = JavaUI.openInEditor((IJavaElement)j);
            JavaUI.revealInEditor((IEditorPart)p, (IJavaElement)j);
        }
        catch (Exception exception) {}
    }

    public static void revealInEditor(IResource r) {
        try {
            IMarker m = r.createMarker("org.eclipse.core.resources.marker");
            IDE.openEditor((IWorkbenchPage)XRefUIUtils.getActiveWorkbenchWindow().getActivePage(), (IMarker)m, (boolean)true);
            m.delete();
        }
        catch (CoreException coreException) {}
    }

    public static void evaluateXReferences(IDeferredXReference xr, TreeViewer viewer, Shell shell) {
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)xr);
            if (!(viewer.getContentProvider() instanceof XReferenceContentProvider)) {
                return;
            }
            ((XReferenceContentProvider)viewer.getContentProvider()).refresh();
            viewer.refresh();
            viewer.expandToLevel(3);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invEx) {
            System.err.println("Something nasty here, " + xr + " could not be evaluated: " + invEx);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return XReferenceUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static List getXRefAdapterForSelection(IWorkbenchPart part, ISelection selection, boolean showParentCrosscutting) {
        ArrayList xrefAdapterList = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement) {
                return XRefUIUtils.getXRefAdapterListForJavaElement((IJavaElement)first, showParentCrosscutting);
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return XRefUIUtils.getXRefAdapterListForJavaElement(javaElement, showParentCrosscutting);
        }
        return xrefAdapterList;
    }

    public static IJavaElement getSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement && !(first instanceof IJavaProject)) {
                return (IJavaElement)first;
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return javaElement;
        }
        return null;
    }

    public static List getXRefAdapterListForJavaElement(IJavaElement javaElement, boolean showParentCrosscutting) {
        ArrayList<Object> xrefAdapterList = new ArrayList<Object>();
        if (javaElement != null && !javaElement.exists()) {
            return xrefAdapterList;
        }
        if (javaElement != null && (showParentCrosscutting || selectedOutsideJavaElement)) {
            ICompilationUnit parent = (ICompilationUnit)javaElement.getAncestor(5);
            if (parent != null) {
                try {
                    IType[] types = parent.getAllTypes();
                    int i = 0;
                    while (i < types.length) {
                        IType a;
                        if (types[i] instanceof SourceType && types[i].getParent() instanceof ICompilationUnit && (a = types[i]) != null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            xrefAdapterList.add(a.getAdapter((Class)clazz));
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        } else {
            IJavaElement a = javaElement;
            if (a != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                xrefAdapterList.add(a.getAdapter((Class)clazz));
            }
        }
        selectedOutsideJavaElement = false;
        return xrefAdapterList;
    }

    public static ISelection getCurrentSelection() {
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getSelectionService().getSelection();
        }
        return null;
    }

    public static TreeObject getTreeObjectForSelection(TreeViewer viewer, ISelection selection, IWorkbenchPart part) {
        if (selection instanceof IStructuredSelection) {
            Object data;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement) {
                return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), (IJavaElement)first);
            }
            if (first instanceof TreeObject && (data = ((TreeObject)first).getData()) instanceof IJavaElement) {
                return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), (IJavaElement)data);
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), javaElement);
        }
        return null;
    }

    public static TreeObject getTreeObjectForJavaElement(TreeItem[] items, IJavaElement javaElement) {
        int i = 0;
        while (i < items.length) {
            Object o = items[i].getData();
            TreeParent treeParent = null;
            TreeObject treeObject = null;
            if (o instanceof TreeParent) {
                treeParent = (TreeParent)o;
            } else if (o instanceof TreeObject) {
                treeObject = (TreeObject)o;
            }
            TreeObject element = null;
            element = treeParent == null ? treeObject : treeParent;
            if (element != null && element.getData() != null && element.getData().equals(javaElement)) {
                return element;
            }
            element = XRefUIUtils.getTreeObjectForJavaElement(items[i].getItems(), javaElement);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static void setSelection(IWorkbenchPart part, ISelection selection, TreeViewer viewer) {
        TreeObject o = XRefUIUtils.getTreeObjectForSelection(viewer, selection, part);
        if (o != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)o), true);
            viewer.reveal((Object)o);
        } else if (selection != null) {
            viewer.setSelection(selection, true);
            viewer.reveal((Object)selection);
        }
    }

    public static void addWorkingCopyManagerForEditor(IEditorPart editor, IWorkingCopyManager workingCopyManager) {
        workingCopyManagersForEditors.put(editor, workingCopyManager);
    }

    public static void removeWorkingCopyManagerForEditor(IEditorPart editor) {
        workingCopyManagersForEditors.remove(editor);
    }
}

