/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.DefaultMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.engine.MoccmlExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.Future;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ClockStatus;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventSet;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventWrapper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioManager;

public class ModelSpecificEventContext {
    private MoccmlExecutionEngine _engine;
    private ModelSpecificEventSet _mseSet;
    private DefaultMSEStateController _clockController = new DefaultMSEStateController();
    private ScenarioManager _scenarioManager;
    private int _executionStep;

    public ModelSpecificEventContext(MoccmlExecutionEngine engine) {
        this._engine = engine;
        this._executionStep = (int)engine.getEngineStatus().getNbLogicalStepRun();
        this._scenarioManager = new ScenarioManager(this);
        this.configure();
    }

    private void configure() {
        MoccmlModelExecutionContext execontext = (MoccmlModelExecutionContext)this._engine.getExecutionContext();
        this._mseSet = new ModelSpecificEventSet(execontext.getFeedbackModel());
        ((MoccmlExecutionPlatform)((MoccmlModelExecutionContext)this._engine.getExecutionContext()).getExecutionPlatform()).getMSEStateControllers().add(this._clockController);
    }

    public void forceClock(ModelSpecificEventWrapper mse, ClockStatus state) {
        ArrayList<ModelSpecificEventWrapper> c = new ArrayList<ModelSpecificEventWrapper>();
        c.add(mse);
        this.forceClocks(c, state);
    }

    public void forceClocks(Collection<ModelSpecificEventWrapper> mses, ClockStatus state) {
        for (ModelSpecificEventWrapper mse : mses) {
            if (mse.getState() == state) continue;
            this.setState(mse, state);
        }
        this._engine.recomputePossibleLogicalSteps();
    }

    public ModelSpecificEventWrapper getMSE(String clockName) {
        return this._mseSet.getMSE(clockName);
    }

    private void setState(ModelSpecificEventWrapper wrapper, ClockStatus state) {
        wrapper.setState(state);
        boolean isForced = state.isForced();
        Future future = state.getState();
        if (isForced) {
            if (future.equals((Object)Future.TICK)) {
                this._clockController.forcePresenceInTheFuture(wrapper.getMSE());
            } else {
                this._clockController.forceAbsenceTickInTheFuture(wrapper.getMSE());
            }
        } else {
            this._clockController.freeInTheFuture(wrapper.getMSE());
        }
    }

    public void refreshFutureTickingFreeClocks() {
        for (ModelSpecificEventWrapper mse : this._mseSet.getMSEs()) {
            if (mse.getState().isForced().booleanValue()) continue;
            mse.setState(ClockStatus.NOTFORCED_NOTSET);
        }
    }

    public ScenarioManager getScenarioManager() {
        return this._scenarioManager;
    }

    public int getCacheStep() {
        return this._executionStep;
    }

    public void setCacheStep(int cacheStep) {
        this._executionStep = cacheStep;
    }

    public void freeAllClocks() {
        for (ModelSpecificEventWrapper mse : this._mseSet.getMSEs()) {
            this.setState(mse, ClockStatus.NOTFORCED_NOTSET);
        }
    }

    public Collection<ModelSpecificEventWrapper> getMSEs() {
        return this._mseSet.getMSEs();
    }

    public MoccmlExecutionEngine getEngine() {
        return this._engine;
    }

    public ModelSpecificEventSet getMSESet() {
        return this._mseSet;
    }
}

