/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.MoccmlModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.EventState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.ExecutionStep;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.stimuliscenario.Reference;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ClockStatus;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventWrapper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioTool;

public class ScenarioRecorder
extends ScenarioTool {
    public ScenarioRecorder(ModelSpecificEventContext mseContext) {
        super(mseContext);
    }

    private void createResource() {
        ResourceSet rs = ((MoccmlModelExecutionContext)this._mseContext.getEngine().getExecutionContext()).getResourceModel().getResourceSet();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
        String fileName = String.valueOf(format.format(new Date())) + ".scenario";
        URI uri = URI.createURI((String)("platform:/resource" + ((MoccmlModelExecutionContext)this._mseContext.getEngine().getExecutionContext()).getWorkspace().getExecutionPath().append(fileName).toString()));
        this._resource = rs.createResource(uri);
    }

    private void createScenario() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScenarioRecorder.this._scenario = ScenarioRecorder.this._factory.createScenario();
                ScenarioRecorder.this._resource.getContents().add((Object)ScenarioRecorder.this._scenario);
                ScenarioRecorder.this.save();
            }
        };
        this.safeModelModification(runnable, "create scenario");
    }

    public void startRecord() {
        if (this._scenario == null) {
            this.createResource();
            this.createScenario();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EList refList = ScenarioRecorder.this._scenario.getRefList();
                Reference ref = ScenarioRecorder.this._factory.createReference();
                ref.setStartStep((int)ScenarioRecorder.this._mseContext.getEngine().getEngineStatus().getNbLogicalStepRun());
                refList.add(ref);
                ScenarioRecorder.this._fragment = ScenarioRecorder.this._factory.createFragment();
                ref.setFragment(ScenarioRecorder.this._fragment);
            }
        };
        this.safeModelModification(runnable, "start record scenario");
    }

    public void record() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EList stepList = ScenarioRecorder.this._fragment.getStepList();
                ExecutionStep newStep = ScenarioRecorder.this._factory.createExecutionStep();
                EList newListEvent = newStep.getEventList();
                for (ModelSpecificEventWrapper cw : ScenarioRecorder.this._mseContext.getMSEs()) {
                    ClockStatus state = cw.getState();
                    boolean isForced = state.isForced();
                    if (!isForced) continue;
                    EventState newState = ScenarioRecorder.this._factory.createEventState();
                    newState.setMse(cw.getMSE());
                    newState.setState(state.getState());
                    newListEvent.add(newState);
                }
                stepList.add(newStep);
                ScenarioRecorder.this.save();
            }
        };
        this.safeModelModification(runnable, "record scenario");
    }

    protected void save() {
        try {
            this._resource.save(null);
        }
        catch (IOException e) {
            String message = "Cannot save scenario, see inner exception";
            Activator.getDefault();
            Activator.error(message, e);
        }
    }
}

