/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.BehavioralInterface;
import org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface.Event;
import org.eclipse.gemoc.executionframework.event.manager.BehavioralUnitNotification;
import org.eclipse.gemoc.executionframework.event.manager.CallNotification;
import org.eclipse.gemoc.executionframework.event.manager.EventManagerUtils;
import org.eclipse.gemoc.executionframework.event.manager.ICallRequest;
import org.eclipse.gemoc.executionframework.event.manager.IImplementationRelationship;
import org.eclipse.gemoc.executionframework.event.manager.ReturnNotification;
import org.eclipse.gemoc.executionframework.event.manager.SimpleCallRequest;
import org.eclipse.gemoc.executionframework.event.model.event.EventFactory;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrence;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrenceArgument;
import org.eclipse.gemoc.executionframework.event.model.event.EventOccurrenceType;

public class SimpleImplementationRelationship
implements IImplementationRelationship {
    private final BehavioralInterface behavioralInterface;
    private final Map<String, Event> behavioralUnitToEvent = new HashMap<String, Event>();
    private final Function<BehavioralUnitNotification, EventOccurrence> behavioralUnitNotificationToEventOccurrence;
    private final Function<EventOccurrence, ICallRequest> eventOccurrenceToCallRequest;
    private Consumer<EventOccurrence> eventOccurrenceConsumer;
    private Consumer<ICallRequest> callRequestConsumer;
    private final Set<String> runToCompletionSet;

    public SimpleImplementationRelationship(BehavioralInterface behavioralInterface, Set<String> runToCompletionSet, String metalanguage) {
        this(behavioralInterface, runToCompletionSet, new HashMap<String, String>(), metalanguage);
    }

    public SimpleImplementationRelationship(BehavioralInterface behavioralInterface, Set<String> runToCompletionSet, Map<String, String> eventNameToExecutionRule, String metalanguage) {
        this.behavioralInterface = behavioralInterface;
        this.runToCompletionSet = runToCompletionSet;
        this.behavioralUnitNotificationToEventOccurrence = notification -> {
            boolean isCallNotification = notification instanceof CallNotification;
            String behavioralUnit = notification.getBehavioralUnit();
            String eventName = eventNameToExecutionRule.containsValue(behavioralUnit) ? eventNameToExecutionRule.entrySet().stream().filter(e -> ((String)e.getValue()).equals(behavioralUnit)).findFirst().map(e -> (String)e.getKey()).get() : String.valueOf(notification.getBehavioralUnit()) + (isCallNotification ? "_called" : "_returned");
            Event event = this.behavioralUnitToEvent.computeIfAbsent(eventName, k -> behavioralInterface.getEvents().stream().filter(e -> e.getName().equals(k)).findFirst().orElse(null));
            if (event != null) {
                EventOccurrence eventOccurrence = EventFactory.eINSTANCE.createEventOccurrence();
                eventOccurrence.setEvent(event);
                eventOccurrence.setType(EventOccurrenceType.EXPOSED);
                event.getParams().stream().forEach(p -> notification.getArguments().entrySet().stream().filter(a -> p.getName().equals(a.getKey())).findFirst().ifPresent(a -> {
                    EventOccurrenceArgument arg = EventFactory.eINSTANCE.createEventOccurrenceArgument();
                    arg.setValue(EventManagerUtils.convertObjectToValue(a.getValue()));
                    arg.setParameter(p);
                    eventOccurrence.getArgs().add((Object)arg);
                }));
                if (!isCallNotification) {
                    event.getParams().stream().filter(p -> p.getName().equals(String.valueOf(notification.getBehavioralUnit()) + "_result")).findFirst().ifPresent(p -> {
                        EventOccurrenceArgument arg = EventFactory.eINSTANCE.createEventOccurrenceArgument();
                        arg.setValue(EventManagerUtils.convertObjectToValue(((ReturnNotification)notification).getResult()));
                        arg.setParameter(p);
                        eventOccurrence.getArgs().add((Object)arg);
                    });
                }
                return eventOccurrence;
            }
            return null;
        };
        this.eventOccurrenceToCallRequest = eventOccurrence -> {
            if (eventOccurrence.getType() == EventOccurrenceType.ACCEPTED) {
                String eventName = eventOccurrence.getEvent().getName();
                String name = eventNameToExecutionRule.computeIfAbsent(eventName, s -> s.substring(5));
                List<Object> arguments = eventOccurrence.getArgs().stream().map(a -> EventManagerUtils.convertValueToObject(a.getValue())).collect(Collectors.toList());
                boolean rtc = this.runToCompletionSet.contains(name);
                return new SimpleCallRequest(name, arguments, rtc, metalanguage);
            }
            return null;
        };
    }

    @Override
    public BehavioralInterface getBehavioralInterface() {
        return this.behavioralInterface;
    }

    @Override
    public void processEventOccurrence(EventOccurrence eventOccurrence) {
        ICallRequest callRequest = this.eventOccurrenceToCallRequest.apply(eventOccurrence);
        this.callRequestConsumer.accept(callRequest);
    }

    @Override
    public void processCallNotification(CallNotification notification) {
        this.processBehavioralUnitNotification(notification);
    }

    @Override
    public void processReturnNotification(ReturnNotification notification) {
        this.processBehavioralUnitNotification(notification);
    }

    private void processBehavioralUnitNotification(BehavioralUnitNotification notification) {
        EventOccurrence eventOccurrence = this.behavioralUnitNotificationToEventOccurrence.apply(notification);
        if (eventOccurrence != null) {
            this.eventOccurrenceConsumer.accept(eventOccurrence);
        }
    }

    @Override
    public void configure(Consumer<EventOccurrence> eventOccurrenceConsumer, Consumer<ICallRequest> callRequestConsumer) {
        this.eventOccurrenceConsumer = eventOccurrenceConsumer;
        this.callRequestConsumer = callRequestConsumer;
    }
}

