/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.HideFilter;
import org.eclipse.sirius.diagram.HideLabelFilter;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;

public class DDiagramHiddenElementsUpdater
extends ResourceSetListenerImpl {
    private DDiagram dDiagram;
    private Set<DDiagramElement> newElementsToHide;
    private Set<DDiagramElement> newElementsToReveal;

    public DDiagramHiddenElementsUpdater(TransactionalEditingDomain domain, DDiagram dDiagram) {
        super(NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters())));
        domain.addResourceSetListener((ResourceSetListener)this);
        this.dDiagram = dDiagram;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand cmd = null;
        this.newElementsToHide = new HashSet<DDiagramElement>();
        this.newElementsToReveal = new HashSet<DDiagramElement>();
        this.computeElementsToHideAndReveal(event.getNotifications());
        CompoundCommand compoundCommand = new CompoundCommand();
        if (!this.newElementsToHide.isEmpty()) {
            Command hideDDiagramEltCmd = AddCommand.create((EditingDomain)this.getTarget(), (Object)this.dDiagram, (Object)DiagramPackage.Literals.DDIAGRAM__HIDDEN_ELEMENTS, this.newElementsToHide);
            compoundCommand.append(hideDDiagramEltCmd);
        }
        if (!this.newElementsToReveal.isEmpty()) {
            Command revealDDiagramEltCmd = RemoveCommand.create((EditingDomain)this.getTarget(), (Object)this.dDiagram, (Object)DiagramPackage.Literals.DDIAGRAM__HIDDEN_ELEMENTS, this.newElementsToReveal);
            compoundCommand.append(revealDDiagramEltCmd);
        }
        if (!compoundCommand.isEmpty()) {
            cmd = compoundCommand;
        }
        this.newElementsToHide = null;
        this.newElementsToReveal = null;
        return cmd;
    }

    private void computeElementsToHideAndReveal(List<Notification> notifications) {
        for (Notification notification : notifications) {
            DDiagramElement dDiagramElement;
            DDiagram parentDDiagram;
            if (!(notification.getNotifier() instanceof DDiagramElement) || (parentDDiagram = (dDiagramElement = (DDiagramElement)notification.getNotifier()).getParentDiagram()) == null || !parentDDiagram.equals(this.dDiagram)) continue;
            if (notification.getNewValue() instanceof HideLabelFilter && notification.getOldValue() == null) {
                if (new DDiagramElementQuery(dDiagramElement).isHidden()) continue;
                this.newElementsToHide.add(dDiagramElement);
                continue;
            }
            if (notification.getOldValue() instanceof HideLabelFilter && notification.getNewValue() == null) {
                if (new DDiagramElementQuery(dDiagramElement).isHidden()) continue;
                this.newElementsToReveal.add(dDiagramElement);
                continue;
            }
            if (notification.getNewValue() instanceof HideFilter && notification.getOldValue() == null) {
                if (new DDiagramElementQuery(dDiagramElement).isLabelHidden()) continue;
                this.newElementsToHide.add(dDiagramElement);
                continue;
            }
            if (!(notification.getOldValue() instanceof HideFilter) || notification.getNewValue() != null || new DDiagramElementQuery(dDiagramElement).isLabelHidden()) continue;
            this.newElementsToReveal.add(dDiagramElement);
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.dDiagram = null;
    }
}

