/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.WorkspaceResourceChangeListenerImpl;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;

public class WorkspaceFileResourceChangeListener
implements IResourceChangeListener {
    private Map<String, File> uriToFileMap = new HashMap<String, File>();
    private Map<File, Boolean> readStatusFileMap = new HashMap<File, Boolean>();
    private Map<File, URL> fileURLMap = new HashMap<File, URL>();

    public static WorkspaceFileResourceChangeListener getInstance() {
        return WorkspaceResourceChangeListenerHolder.instance;
    }

    public void init() {
        throw new UnsupportedOperationException();
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    protected ResourceDeltaVisitor getResourceDeltaVisitor() {
        return new ResourceDeltaVisitor();
    }

    public File getFileFromURI(String uri) {
        if (this.uriToFileMap.containsKey(uri)) {
            return this.uriToFileMap.get(uri);
        }
        File file = FileProvider.getDefault().getFile((IPath)new Path(uri));
        this.uriToFileMap.put(uri, file);
        return file;
    }

    public boolean hasURIOfFile(String uri) {
        return this.uriToFileMap.containsKey(uri);
    }

    public boolean getReadStatusOfFile(File file) {
        if (this.readStatusFileMap.containsKey(file)) {
            return this.readStatusFileMap.get(file);
        }
        boolean fileStatus = file != null && file.exists() && file.canRead();
        this.readStatusFileMap.put(file, fileStatus);
        try {
            this.fileURLMap.put(file, file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.diagram.ui", e.getMessage()));
        }
        return fileStatus;
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
        this.uriToFileMap.clear();
        this.readStatusFileMap.clear();
        this.fileURLMap.clear();
    }

    public void removeFileStatusAndURIFromMaps(String uri) {
        this.readStatusFileMap.remove(this.uriToFileMap.get(uri));
        this.fileURLMap.remove(this.uriToFileMap.get(uri));
        this.uriToFileMap.remove(uri);
    }

    public ImageDescriptor findImageDescriptor(File file) throws MalformedURLException {
        if (this.fileURLMap.containsKey(file)) {
            return DiagramUIPlugin.Implementation.getURLImageDescriptor(this.fileURLMap.get(file));
        }
        return DiagramUIPlugin.Implementation.getURLImageDescriptor(file.toURI().toURL());
    }

    protected class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        List<String> changedFilesURI = Lists.newArrayList();

        protected boolean visitFile(IResourceDelta delta, IFile file) {
            String uri = file.getFullPath().makeRelative().toString();
            if (WorkspaceFileResourceChangeListener.this.hasURIOfFile(uri)) {
                this.changedFilesURI.add(uri);
            }
            return false;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean visitChildren = true;
            IResource res = delta.getResource();
            if (res.getType() == 1) {
                visitChildren = this.visitFile(delta, (IFile)res);
            }
            return visitChildren;
        }
    }

    private static class WorkspaceResourceChangeListenerHolder {
        private static WorkspaceFileResourceChangeListener instance = new WorkspaceResourceChangeListenerImpl();

        static {
            instance.init();
        }

        private WorkspaceResourceChangeListenerHolder() {
        }
    }
}

