/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.ast.NamingHelper;
import fr.inria.diverse.melange.jvmmodel.JvmModelInferrerHelper;
import fr.inria.diverse.melange.jvmmodel.MelangeTypesBuilder;
import fr.inria.diverse.melange.lib.EcoreExtensions;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @deprecated Model types are now generated using EMF's Genmodels,
 *               this shouldn't be used anymore
 */
@SuppressWarnings("all")
public class MetaclassInterfaceInferrer {
  @Inject
  @Extension
  private JvmModelInferrerHelper _jvmModelInferrerHelper;
  
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private NamingHelper _namingHelper;
  
  @Inject
  @Extension
  private EcoreExtensions _ecoreExtensions;
  
  @Inject
  @Extension
  private MelangeTypesBuilder _melangeTypesBuilder;
  
  /**
   * Creates an interface based on the elements defined in {@link cls}
   * and provides it to the current {@link acceptor}
   */
  public void generateInterface(final ModelType mt, final EClass cls, final IJvmDeclaredTypeAcceptor acceptor, @Extension final JvmTypeReferenceBuilder builder) {
    final Stopwatches.StoppedTask task = Stopwatches.forTask("generate metaclass interfaces");
    task.start();
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType intf) {
        EList<JvmTypeReference> _superTypes = intf.getSuperTypes();
        JvmTypeReference _typeRef = builder.typeRef(EObject.class);
        MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
      }
    };
    final Procedure1<JvmGenericType> _function_1 = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType intf) {
        final Consumer<ETypeParameter> _function = new Consumer<ETypeParameter>() {
          @Override
          public void accept(final ETypeParameter p) {
            EList<JvmTypeParameter> _typeParameters = intf.getTypeParameters();
            JvmTypeParameter _createJvmTypeParameter = TypesFactory.eINSTANCE.createJvmTypeParameter();
            final Procedure1<JvmTypeParameter> _function = new Procedure1<JvmTypeParameter>() {
              @Override
              public void apply(final JvmTypeParameter it) {
                it.setName(p.getName());
              }
            };
            JvmTypeParameter _doubleArrow = ObjectExtensions.<JvmTypeParameter>operator_doubleArrow(_createJvmTypeParameter, _function);
            MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmTypeParameter>operator_add(_typeParameters, _doubleArrow);
          }
        };
        cls.getETypeParameters().forEach(_function);
        final Consumer<EGenericType> _function_1 = new Consumer<EGenericType>() {
          @Override
          public void accept(final EGenericType sup) {
            EList<JvmTypeReference> _superTypes = intf.getSuperTypes();
            EClassifier _eClassifier = sup.getEClassifier();
            final Function1<EGenericType, JvmTypeReference> _function = new Function1<EGenericType, JvmTypeReference>() {
              @Override
              public JvmTypeReference apply(final EGenericType arg) {
                return MetaclassInterfaceInferrer.this._melangeTypesBuilder.typeRef(mt, arg, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(intf)));
              }
            };
            JvmTypeReference _typeRef = builder.typeRef(MetaclassInterfaceInferrer.this._namingHelper.getFqnFor(mt, ((EClass) _eClassifier)), 
              ((JvmTypeReference[])Conversions.unwrapArray(ListExtensions.<EGenericType, JvmTypeReference>map(sup.getETypeArguments(), _function), JvmTypeReference.class)));
            MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
          }
        };
        cls.getEGenericSuperTypes().forEach(_function_1);
        final Consumer<EAttribute> _function_2 = new Consumer<EAttribute>() {
          @Override
          public void accept(final EAttribute attr) {
            final JvmTypeReference attrType = MetaclassInterfaceInferrer.this._melangeTypesBuilder.typeRef(mt, attr, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(intf)));
            EList<JvmMember> _members = intf.getMembers();
            JvmOperation _getterSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toGetterSignature(mt, attr, attrType);
            MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _getterSignature);
            boolean _needsSetterInterface = MetaclassInterfaceInferrer.this._ecoreExtensions.needsSetterInterface(attr);
            if (_needsSetterInterface) {
              EList<JvmMember> _members_1 = intf.getMembers();
              JvmOperation _setterSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toSetterSignature(mt, attr, attrType);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _setterSignature);
            }
            boolean _needsUnsetterInterface = MetaclassInterfaceInferrer.this._ecoreExtensions.needsUnsetterInterface(attr);
            if (_needsUnsetterInterface) {
              EList<JvmMember> _members_2 = intf.getMembers();
              JvmOperation _unsetterSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toUnsetterSignature(mt, attr);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _unsetterSignature);
            }
            boolean _needsUnsetterCheckerInterface = MetaclassInterfaceInferrer.this._ecoreExtensions.needsUnsetterCheckerInterface(attr);
            if (_needsUnsetterCheckerInterface) {
              EList<JvmMember> _members_3 = intf.getMembers();
              JvmOperation _unsetterCheckSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toUnsetterCheckSignature(mt, attr);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _unsetterCheckSignature);
            }
          }
        };
        cls.getEAttributes().forEach(_function_2);
        final Consumer<EReference> _function_3 = new Consumer<EReference>() {
          @Override
          public void accept(final EReference ref) {
            final JvmTypeReference refType = MetaclassInterfaceInferrer.this._melangeTypesBuilder.typeRef(mt, ref, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(intf)));
            boolean _isEMFMapDetails = MetaclassInterfaceInferrer.this._ecoreExtensions.isEMFMapDetails(ref);
            if (_isEMFMapDetails) {
              EList<JvmMember> _members = intf.getMembers();
              final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
                @Override
                public void apply(final JvmOperation it) {
                  it.setAbstract(true);
                }
              };
              JvmOperation _method = MetaclassInterfaceInferrer.this._jvmTypesBuilder.toMethod(mt, "getDetails", 
                builder.typeRef(EMap.class, builder.typeRef(String.class), builder.typeRef(String.class)), _function);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
            } else {
              EList<JvmMember> _members_1 = intf.getMembers();
              JvmOperation _getterSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toGetterSignature(mt, ref, refType);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _getterSignature);
            }
            boolean _needsSetterInterface = MetaclassInterfaceInferrer.this._ecoreExtensions.needsSetterInterface(ref);
            if (_needsSetterInterface) {
              EList<JvmMember> _members_2 = intf.getMembers();
              JvmOperation _setterSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toSetterSignature(mt, ref, refType);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _setterSignature);
            }
            boolean _needsUnsetterInterface = MetaclassInterfaceInferrer.this._ecoreExtensions.needsUnsetterInterface(ref);
            if (_needsUnsetterInterface) {
              EList<JvmMember> _members_3 = intf.getMembers();
              JvmOperation _unsetterSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toUnsetterSignature(mt, ref);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _unsetterSignature);
            }
            boolean _needsUnsetterCheckerInterface = MetaclassInterfaceInferrer.this._ecoreExtensions.needsUnsetterCheckerInterface(ref);
            if (_needsUnsetterCheckerInterface) {
              EList<JvmMember> _members_4 = intf.getMembers();
              JvmOperation _unsetterCheckSignature = MetaclassInterfaceInferrer.this._jvmModelInferrerHelper.toUnsetterCheckSignature(mt, ref);
              MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_4, _unsetterCheckSignature);
            }
          }
        };
        cls.getEReferences().forEach(_function_3);
        final Function1<EOperation, Boolean> _function_4 = new Function1<EOperation, Boolean>() {
          @Override
          public Boolean apply(final EOperation it) {
            boolean _hasSuppressedVisibility = MetaclassInterfaceInferrer.this._ecoreExtensions.hasSuppressedVisibility(it);
            return Boolean.valueOf((!_hasSuppressedVisibility));
          }
        };
        final Consumer<EOperation> _function_5 = new Consumer<EOperation>() {
          @Override
          public void accept(final EOperation op) {
            String _xifexpression = null;
            boolean _isUml = MetaclassInterfaceInferrer.this._ecoreExtensions.isUml(cls.getEPackage());
            boolean _not = (!_isUml);
            if (_not) {
              _xifexpression = op.getName();
            } else {
              _xifexpression = MetaclassInterfaceInferrer.this._namingHelper.formatUmlOperationName(op);
            }
            final String opName = _xifexpression;
            EList<JvmMember> _members = intf.getMembers();
            final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation m) {
                m.setAbstract(true);
                final Consumer<ETypeParameter> _function = new Consumer<ETypeParameter>() {
                  @Override
                  public void accept(final ETypeParameter t) {
                    EList<JvmTypeParameter> _typeParameters = m.getTypeParameters();
                    JvmTypeParameter _createJvmTypeParameter = TypesFactory.eINSTANCE.createJvmTypeParameter();
                    final Procedure1<JvmTypeParameter> _function = new Procedure1<JvmTypeParameter>() {
                      @Override
                      public void apply(final JvmTypeParameter tp) {
                        tp.setName(t.getName());
                      }
                    };
                    JvmTypeParameter _doubleArrow = ObjectExtensions.<JvmTypeParameter>operator_doubleArrow(_createJvmTypeParameter, _function);
                    MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmTypeParameter>operator_add(_typeParameters, _doubleArrow);
                  }
                };
                op.getETypeParameters().forEach(_function);
                final Consumer<ETypeParameter> _function_1 = new Consumer<ETypeParameter>() {
                  @Override
                  public void accept(final ETypeParameter t) {
                    final Consumer<EGenericType> _function = new Consumer<EGenericType>() {
                      @Override
                      public void accept(final EGenericType b) {
                        final Function1<JvmTypeParameter, Boolean> _function = new Function1<JvmTypeParameter, Boolean>() {
                          @Override
                          public Boolean apply(final JvmTypeParameter it) {
                            String _name = it.getName();
                            String _name_1 = t.getName();
                            return Boolean.valueOf(Objects.equal(_name, _name_1));
                          }
                        };
                        final JvmTypeParameter tp = IterableExtensions.<JvmTypeParameter>findFirst(m.getTypeParameters(), _function);
                        EClassifier _eClassifier = b.getEClassifier();
                        boolean _tripleNotEquals = (_eClassifier != null);
                        if (_tripleNotEquals) {
                          EList<JvmTypeConstraint> _constraints = tp.getConstraints();
                          JvmUpperBound _createJvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                          final Procedure1<JvmUpperBound> _function_1 = new Procedure1<JvmUpperBound>() {
                            @Override
                            public void apply(final JvmUpperBound it) {
                              it.setTypeReference(MetaclassInterfaceInferrer.this._melangeTypesBuilder.typeRef(mt, b, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, intf))));
                            }
                          };
                          JvmUpperBound _doubleArrow = ObjectExtensions.<JvmUpperBound>operator_doubleArrow(_createJvmUpperBound, _function_1);
                          MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmTypeConstraint>operator_add(_constraints, _doubleArrow);
                        } else {
                          ETypeParameter _eTypeParameter = b.getETypeParameter();
                          boolean _tripleNotEquals_1 = (_eTypeParameter != null);
                          if (_tripleNotEquals_1) {
                            EList<JvmTypeConstraint> _constraints_1 = tp.getConstraints();
                            JvmUpperBound _createJvmUpperBound_1 = TypesFactory.eINSTANCE.createJvmUpperBound();
                            final Procedure1<JvmUpperBound> _function_2 = new Procedure1<JvmUpperBound>() {
                              @Override
                              public void apply(final JvmUpperBound it) {
                                it.setTypeReference(
                                  MetaclassInterfaceInferrer.this._melangeTypesBuilder.createTypeParameterReference(
                                    new JvmTypeParameterDeclarator[] { m, intf }, b.getETypeParameter().getName()));
                              }
                            };
                            JvmUpperBound _doubleArrow_1 = ObjectExtensions.<JvmUpperBound>operator_doubleArrow(_createJvmUpperBound_1, _function_2);
                            MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmTypeConstraint>operator_add(_constraints_1, _doubleArrow_1);
                          }
                        }
                      }
                    };
                    t.getEBounds().forEach(_function);
                  }
                };
                op.getETypeParameters().forEach(_function_1);
                final Consumer<EParameter> _function_2 = new Consumer<EParameter>() {
                  @Override
                  public void accept(final EParameter p) {
                    EList<JvmFormalParameter> _parameters = m.getParameters();
                    JvmFormalParameter _parameter = MetaclassInterfaceInferrer.this._jvmTypesBuilder.toParameter(mt, p.getName(), 
                      MetaclassInterfaceInferrer.this._melangeTypesBuilder.typeRef(mt, p, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, intf))));
                    MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                  }
                };
                op.getEParameters().forEach(_function_2);
                final Consumer<EClassifier> _function_3 = new Consumer<EClassifier>() {
                  @Override
                  public void accept(final EClassifier e) {
                    EList<JvmTypeReference> _exceptions = m.getExceptions();
                    JvmTypeReference _typeRef = MetaclassInterfaceInferrer.this._melangeTypesBuilder.typeRef(mt, e, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, intf)));
                    MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
                  }
                };
                op.getEExceptions().forEach(_function_3);
                final Consumer<EGenericType> _function_4 = new Consumer<EGenericType>() {
                  @Override
                  public void accept(final EGenericType e) {
                  }
                };
                op.getEGenericExceptions().forEach(_function_4);
              }
            };
            JvmOperation _method = MetaclassInterfaceInferrer.this._jvmTypesBuilder.toMethod(mt, opName, null, _function);
            final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation m) {
                m.setReturnType(MetaclassInterfaceInferrer.this._melangeTypesBuilder.typeRef(mt, op, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, intf))));
              }
            };
            JvmOperation _doubleArrow = ObjectExtensions.<JvmOperation>operator_doubleArrow(_method, _function_1);
            MetaclassInterfaceInferrer.this._jvmTypesBuilder.<JvmMember>operator_add(_members, _doubleArrow);
          }
        };
        IterableExtensions.<EOperation>filter(cls.getEOperations(), _function_4).forEach(_function_5);
      }
    };
    acceptor.<JvmGenericType>accept(this._jvmTypesBuilder.toInterface(mt, this._namingHelper.getFqnFor(mt, cls), _function), _function_1);
    task.stop();
  }
}
