/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.lightccsl.core.stepper;

import fr.kairos.lightccsl.core.stepper.ClockStatus;
import fr.kairos.lightccsl.core.stepper.IStep;
import java.util.Iterator;

final class StepIterableFilter
implements Iterable<Integer> {
    private IStep step;
    private ClockStatus expected;

    StepIterableFilter(ClockStatus expected, IStep step) {
        this.expected = expected;
        this.step = step;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new MyIterator();
    }

    class MyIterator
    implements Iterator<Integer> {
        private int pos = -1;

        MyIterator() {
            this.findNext();
        }

        private void findNext() {
            do {
                ++this.pos;
            } while (this.pos < StepIterableFilter.this.step.size() && StepIterableFilter.this.step.status(this.pos, new boolean[0]) != StepIterableFilter.this.expected);
        }

        @Override
        public boolean hasNext() {
            return this.pos < StepIterableFilter.this.step.size();
        }

        @Override
        public Integer next() {
            int res = this.pos;
            this.findNext();
            return res;
        }
    }
}

